package com.ejianc.business.finance.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondDownBackEntity;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.service.IBondDownBackService;
import com.ejianc.business.finance.vo.BondDownBackVO;
import com.ejianc.business.finance.vo.BondDownDealRentVO;
import com.ejianc.business.finance.vo.BondUpBackVO;
import com.ejianc.business.finance.vo.BondUpVO;
import com.ejianc.business.labor.vo.WorkerEnterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 保证金退还表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@RestController
@RequestMapping("/bondDownBack")
public class BondDownBackController {
    @Autowired
    private IBondDownBackService service;

    @Autowired
    private IOrgApi orgApi;
    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param bondDownBackVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BondDownBackVO> saveOrUpdate(@RequestBody BondDownBackVO bondDownBackVO) {
        BondDownBackVO backVO = service.insertOrUpdate(bondDownBackVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description  查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondDownDealRentVO> queryDetail(Long id) {
        BondDownDealRentVO backVO = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }
    @RequestMapping(value = "/queryDetailByNew", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondDownBackVO> queryDetailByNew(Long id) {
        BondDownBackEntity entity = service.selectById(id);
        BondDownBackVO map = BeanMapper.map(entity, BondDownBackVO.class);
        return CommonResponse.success("查询详情数据成功！", map);
    }


    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BondDownBackVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("bondCode");
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<BondDownBackEntity> page = service.queryPage(param, false);
        IPage<BondDownBackVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BondDownBackVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BondDownBackVO> vos) {
        service.deleteNew(vos);
        return CommonResponse.success("删除成功");
    }
    @RequestMapping(value = "/totalAlreadyBackMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> totalAlreadyBackMny(Long bondId){
        return service.totalAlreadyBackMny(bondId,null);
    }
    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BondDownBackVO> list = new ArrayList<>();
        CommonResponse<IPage<BondDownBackVO>> iPageCommonResponse = queryList(param);
        if (iPageCommonResponse.isSuccess()) {
            list = iPageCommonResponse.getData().getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (BondDownBackVO vo : list) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setCreateTimeName(dateFormat.format(vo.getCreateTime()));

        }
        beans.put("records", list);
        ExcelExport.getInstance().export("bondDownBack-export.xlsx", beans, response);
    }
}
