package com.ejianc.business.finance.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.vo.PayReportedVO;
import com.ejianc.business.finance.vo.RequestPaymentReportVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.finance.bean.PayReportedEntity;

import java.util.List;

/**
 * 内部付款报备表
 * 
 * @author generator
 * 
 */
public interface IPayReportedService extends IBaseService<PayReportedEntity> {

    List<PayReportedVO> queryRefPayData(Page<PayReportedVO> page, String sql);

    /**
     * 批量保存报备数据
     * @param vo 报备数据
     */
    List<PayReportedEntity> batchSaveReport(List<RequestPaymentReportVO> vo);

    /**
     * 根据付款ID查询请款报备列表
     * @param paymentIds 付款id
     * @return 请款报备列表
     */
    List<PayReportedVO> queryRequestPaymentReportList(List<Long> paymentIds);
}
