package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.vo.PayInvoiceUseVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-05-28
 */
@Controller
@RequestMapping("/payInvoice")
public class PayInvoiceController {

    @Autowired
    private IPayInvoiceService invoiceService;

    @Autowired
    private IInvoiceApi invoiceApi;

    @Autowired
    private IOrgApi orgApi;

    /**
     * @Author yqls
     * @Date 2020/6/08
     * @Description refer 收票列表参照
     *
     * @Param [pageNumber, pageSize, searchText]
     * @Return com.alibaba.fastjson.JSONObject
     */
    @RequestMapping(value = "/refer")
    @ResponseBody
    public CommonResponse<JSONObject> refer(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("invoiceCode");
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        if (StringUtils.isNotBlank(condition)) {
            JSONObject obj = JSONObject.parseObject(condition);
            if (condition.contains("orgId")) {
                queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, obj.getLong("orgId")));
            }
            if (condition.contains("contractId")) {
                queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, obj.getLong("contractId")));
            }
        }
        // 过滤报销申请单占用发票
        List<PayInvoiceEntity> invoiceList = invoiceService.list(new QueryWrapper<PayInvoiceEntity>().eq("use_flag", 2));
        if (!invoiceList.isEmpty()) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NOT_IN, invoiceList.stream().map(PayInvoiceEntity::getInvoiceId).collect(Collectors.toList())));
        }
        CommonResponse<JSONObject> page = invoiceApi.invoiceReceiveRef(queryParam);
        return page;
    }


    /**
     * @description: 查询使用此发票的合同付款、零星付款、费用报销列表
     *
     * @return {@link com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.finance.vo.PayRecordVO>>}
     * @author songlx
     * @date: 2022/12/30
     */
    @RequestMapping(value = "/queryUseList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<PayInvoiceUseVO>> queryUseList(@RequestBody PayInvoiceUseVO payInvoiceUseVO) {
        List<PayInvoiceUseVO> list = invoiceService.queryUseList(payInvoiceUseVO.getInvoiceId());
        return CommonResponse.success("查询使用此发票的合同付款、零星付款、费用报销列表数据成功！", list);
    }


    /**
     * @description: 查询使用此发票(开票)的收款登记列表
     *
     * @return {@link com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.finance.vo.PayRecordVO>>}
     * @author songlx
     * @date: 2022/12/30
     */
    @RequestMapping(value = "/queryOpenUseList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<PayInvoiceUseVO>> queryOpenUseList(@RequestBody PayInvoiceUseVO payInvoiceUseVO) {
        List<PayInvoiceUseVO> list = invoiceService.queryOpenUseList(payInvoiceUseVO.getInvoiceId());
        return CommonResponse.success("查询使用此发票的收款登记列表数据成功！", list);
    }

}
