package com.ejianc.business.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 投标保证金申请
 *
 * @author generator
 *
 */
 @TableName("ejc_finance_bid_bond")
public class BidBondEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 申请编码
    @TableField(value="bond_status")
    private String bondStatus; // 保证金状态:0-待处理，1-有效
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 申请金额
    @TableField(value="begin_date")
    private Date beginDate; // 预计使用时间
    @TableField(value="end_date")
    private Date endDate; // 预计退还时间
    @TableField(value="memo")
    private String memo; // 申请说明
    @TableField(value="opportunity_id")
    private Long opportunityId; // 商机
    @TableField(value="opportunity_name")
    private String opportunityName; // 商机名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="apply_employee_id")
    private Long applyEmployeeId; // 申请人
    @TableField(value="apply_employee_name")
    private String applyEmployeeName; // 申请人名称
    @TableField(value="apply_time")
    private Date applyTime; // 申请时间
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="customer_id")
    private Long customerId; // 收款单位
    @TableField(value="customer_name")
    private String customerName; // 收款单位名称
    @TableField(value="bond_scale")
    private BigDecimal bondScale; // 保证金比例
    @TableField(value="account_name")
    private String accountName; // 账户名
    @TableField(value="bank_account")
    private String bankAccount; // 银行账号
    @TableField(value="bank_name")
    private String bankName; // 开户行
    @TableField(value="pay_mny")
    private BigDecimal payMny; // 已支付金额
    @TableField(value="back_mny")
    private BigDecimal backMny; // 已退还金额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="deal_time")
    private Date dealTime; // 办理时间

    @TableField(value="open_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date openDate; // 开标日期
    @TableField(value="bond_allow_type")
    private String bondAllowType; // 保证金允许缴纳方式
    @TableField(value="bond_end_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bondEndTime; // 保证金缴纳截至时间
    @TableField(value="bond_confirm_type")
    private String bondConfirmType; // 确认缴纳方式
    @TableField(value="pay_state")
    private Integer payState; // 支付状态(0-否 1-是)
    @TableField(value="need_back_state")
    private Integer needBackState; // 是否需要退回(0-否 1-是)
    @TableField(value="backed_state")
    private Integer backedState; // 是否已经退回(0-否 1-是)
    @TableField(value="invoice_state")
    private Integer invoiceState; // 是否开具发票(0-否 1-是)
    @TableField(value="invoice_mny")
    private BigDecimal invoiceMny; // 开票金额

    @TableField(exist=false)
    @SubEntity(serviceName="bidBondDealService",pidName ="bondId")//此处有pid="xxx"，默认值pid="pid"
    private List<BidBondDealEntity> bidBondDealList = new ArrayList<>(); // 投标保证金申请子表
    @TableField(exist=false)
    @SubEntity(serviceName="bidBondBackService",pidName ="bondId")//此处有pid="xxx"，默认值pid="pid"
    private List<BidBondBackEntity> bidBondBackList = new ArrayList<>(); // 投标保证金退还表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getBondStatus() {
        return bondStatus;
    }

    public void setBondStatus(String bondStatus) {
        this.bondStatus = bondStatus;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getOpportunityId() {
        return opportunityId;
    }

    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }

    public String getOpportunityName() {
        return opportunityName;
    }

    public void setOpportunityName(String opportunityName) {
        this.opportunityName = opportunityName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getApplyEmployeeId() {
        return applyEmployeeId;
    }

    public void setApplyEmployeeId(Long applyEmployeeId) {
        this.applyEmployeeId = applyEmployeeId;
    }

    public String getApplyEmployeeName() {
        return applyEmployeeName;
    }

    public void setApplyEmployeeName(String applyEmployeeName) {
        this.applyEmployeeName = applyEmployeeName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public BigDecimal getBondScale() {
        return bondScale;
    }

    public void setBondScale(BigDecimal bondScale) {
        this.bondScale = bondScale;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getDealTime() {
        return dealTime;
    }

    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }

    public Date getOpenDate() {
        return openDate;
    }

    public void setOpenDate(Date openDate) {
        this.openDate = openDate;
    }

    public String getBondAllowType() {
        return bondAllowType;
    }

    public void setBondAllowType(String bondAllowType) {
        this.bondAllowType = bondAllowType;
    }

    public Date getBondEndTime() {
        return bondEndTime;
    }

    public void setBondEndTime(Date bondEndTime) {
        this.bondEndTime = bondEndTime;
    }

    public String getBondConfirmType() {
        return bondConfirmType;
    }

    public void setBondConfirmType(String bondConfirmType) {
        this.bondConfirmType = bondConfirmType;
    }

    public Integer getPayState() {
        return payState;
    }

    public void setPayState(Integer payState) {
        this.payState = payState;
    }

    public Integer getNeedBackState() {
        return needBackState;
    }

    public void setNeedBackState(Integer needBackState) {
        this.needBackState = needBackState;
    }

    public Integer getBackedState() {
        return backedState;
    }

    public void setBackedState(Integer backedState) {
        this.backedState = backedState;
    }

    public Integer getInvoiceState() {
        return invoiceState;
    }

    public void setInvoiceState(Integer invoiceState) {
        this.invoiceState = invoiceState;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public List<BidBondDealEntity> getBidBondDealList() {
        return bidBondDealList;
    }

    public void setBidBondDealList(List<BidBondDealEntity> bidBondDealList) {
        this.bidBondDealList = bidBondDealList;
    }

    public List<BidBondBackEntity> getBidBondBackList() {
        return bidBondBackList;
    }

    public void setBidBondBackList(List<BidBondBackEntity> bidBondBackList) {
        this.bidBondBackList = bidBondBackList;
    }
}
