package com.ejianc.business.labor.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 劳务结算单
 * 
 * @author generator
 * 
 */
public class LaborSettlementVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织id
    private String parentOrgName; // 上级组织名称
    private Long employeeId; // 被考核人id
    private String employeeName; // 被考核人名称
    private String employeeIdcard; // 身份证
    private Long departmentId; // 所属部门id
    private String departmentName; // 所属部门名称
    private Integer billState; // 单据状态
    private Long contentId; // 分包合同
    private String contentName; // 分包合同名称
    private Long subId; // 分包单位
    private String subName; // 分包单位名
    private BigDecimal subUpMoney; // 分包单位上报金额
    private Long subManagerId; // 分包单位负责人
    private String subManagerName; // 分包单位负责人名
    private String subManagerPhone; // 分包单位负责人联系方式
    private BigDecimal cbFirstMoney; // 成本出具初审金额
    private String bzzy; // 班组是是否对初审结果有争议
    private BigDecimal cbFinalMoney; // 成本中心出具最终结算金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate;


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeIdcard() {
        return employeeIdcard;
    }

    public void setEmployeeIdcard(String employeeIdcard) {
        this.employeeIdcard = employeeIdcard;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "sub-contract-register")
    public Long getContentId() {
        return contentId;
    }
    @ReferDeserialTransfer
    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }
    public String getContentName() {
        return contentName;
    }

    public void setContentName(String contentName) {
        this.contentName = contentName;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSubId() {
        return subId;
    }
    @ReferDeserialTransfer
    public void setSubId(Long subId) {
        this.subId = subId;
    }
    public String getSubName() {
        return subName;
    }

    public void setSubName(String subName) {
        this.subName = subName;
    }
    public BigDecimal getSubUpMoney() {
        return subUpMoney;
    }

    public void setSubUpMoney(BigDecimal subUpMoney) {
        this.subUpMoney = subUpMoney;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getSubManagerId() {
        return subManagerId;
    }
    @ReferDeserialTransfer
    public void setSubManagerId(Long subManagerId) {
        this.subManagerId = subManagerId;
    }
    public String getSubManagerName() {
        return subManagerName;
    }

    public void setSubManagerName(String subManagerName) {
        this.subManagerName = subManagerName;
    }
    public String getSubManagerPhone() {
        return subManagerPhone;
    }

    public void setSubManagerPhone(String subManagerPhone) {
        this.subManagerPhone = subManagerPhone;
    }
    public BigDecimal getCbFirstMoney() {
        return cbFirstMoney;
    }

    public void setCbFirstMoney(BigDecimal cbFirstMoney) {
        this.cbFirstMoney = cbFirstMoney;
    }
    public String getBzzy() {
        return bzzy;
    }

    public void setBzzy(String bzzy) {
        this.bzzy = bzzy;
    }
    public BigDecimal getCbFinalMoney() {
        return cbFinalMoney;
    }

    public void setCbFinalMoney(BigDecimal cbFinalMoney) {
        this.cbFinalMoney = cbFinalMoney;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
}
