package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.LoadBackEntity;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.finance.mapper.LoadApplyMapper;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadBackService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.vo.LoadApplyVO;
import com.ejianc.business.finance.vo.ParamsCheckDsSpreadVO;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.finance.vo.ProjectFinanceVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 借款申请
 *
 * @author generator
 *
 */
@Service
public class LoadApplyServiceImpl extends BaseServiceImpl<LoadApplyMapper, LoadApplyEntity> implements ILoadApplyService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BONDUP_BILL_CODE = "LOAD_APPLY";
    private static final String CAN_USE_MNY_CHECK_CODE = "P-M478G960";//【项目可用资金】控制项目【申请金额	】

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ILoadReimburseService loadReimburseService;

    @Autowired
    private ILoadBackService loadBackService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public LoadApplyVO insertOrUpdate(LoadApplyVO loadApplyVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(null!=loadApplyVO&&StringUtils.isEmpty(loadApplyVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                loadApplyVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //同一用户，组织下只能存在一条未生效的
        /*LambdaQueryWrapper<LoadApplyEntity> lambdachange = Wrappers.<LoadApplyEntity>lambdaQuery();
        lambdachange.eq(LoadApplyEntity::getTenantId, tenantId);
        lambdachange.eq(LoadApplyEntity::getApplyEmployeeId, loadApplyVO.getApplyEmployeeId());
        lambdachange.eq(LoadApplyEntity::getOrgId,loadApplyVO.getOrgId());
        if(null!=loadApplyVO.getId()&&loadApplyVO.getId()>0){
            lambdachange.ne(LoadApplyEntity::getId,loadApplyVO.getId());
        }
        lambdachange.ne(LoadApplyEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(LoadApplyEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<LoadApplyEntity> list = super.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("在该组织存在未生效的借款申请单,单据编号【"+list.get(0).getBillCode()+"】");
        }*/
        LoadApplyEntity entity = BeanMapper.map(loadApplyVO, LoadApplyEntity.class);
        BigDecimal surplusMny =  querySurplusMny(null,null,entity.getOrgId(),1, String.valueOf(loadApplyVO.getApplyEmployeeId()));
        entity.setSurplusMny(surplusMny);
        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);//存放发票确认标识
        super.saveOrUpdate(entity,false);
        LoadApplyVO applyVO = BeanMapper.map(entity, LoadApplyVO.class);
        ProjectFinanceVO v = BeanMapper.map(applyVO, ProjectFinanceVO.class);
        applyVO.setProjectFinanceVO(v);
        return applyVO;
    }

    @Override
    public BigDecimal querySurplusMny(Long rebid,Long backid,Long orgId,int type,String applyEmployeeId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(applyEmployeeId)){
            applyEmployeeId = InvocationInfoProxy.getEmployeeId();
        }
        //根据当前登录人+orgId 查询申请单审批通过的申请金额
        List<LoadApplyEntity> listApplys = new ArrayList<>();
        List<LoadReimburseEntity> listReimburse = new ArrayList<>();
        List<LoadBackEntity> listBack = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());

        LambdaQueryWrapper<LoadApplyEntity> lambda = Wrappers.<LoadApplyEntity>lambdaQuery();
        lambda.eq(LoadApplyEntity::getTenantId, tenantId);
        lambda.eq(LoadApplyEntity::getOrgId, orgId);
        lambda.eq(LoadApplyEntity::getApplyEmployeeId,applyEmployeeId);
        lambda.in(LoadApplyEntity::getBillState,billstate);
        listApplys = super.list(lambda);
        BigDecimal sumApplyMny = listApplys.stream().map(LoadApplyEntity::getApplyMny).reduce(BigDecimal.ZERO,  (a, b) -> a.add(b));

        //根据当前登录人+orgId 查询申请单审批通过的报销金额
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
        queryParam.getParams().put("org_id", new Parameter(QueryParam.EQ,orgId));
        queryParam.getParams().put("apply_employee_id", new Parameter(QueryParam.EQ,applyEmployeeId));
        if(null!=rebid){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,rebid));
        }
        if(1==type){
            queryParam.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        }
        listReimburse = loadReimburseService.queryList(queryParam,false);
        BigDecimal sumReimburseMny = listReimburse.stream().map(LoadReimburseEntity::getReimburseMny).reduce(BigDecimal.ZERO,  (a, b) -> a.add(b));

        //根据当前登录人+orgId 查询申请单审批通过的报销金额
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
        queryParam2.getParams().put("org_id", new Parameter(QueryParam.EQ,orgId));
        queryParam2.getParams().put("apply_employee_id", new Parameter(QueryParam.EQ,applyEmployeeId));
        if(null!=backid){
            queryParam2.getParams().put("id", new Parameter(QueryParam.NE,backid));
        }
        if(1==type){
            queryParam2.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        }
        listBack = loadBackService.queryList(queryParam2,false);
        BigDecimal sumBackMny = listBack.stream().map(LoadBackEntity::getBackMny).reduce(BigDecimal.ZERO,  (a, b) -> a.add(b));

        BigDecimal ApplyMny = sumApplyMny==null?BigDecimal.ZERO:sumApplyMny;
        BigDecimal ReimburseMny = sumReimburseMny==null?BigDecimal.ZERO:sumReimburseMny;
        BigDecimal BackMny = sumBackMny==null?BigDecimal.ZERO:sumBackMny;
        return ApplyMny.subtract(ReimburseMny).subtract(BackMny);
    }

    @Override
    public List<LoadApplyVO> queryUserReport() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        String userId = InvocationInfoProxy.getEmployeeId();
        List<LoadApplyVO> list = baseMapper.getUserReport(tenantId,userId);
        return list;
    }

    @Override
    public List<LoadApplyVO> queryAllReport(Page pages, QueryWrapper queryWrapper) {
        List<LoadApplyVO> listres = baseMapper.getReports(pages,queryWrapper);
        return listres;
    }

    @Override
    public ParamsCheckSpreadVO checkParams(LoadApplyVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        ParamsCheckSpreadVO paramsCheckVO = new ParamsCheckSpreadVO();

        CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(CAN_USE_MNY_CHECK_CODE, curOrgId);
        if (!response1.isSuccess()) {
            logger.info(response1.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        BigDecimal applyMny = vo.getApplyMny();
        List<BillParamVO> billParamVOS1 = response1.getData();
        if (CollectionUtils.isNotEmpty(billParamVOS1)) {
            for (BillParamVO billParamVO : billParamVOS1) {
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal surplusApplyMny = ComputeUtil.safeMultiply(roleValue.divide(BigDecimal.valueOf(100)), vo.getProSurplusApplyMny());
                if (ComputeUtil.isGreaterThan(applyMny, surplusApplyMny)) {
                    ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                    paramsCheckDsVO.setWarnItem("备用金申请额超项目可用资金");
                    paramsCheckDsVO.setWarnName("本期申请金额大于剩余可申请金额");
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次申请金额：").append(ComputeUtil.scaleTwo(applyMny)).append("元，剩余可申请金额*").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP)).append("%:").append(surplusApplyMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元。超出金额：").append(ComputeUtil.scaleTwo(ComputeUtil.safeSub(applyMny, surplusApplyMny))).append("元");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }

        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.getDataSource().addAll(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.getDataSource().addAll(paramsCheckVOMap.get("warn"));
        }
        return paramsCheckVO;
    }

    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsSpreadVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}
