package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.finance.bean.PayContractSummaryEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PayRecordSalaryGrantEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.labor.api.IProjectTeamApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;

/**
 * <p>
 * 零星材料付款申请审批操作业务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Service("paySporadic")
public class PaySporadicBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPaySporadicService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectTeamApi projectTeamApi;
    @Autowired
    private IPaySporadicSalaryService paySporadicSalaryService;

    @Autowired
    private IPayRecordService recordService;

    @Autowired
    private IPayRecordSalaryGrantService grantService;

    @Autowired
    private IPayContractSummaryService payContractSummaryService;

    @Autowired
    private IBankFlowService bankFlowService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    };

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper<PaySporadicEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PaySporadicEntity::getId, billId);
        updateWrapper.set(PaySporadicEntity::getApproveTime, new Date());
        service.update(updateWrapper);

        bankFlowService.delFlowBySource(null, billId);
        return CommonResponse.success("回调处理成功！");
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TO DO 结算单是否被其他引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        if(res.isSuccess()) {//单据未被下游单据引用
        }else{
            return CommonResponse.error(res.getMsg());
        }
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PaySporadicEntity entity = service.selectById(billId);
        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);//存放发票确认标识
        entity.setApproveTime(null);
        entity.setConfirmTime(null);
        logger.info("进入审批后回写--- entity:"+entity);

        if (Optional.ofNullable(entity.getCloseFlag()).orElse(Boolean.FALSE)) {
            // 还原付款申请主表申请金额
            entity.setApplyMny(entity.getApplyMnyBeforeClose());
            entity.setApplyMnyCn(NumberToCN.number2CN(entity.getApplyMny()));
            // 重置付款申请主表关闭字段
            entity.setApplyMnyBeforeClose(null);
            entity.setCloseFlag(Boolean.FALSE);
            entity.setCloseState(null);
            entity.setCloseTime(null);
            entity.setCloseUser(null);
        }
        service.saveOrUpdate(entity);

        // 删除付款记录表，因service.writeBackSumPayMny已全部撤回已支付合同及结算单，则不需要重新撤回结算单已支付金额，如需要再处理
        recordService.remove(new QueryWrapper<PayRecordEntity>().eq("payapply_id", billId));

        //如果是工人工资 需要逆回写 不需要校验工资发放是否确认，直接删除发放记录，更新申请工资汇总里的已支付金额为0
        Integer salaryFlag = entity.getSalaryFlag();
        if(salaryFlag != null && "1".equals(salaryFlag.toString())) {
            // 弃审后 工资汇总已支付金额置为0
            LambdaUpdateWrapper<PayContractSummaryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(PayContractSummaryEntity::getPayapplyId, billId);
            updateWrapper.set(PayContractSummaryEntity::getPayMny, BigDecimal.ZERO);
            payContractSummaryService.update(updateWrapper);
            grantService.remove(new QueryWrapper<PayRecordSalaryGrantEntity>().eq("payapply_id", billId));
        }

        //成本改造
        //删除成本中心数据, 更新关联状态为未关联
        service.pullCost(billId);

        bankFlowService.delFlowBySource(null, billId);

        return CommonResponse.success("回调处理成功！");
    }
}
