package com.ejianc.business.finance.service.impl;

import com.ejianc.business.finance.vo.ReimburseShareCostDetailVO;
import com.ejianc.business.income.vo.MonthESDataVO;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.ReimburseShareMapper;
import com.ejianc.business.finance.bean.ReimburseShareEntity;
import com.ejianc.business.finance.service.IReimburseShareService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 报销费用分摊
 * 
 * @author generator
 * 
 */
@Service("reimburseShareService")
public class ReimburseShareServiceImpl extends BaseServiceImpl<ReimburseShareMapper, ReimburseShareEntity> implements IReimburseShareService{

    @Override
    public Map<Long, BigDecimal> getSumOrgReimburseMny(Long shareId, List<Long> orgReimburseIds) {
        List<ReimburseShareCostDetailVO> sumOrgReimburseMnyList = baseMapper.getSumOrgReimburseMny(shareId, orgReimburseIds);
        Map<Long, BigDecimal> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(sumOrgReimburseMnyList)) {
            map = sumOrgReimburseMnyList.stream().collect(Collectors.groupingBy(ReimburseShareCostDetailVO::getReimburseId, Collectors.reducing(BigDecimal.ZERO, ReimburseShareCostDetailVO::getBodyReimburseShareMny, ComputeUtil::safeAdd)));
        }
        return map;
    }
}
