package com.ejianc.business.finance.enums;

public enum PaymentStatusEnum {

    REPORTING(1, "报备中"),      // 1=报备中
    PENDING(2, "待付款"),        // 2=待付款
    PAID(3, "已付款"),           // 3=已付款
    REFUNDED(4, "已退回");       // 4=已退回

    private final int code;
    private final String description;

    PaymentStatusEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    // 根据状态码获取枚举（安全处理：无效码返回null）
    public static PaymentStatusEnum fromCode(int code) {
        for (PaymentStatusEnum status : values()) {
            if (status.code == code) {
                return status;
            }
        }
        return null; // 无效状态码
    }

    // 获取状态码
    public int getCode() {
        return code;
    }

    // 获取描述（用于前端显示）
    public String getDescription() {
        return description;
    }

    // 重写toString()，方便日志输出
    @Override
    public String toString() {
        return "PaymentStatus{" +
               "code=" + code +
               ", description='" + description + '\'' +
               '}';
    }
}
