/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.finance.controller.SqlParam;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IProjectCapitalPlanService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.PayAndReceiveMnyWarnVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.dto.ContractDto;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/warn/"})
public class WarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PAY_WARN_NAME = "\u9879\u76ee\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u6536\u6b3e\u91d1\u989d\u9884\u8b66";
    private static final String REIMBURSE_WARN_NAME = "\u62a5\u9500\u8d39\u7528\u5927\u4e8e\u6536\u5165\u5408\u540c\u91d1\u989d\u9884\u8b66";
    private static final String BOND_EXPIRE_WARN_NAME = "\u4fdd\u8bc1\u91d1\u5230\u671f\u9884\u8b66";
    private static final String PERCENT_UNIT = "bfh";
    private static final String MNY_UNIT = "yuan";
    private static final String PC_URL = "/ejc-report-frontend/#/proPeportDetail?id=";
    private static final String BOND_UP_PC_URL = "/ejc-finance-frontend/#/bondManageList/bondUpDetailManage?id=";
    private static final String PRO_CAPITAL_PLAN_URL = "/ejc-finance-frontend/#/projectCapitalPlanList/projectCapitalPlanCare?id=";
    private static final String BOND_DOWN_PC_URL = "/ejc-finance-frontend/#/bondManageList/bondDownDetailManage?id=";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IProjectCapitalPlanService projectCapitalPlanService;
    @Autowired
    private IIncomeContractApi incomeApi;
    @Autowired
    private IPayContractService contractService;

    @PostMapping(value={"payMnyWarn"})
    public CommonResponse<String> payMnyWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u6536\u6b3e\u91d1\u989d\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u9879\u76ee\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u6536\u6b3e\u91d1\u989d\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u6536\u6b3e\u91d1\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u6536\u6b3e\u91d1\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        HashMap<String, SqlParam> paramMap = new HashMap<String, SqlParam>();
        ArrayList<Long> tenantidList = new ArrayList<Long>();
        for (SqlParam param : sqlParamList) {
            paramMap.put(param.getTenantId() + param.getUnit(), param);
            tenantidList.add(param.getTenantId());
        }
        Map<Long, PayAndReceiveMnyWarnVO> payMap = this.contractService.getSumPayMnyMap(tenantidList);
        Map<Long, PayAndReceiveMnyWarnVO> receiveMap = this.contractService.getSumReceiveMnyMap(tenantidList);
        if (CollectionUtils.isEmpty(payMap.keySet())) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u6536\u6b3e\u91d1\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<Long> projectIds = new ArrayList<Long>(payMap.keySet());
        projectIds.addAll(receiveMap.keySet());
        CommonResponse res = this.projectApi.queryProjectByIds(projectIds);
        Map<Object, Object> projectMap = new HashMap();
        if (res.isSuccess() && !((List)res.getData()).isEmpty()) {
            projectMap = ((List)res.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        }
        CommonResponse response = this.incomeApi.searchContractByTenantIds(tenantidList);
        HashMap<Long, BigDecimal> incomeMap = new HashMap<Long, BigDecimal>();
        if (response.isSuccess() && !((List)response.getData()).isEmpty()) {
            List list = (List)response.getData();
            for (ContractVo vo : list) {
                if (incomeMap.containsKey(vo.getProjectId())) {
                    incomeMap.put(vo.getProjectId(), MathUtil.safeAdd((BigDecimal)((BigDecimal)incomeMap.get(vo.getProjectId())), (BigDecimal)vo.getContractTaxMny()));
                    continue;
                }
                incomeMap.put(vo.getProjectId(), vo.getContractTaxMny());
            }
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (Long key : payMap.keySet()) {
            PayAndReceiveMnyWarnVO payVO = payMap.get(key);
            ProjectRegisterVO projectVO = (ProjectRegisterVO)projectMap.get(payVO.getProjectId());
            BigDecimal sumPayMny = payVO.getSumPayMny();
            BigDecimal sumReceiveMny = BigDecimal.ZERO;
            if (receiveMap != null && receiveMap.containsKey(key)) {
                sumReceiveMny = receiveMap.get(key).getSumReceiveMny();
            }
            String warnLevel = null;
            StringBuffer content = new StringBuffer();
            boolean flag = false;
            if (paramMap.containsKey(payVO.getTenantId() + PERCENT_UNIT)) {
                SqlParam param = (SqlParam)paramMap.get(payVO.getTenantId() + PERCENT_UNIT);
                warnLevel = param.getWarnLevel();
                BigDecimal warnMny = MathUtil.safeMultiply((BigDecimal)((BigDecimal)incomeMap.get(key)), (BigDecimal)new BigDecimal(param.getValue()));
                if (MathUtil.safeSub((BigDecimal)sumPayMny, (BigDecimal)sumReceiveMny).compareTo(warnMny) > 0) {
                    flag = true;
                    content.append("\u6536\u5165\u5408\u540c\u91d1\u989d*");
                    content.append(String.valueOf(param.getValue() * 100.0));
                    content.append("%\uff1a");
                    content.append(df.format(warnMny != null ? warnMny : BigDecimal.ZERO));
                    content.append("\u5143");
                }
            }
            if (paramMap.containsKey(payVO.getTenantId() + MNY_UNIT)) {
                String dou = flag ? "\uff0c" : "";
                SqlParam param = (SqlParam)paramMap.get(payVO.getTenantId() + MNY_UNIT);
                warnLevel = param.getWarnLevel();
                BigDecimal setMny = new BigDecimal(param.getValue());
                if (MathUtil.safeSub((BigDecimal)sumPayMny, (BigDecimal)sumReceiveMny).compareTo(setMny) > 0) {
                    flag = true;
                    content.append(dou);
                    content.append(setMny + "\u5143");
                }
            }
            if (!flag) continue;
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + projectVO.getCode());
            vo.setPcTitle("\u9879\u76ee\u7edf\u8ba1");
            vo.setPcUrl(PC_URL + payVO.getProjectId().toString() + "&orgId=" + payVO.getOrgId());
            vo.setOrgId(payVO.getOrgId());
            vo.setOrgName(payVO.getOrgName());
            vo.setSourceId(payVO.getProjectId().toString());
            vo.setTenantId(payVO.getTenantId());
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", payVO.getProjectName()).replaceAll("#sumPayMny#", df.format(this.getBigDecimal(sumPayMny))).replaceAll("#sumReceiveMny#", df.format(this.getBigDecimal(sumReceiveMny))).replaceAll("#content#", String.valueOf(content)));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"reimburseMnyWarn"})
    public CommonResponse<String> reimburseMnyWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u62a5\u9500\u8d39\u7528\u5927\u4e8e\u6536\u5165\u5408\u540c\u91d1\u989d\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u62a5\u9500\u8d39\u7528\u5927\u4e8e\u6536\u5165\u5408\u540c\u91d1\u989d\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u62a5\u9500\u8d39\u7528\u5927\u4e8e\u6536\u5165\u5408\u540c\u91d1\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u62a5\u9500\u8d39\u7528\u5927\u4e8e\u6536\u5165\u5408\u540c\u91d1\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        HashMap<Long, SqlParam> paramMap = new HashMap<Long, SqlParam>();
        ArrayList<Long> tenantidList = new ArrayList<Long>();
        for (SqlParam param : sqlParamList) {
            paramMap.put(param.getTenantId(), param);
            tenantidList.add(param.getTenantId());
        }
        Map<Long, PayAndReceiveMnyWarnVO> payMap = this.contractService.getSumReimburseMnyMap(tenantidList);
        if (CollectionUtils.isEmpty(payMap.keySet())) {
            this.logger.error("\u6267\u884c\u62a5\u9500\u8d39\u7528\u5927\u4e8e\u6536\u5165\u5408\u540c\u91d1\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        CommonResponse res = this.projectApi.queryProjectByIds(new ArrayList<Long>(payMap.keySet()));
        Map<Object, Object> projectMap = new HashMap();
        if (res.isSuccess() && !((List)res.getData()).isEmpty()) {
            projectMap = ((List)res.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        }
        CommonResponse response = this.incomeApi.postSearchContractByTenantIds(tenantidList);
        HashMap<Long, BigDecimal> incomeMap = new HashMap<Long, BigDecimal>();
        this.logger.info("\u5408\u540c\u67e5\u8be2\u7ed3\u679c--------------------------------------------------:" + response.isSuccess());
        if (response.isSuccess() && !((List)response.getData()).isEmpty()) {
            List list = (List)response.getData();
            for (ContractDto vo : list) {
                if (incomeMap.containsKey(vo.getProjectId())) {
                    incomeMap.put(vo.getProjectId(), MathUtil.safeAdd((BigDecimal)((BigDecimal)incomeMap.get(vo.getProjectId())), (BigDecimal)vo.getContractTaxMny()));
                    continue;
                }
                incomeMap.put(vo.getProjectId(), vo.getContractTaxMny());
            }
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (Long key : payMap.keySet()) {
            PayAndReceiveMnyWarnVO payVO = payMap.get(key);
            ProjectRegisterVO projectVO = (ProjectRegisterVO)projectMap.get(payVO.getProjectId());
            BigDecimal sumReimburseMny = payVO.getSumPayMny();
            BigDecimal sumIncomeMny = BigDecimal.ZERO;
            if (incomeMap != null && incomeMap.containsKey(key)) {
                sumIncomeMny = (BigDecimal)incomeMap.get(key);
            }
            SqlParam param = (SqlParam)paramMap.get(payVO.getTenantId());
            BigDecimal warnMny = MathUtil.safeMultiply((BigDecimal)((BigDecimal)incomeMap.get(key)), (BigDecimal)new BigDecimal(param.getValue()));
            if (sumReimburseMny.compareTo(warnMny) < 0) continue;
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + projectVO.getCode());
            vo.setPcTitle("\u9879\u76ee\u7edf\u8ba1");
            vo.setPcUrl(PC_URL + payVO.getProjectId().toString() + "&orgId=" + payVO.getOrgId());
            vo.setOrgId(payVO.getOrgId());
            vo.setOrgName(payVO.getOrgName());
            vo.setSourceId(payVO.getProjectId().toString());
            vo.setTenantId(payVO.getTenantId());
            vo.setWarnLevel(param.getWarnLevel());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", payVO.getProjectName()).replaceAll("#sumReimburseMny#", df.format(this.getBigDecimal(sumReimburseMny))).replaceAll("#sumIncomeMny#", df.format(this.getBigDecimal(sumIncomeMny))).replaceAll("#percent#", String.valueOf(param.getValue() * 100.0)).replaceAll("#warnMny#", df.format(this.getBigDecimal(warnMny))));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"bondExpireWarn"})
    public CommonResponse<String> bondExpireWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u4fdd\u8bc1\u91d1\u5230\u671f\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u4fdd\u8bc1\u91d1\u5230\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u4fdd\u8bc1\u91d1\u5230\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
        }
        List<Map<String, Object>> result = this.contractService.queryBondExpireWarn(sqlParamList);
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u4fdd\u8bc1\u91d1\u5230\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5408\u540c\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"projectCapitalPlanWarn"})
    public CommonResponse<String> projectCapitalPlanWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u8d44\u91d1\u8ba1\u5212\u4e2d\u652f\u4ed8\u8ba1\u5212\u5230\u671f\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u8d44\u91d1\u8ba1\u5212\u4e2d\u652f\u4ed8\u8ba1\u5212\u5230\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u8d44\u91d1\u8ba1\u5212\u4e2d\u652f\u4ed8\u8ba1\u5212\u5230\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        List<Map<String, Object>> result = this.projectCapitalPlanService.queryProCapitalPlanWarn(sqlParamList);
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u8d44\u91d1\u8ba1\u5212\u4e2d\u652f\u4ed8\u8ba1\u5212\u5230\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (Map<String, Object> warnVo : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName("\u9879\u76ee\u8d44\u91d1\u8ba1\u5212-" + warnVo.get("code").toString());
            vo.setPcTitle("\u9879\u76ee\u8d44\u91d1\u8ba1\u5212");
            vo.setPcUrl(PRO_CAPITAL_PLAN_URL + warnVo.get("pid").toString());
            vo.setOrgId(Long.valueOf(warnVo.get("orgId").toString()));
            vo.setOrgName(warnVo.get("orgName").toString());
            vo.setTenantId(Long.valueOf(warnVo.get("tenantId").toString()));
            vo.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#supplierName#", null != warnVo.get("supplierName") ? warnVo.get("supplierName").toString() : "").replaceAll("#planPaymentMny#", df.format(this.getBigDecimal(warnVo.get("planPaymentMny").toString()))).replaceAll("#planPaymentDate#", warnVo.get("planPaymentDate").toString()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.get("bondCode").toString());
            if ("up".equals(m.get("type"))) {
                vo.setPcTitle("\u5bf9\u4e0a\u4fdd\u8bc1\u91d1\u7ba1\u7406");
                vo.setPcUrl(BOND_UP_PC_URL + m.get("bondId").toString());
            } else {
                vo.setPcTitle("\u5bf9\u4e0b\u4fdd\u8bc1\u91d1\u7ba1\u7406");
                vo.setPcUrl(BOND_DOWN_PC_URL + m.get("bondId").toString());
            }
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("bondId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            if (Integer.parseInt(m.get("day").toString()) >= 0) {
                tmpContent = "\u4fdd\u8bc1\u91d1\u3010" + m.get("bondCode").toString() + "\u3011\u8fd8\u6709" + m.get("day").toString() + "\u5929\u5230\u671f\uff0c\u8bf7\u53ca\u65f6\u529e\u7406\u9000\u8fd8\uff1b";
            }
            if (Integer.parseInt(m.get("day").toString()) < 0) {
                Integer day = -Integer.parseInt(m.get("day").toString());
                tmpContent = "\u4fdd\u8bc1\u91d1\u3010" + m.get("bondCode").toString() + "\u3011\u5df2\u7ecf\u8fc7\u671f" + day + "\u5929\uff0c\u8bf7\u53ca\u65f6\u529e\u7406\u9000\u8fd8\uff1b";
            }
            vo.setEarlywarnContent(tmpContent);
            resp.add(vo);
        }
        return resp;
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        this.logger.info("\u53d1\u9001\u4efb\u52a1\uff1a{}", (Object)JSONObject.toJSONString(warnList));
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private BigDecimal getBigDecimal(Object obj) {
        return null == obj ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }
}

