/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IloadInvoiceService;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"loadReimburse"})
public class LoadReimburseController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ILoadReimburseService service;
    @Autowired
    private IloadInvoiceService loadInvoiceService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IDefdocApi defdocApi;
    private static String COST_TYPE_DEFDOC_CODE = "load-reimburse-costType";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LoadReimburseVO> saveOrUpdate(@RequestBody LoadReimburseVO saveorUpdateVO) {
        LoadReimburseVO vo = this.service.insertOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LoadReimburseVO> queryDetail(Long id) {
        LoadReimburseEntity entity = (LoadReimburseEntity)((Object)this.service.selectById(id));
        LoadReimburseVO vo = (LoadReimburseVO)BeanMapper.map((Object)((Object)entity), LoadReimburseVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LoadReimburseVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.loadInvoiceService.updateInvoiceUsedMnyByDel(ids);
            this.service.removeByIds(ids, true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("applyEmployeeId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("employeeId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
        c1.getComplexParams().add(c3);
        param.getComplexParams().add(c1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.service.queryPage(param, false);
        JSONObject res = new JSONObject();
        res.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), LoadReimburseVO.class));
        res.put("total", (Object)pageData.getTotal());
        res.put("current", (Object)pageData.getCurrent());
        res.put("size", (Object)pageData.getSize());
        res.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryReportList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        IPage pageData = this.service.queryPage(param, false);
        JSONObject res = new JSONObject();
        res.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), LoadReimburseVO.class));
        res.put("total", (Object)pageData.getTotal());
        res.put("current", (Object)pageData.getCurrent());
        res.put("size", (Object)pageData.getSize());
        res.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("LoadReimburse", this.service.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List list = new ArrayList();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("applyEmployeeId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), LoadReimburseVO.class);
        }
        Map<Object, Object> defDocMap = new HashMap();
        CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode(COST_TYPE_DEFDOC_CODE);
        if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)defDocByDefCode.getData()))) {
            List data = (List)defDocByDefCode.getData();
            defDocMap = data.stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName, (key1, key2) -> key2));
        }
        for (LoadReimburseVO vo : list) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setCostTypeName((String)defDocMap.get(vo.getCostType()));
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("loadReimburseExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportReport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportReport(@RequestBody QueryParam param, HttpServletResponse response) {
        List list = new ArrayList();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        IPage pageData = this.service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), LoadReimburseVO.class);
        }
        Map<Object, Object> defDocMap = new HashMap();
        CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode(COST_TYPE_DEFDOC_CODE);
        if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)defDocByDefCode.getData()))) {
            List data = (List)defDocByDefCode.getData();
            defDocMap = data.stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName, (key1, key2) -> key2));
        }
        for (LoadReimburseVO vo : list) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setCostTypeName((String)defDocMap.get(vo.getCostType()));
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("loadReimburseExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LoadReimburseVO> pushCost(@RequestBody LoadReimburseVO loadReimburseVO) {
        return this.service.pushCost(loadReimburseVO);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamsCheckSpreadVO> checkParams(Long projectId, BigDecimal money) {
        ParamsCheckSpreadVO paramsCheckVO = this.service.checkParams(projectId, money);
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"/updateInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LoadReimburseVO> updateInfo(@RequestBody LoadReimburseVO vo) {
        if (vo.getId() != null && vo.getInvoiceFlag() != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)vo.getId());
            updateWrapper.set(LoadReimburseEntity::getInvoiceFlag, (Object)vo.getInvoiceFlag());
            this.service.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)vo);
    }
}

