/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paySporadic")
public class PaySporadicBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPaySporadicService service;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(PaySporadicEntity::getApproveTime, (Object)new Date());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PaySporadicEntity entity = (PaySporadicEntity)((Object)this.service.selectById(billId));
        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setApproveTime(null);
        this.service.saveOrUpdate((Object)entity);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        this.service.pullCost(billId);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }
}

