package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@TableName("ejc_finance_pay_contract_settle")
public class PayContractSettleEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 付款申请单主键
     */
    @TableField("payapply_id")
    private Long payapplyId;

    /**
     * 来源结算单主键
     */
    @TableField("settle_id")
    private Long settleId;

    /**
     * 结算单编号
     */
    @TableField("settle_code")
    private String settleCode;

    /**
     * 本期结算金额
     */
    @TableField("settle_mny")
    private BigDecimal settleMny;

    /**
     * 本期申请金额
     */
    @TableField("body_apply_mny")
    private BigDecimal bodyApplyMny;

    /**
     * 已申请金额
     */
    @TableField("sum_apply_mny")
    private BigDecimal sumApplyMny;

    /**
     * 合同支付比例
     */
    @TableField("pay_scale")
    private BigDecimal payScale;

    /**
     * 创建者名称
     */
    @TableField("create_user_name")
    private String createUserName;

    /**
     * 剩余可申请金额
     */
    @TableField("surplus_apply_mny")
    private BigDecimal surplusApplyMny;

    /**
     * 约定支付金额
     */
    @TableField("contract_pay_mny")
    private BigDecimal contractPayMny;

    /**
     * 结算单类型：1-过程结算，2-完工结算
     */
    @TableField("settle_type")
    private Integer settleType;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 已支付金额
     */
    @TableField("sum_pay_mny")
    private BigDecimal sumPayMny;

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public BigDecimal getSurplusApplyMny() {
        return surplusApplyMny;
    }

    public void setSurplusApplyMny(BigDecimal surplusApplyMny) {
        this.surplusApplyMny = surplusApplyMny;
    }

    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }

    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public String getSettleCode() {
        return settleCode;
    }

    public void setSettleCode(String settleCode) {
        this.settleCode = settleCode;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getBodyApplyMny() {
        return bodyApplyMny;
    }

    public void setBodyApplyMny(BigDecimal bodyApplyMny) {
        this.bodyApplyMny = bodyApplyMny;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
