package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.finance.vo.PaySporadicEquipmentRecordVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@TableName("ejc_finance_pay_sporadic")
public class PaySporadicEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 经办时间
     */
    @TableField("confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 付款类型：1-组织付款，2- 项目付款
     */
    @TableField("pay_type")
    private Integer payType;

    /**
     * 支付状态：1-未支付，2-已支付
     */
    @TableField("pay_status")
    private Integer payStatus;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 供应商
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 付款事由
     */
    @TableField("pay_reason")
    private String payReason;

    /**
     * 申请人
     */
    @TableField("apply_user_id")
    private Long applyUserId;

    /**
     * 申请人名称
     */
    @TableField("apply_user_name")
    private String applyUserName;

    /**
     * 申请时间
     */
    @TableField("apply_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    @TableField("apply_mny")
    private BigDecimal applyMny;

    /**
     * 发票金额
     */
    @TableField("invoice_mny")
    private BigDecimal invoiceMny;

    /**
     * 支付金额
     */
    @TableField("pay_mny")
    private BigDecimal payMny;

    /**
     * 账户名称
     */
    @TableField("account_name")
    private String accountName;

    /**
     * 银行账号
     */
    @TableField("account_num")
    private String accountNum;

    /**
     * 开户行
     */
    @TableField("account_bank")
    private String accountBank;

    /**
     * 撤回原因
     */
    @TableField("back_reason")
    private String backReason;

    /**
     * 撤回时间
     */
    @TableField("back_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 审批时间
     */
    @TableField("approve_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 属于项目:1-是，0-否
     */
    @TableField("depend_on_project")
    private String dependOnProject;
    /**
     * 是否包含入库单(1-是，0-否)
     */
    @TableField("input_flag")
    private String inputFlag;
    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;
    /**
     * 关联状态(1:是，0：否)
     */
    @TableField("relation_flag")
    private String relationFlag;
    /**
     * 分摊状态(1:是，0：否)
     */
    @TableField("proportion_flag")
    private String proportionFlag;

    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    private String invoiceFlag;

    /**
     * 付款单位
     */
    @TableField("pay_unit_id")
    private Long payUnitId;

    /**
     * 付款单位名称
     */
    @TableField("pay_unit_name")
    private String payUnitName;

    /**
     *************start************************项目资金改造***************************start*******************************
     */

    @TableField(value="pro_contract_mny")
    private java.math.BigDecimal proContractMny; // 收入合同金额
    @TableField(value="pro_output_mny")
    private java.math.BigDecimal proOutputMny; // 完成产值
    @TableField(value="pro_date_progress")
    private java.math.BigDecimal proDateProgress; // 日期进度
    @TableField(value="pro_output_progress")
    private java.math.BigDecimal proOutputProgress; // 产值进度
    @TableField(value="pro_contract_receive_mny")
    private java.math.BigDecimal proContractReceiveMny; // 合同累计收款金额
    @TableField(value="pro_receive_mny")
    private java.math.BigDecimal proReceiveMny; // 累计收款
    @TableField(value="pro_pay_mny")
    private java.math.BigDecimal proPayMny; // 累计付款
    @TableField(value="pro_cost_list_surplus")
    private java.math.BigDecimal proCostListSurplus; // 费用清单结余
    @TableField(value="pro_transfer_surplus")
    private java.math.BigDecimal proTransferSurplus; // 项目代转款款结余
    @TableField(value="pro_risk_margin_surplus")
    private java.math.BigDecimal proRiskMarginSurplus; // 风险保证金结余
    @TableField(value="pro_loan_balance")
    private java.math.BigDecimal proLoanBalance; // 借款结余
    @TableField(value="pro_loan_interest")
    private java.math.BigDecimal proLoanInterest; // 借款利息
    @TableField(value="pro_other_fee_deduct")
    private java.math.BigDecimal proOtherFeeDeduct; // 其他费用扣除
    @TableField(value="pro_other_fee_back")
    private java.math.BigDecimal proOtherFeeBack; // 其他费用退还
    @TableField(value="pro_surplus_mny")
    private java.math.BigDecimal proSurplusMny; // 项目可用资金
    @TableField(value="pro_surplus_apply_mny")
    private java.math.BigDecimal proSurplusApplyMny; // 剩余可申请金额release
    @TableField(value="pro_petty_cash")
    private java.math.BigDecimal proPettyCash; // 备用金结余
    @TableField(value="pro_manage_scale")
    private java.math.BigDecimal proManageScale; // 管理费比例
    @TableField(value="pro_manage_fee")
    private java.math.BigDecimal proManageFee; // 管理费
    @TableField(value="pro_amerce")
    private java.math.BigDecimal proAmerce; // 罚款
    @TableField(value="pro_apply_unpay_mny")
    private java.math.BigDecimal proApplyUnpayMny; // 已申请未支付金额

    /**
     * 申请金额大写
     */
    @TableField("apply_mny_cn")
    private String applyMnyCn;
    @TableField("purchase_people")
    private String purchasePeople;
    @TableField(exist = false)
    @SubEntity(serviceName = "paySporadicOtherService", pidName = "payapplyId")
    private List<PaySporadicOtherEntity> otherVOList = new ArrayList<>();



    public List<PaySporadicOtherEntity> getOtherVOList() {
        return otherVOList;
    }

    public void setOtherVOList(List<PaySporadicOtherEntity> otherVOList) {
        this.otherVOList = otherVOList;
    }

    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }
    public Long getPayUnitId() {
        return payUnitId;
    }

    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }

    public BigDecimal getProApplyUnpayMny() {
        return proApplyUnpayMny;
    }

    public void setProApplyUnpayMny(BigDecimal proApplyUnpayMny) {
        this.proApplyUnpayMny = proApplyUnpayMny;
    }
    public BigDecimal getProContractMny() {
        return proContractMny;
    }

    public void setProContractMny(BigDecimal proContractMny) {
        this.proContractMny = proContractMny;
    }

    public BigDecimal getProOutputMny() {
        return proOutputMny;
    }

    public void setProOutputMny(BigDecimal proOutputMny) {
        this.proOutputMny = proOutputMny;
    }

    public BigDecimal getProDateProgress() {
        return proDateProgress;
    }

    public void setProDateProgress(BigDecimal proDateProgress) {
        this.proDateProgress = proDateProgress;
    }

    public BigDecimal getProOutputProgress() {
        return proOutputProgress;
    }

    public void setProOutputProgress(BigDecimal proOutputProgress) {
        this.proOutputProgress = proOutputProgress;
    }

    public BigDecimal getProContractReceiveMny() {
        return proContractReceiveMny;
    }

    public void setProContractReceiveMny(BigDecimal proContractReceiveMny) {
        this.proContractReceiveMny = proContractReceiveMny;
    }

    public BigDecimal getProReceiveMny() {
        return proReceiveMny;
    }

    public void setProReceiveMny(BigDecimal proReceiveMny) {
        this.proReceiveMny = proReceiveMny;
    }

    public BigDecimal getProPayMny() {
        return proPayMny;
    }

    public void setProPayMny(BigDecimal proPayMny) {
        this.proPayMny = proPayMny;
    }

    public BigDecimal getProCostListSurplus() {
        return proCostListSurplus;
    }

    public void setProCostListSurplus(BigDecimal proCostListSurplus) {
        this.proCostListSurplus = proCostListSurplus;
    }

    public BigDecimal getProTransferSurplus() {
        return proTransferSurplus;
    }

    public void setProTransferSurplus(BigDecimal proTransferSurplus) {
        this.proTransferSurplus = proTransferSurplus;
    }

    public BigDecimal getProRiskMarginSurplus() {
        return proRiskMarginSurplus;
    }

    public void setProRiskMarginSurplus(BigDecimal proRiskMarginSurplus) {
        this.proRiskMarginSurplus = proRiskMarginSurplus;
    }

    public BigDecimal getProLoanBalance() {
        return proLoanBalance;
    }

    public void setProLoanBalance(BigDecimal proLoanBalance) {
        this.proLoanBalance = proLoanBalance;
    }

    public BigDecimal getProLoanInterest() {
        return proLoanInterest;
    }

    public void setProLoanInterest(BigDecimal proLoanInterest) {
        this.proLoanInterest = proLoanInterest;
    }

    public BigDecimal getProOtherFeeDeduct() {
        return proOtherFeeDeduct;
    }

    public void setProOtherFeeDeduct(BigDecimal proOtherFeeDeduct) {
        this.proOtherFeeDeduct = proOtherFeeDeduct;
    }

    public BigDecimal getProOtherFeeBack() {
        return proOtherFeeBack;
    }

    public void setProOtherFeeBack(BigDecimal proOtherFeeBack) {
        this.proOtherFeeBack = proOtherFeeBack;
    }

    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }

    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }

    public BigDecimal getProPettyCash() {
        return proPettyCash;
    }

    public void setProPettyCash(BigDecimal proPettyCash) {
        this.proPettyCash = proPettyCash;
    }

    public BigDecimal getProManageScale() {
        return proManageScale;
    }

    public void setProManageScale(BigDecimal proManageScale) {
        this.proManageScale = proManageScale;
    }

    public BigDecimal getProManageFee() {
        return proManageFee;
    }

    public void setProManageFee(BigDecimal proManageFee) {
        this.proManageFee = proManageFee;
    }

    public BigDecimal getProAmerce() {
        return proAmerce;
    }

    public void setProAmerce(BigDecimal proAmerce) {
        this.proAmerce = proAmerce;
    }

    /**
     *************end************************项目资金改造***************************end*******************************
     */



    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public String getInputFlag() {
        return inputFlag;
    }

    public void setInputFlag(String inputFlag) {
        this.inputFlag = inputFlag;
    }
    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public String getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(String invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }

    public String getPurchasePeople() {
        return purchasePeople;
    }

    public void setPurchasePeople(String purchasePeople) {
        this.purchasePeople = purchasePeople;
    }
}
