package com.ejianc.business.finance.controller;


import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.finance.vo.BondUpDealVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 保证金办理表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@RestController
@RequestMapping("/bondUpDeal")
public class BondUpDealController {
    @Autowired
    private IBondUpDealService bondUpDealService;
    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param bondUpDealVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BondUpDealVO> saveOrUpdate(@RequestBody BondUpDealVO bondUpDealVO) {
        BondUpDealVO backVO = bondUpDealService.insertOrUpdate(bondUpDealVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondUpDealRentVO> queryDetail(Long id) {
        BondUpDealRentVO backVO = bondUpDealService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }

}
