package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.controller.SqlParam;
import com.ejianc.business.finance.pub.vo.PubContractSubQueryVO;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.vo.*;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public interface IPayContractService extends IBaseService<PayContractEntity> {

    PayContractVO insertOrUpdate(PayContractVO payContractVO);

    PayContractVO queryDetail(Long id);

    List<PayContractVO> queryExportList(QueryParam param);

    String delete(List<Long> ids);

    JSONObject queryPageJson(QueryParam param, boolean isEs);

    JSONObject querySettleRefer(QueryParam param, Integer contractType);

    SumPayMnyVO getSumPayMny(Long contractId, Long orgId);

    SumPayMnyVO getSumPayMnyVOList(Long contractId, Long orgId);

    JSONObject queryPendingPageJson(QueryParam param, boolean isEs);

    List<PayApplyPubVO> queryExportPendingList(QueryParam param);

    String batchConfirm(List<PayApplyPubVO> vos);

    boolean writeBackSumPayMny(Long billId, PayContractEntity entity, boolean flag);

    ManageDetailVO getManageDetail(Long projectId);

    SumMnyStatisticVO getStatisticsMny();

    /**
     * 根据条件统计合同付款的支付金额总数
     *
     * @param tenantId 租户Id
     * @param projectIds 带过滤项目Id列表
     * @return
     */
    Map<String, Object> countAmt(Long tenantId, List<Long> projectIds);

    List<FinanceMonthVO> getMonthInfo(Long projectId,String timeRange);

    List<FinanceCostVO> getCostInfo(Long projectId, String year);

    Map<String, BigDecimal> getSubSettlePay(PubContractSubQueryVO pubContractSubQueryVO);

    Map<String, PayMnyWarnVO> getPayMnyByTenantIds(PubWarnQueryVO pubWarnQueryVO);

    Map<Long, PayAndReceiveMnyWarnVO> getSumPayMnyMap(List<Long> tenantIds);

    Map<Long, PayAndReceiveMnyWarnVO> getSumReceiveMnyMap(List<Long> tenantIds);

    Map<Long, PayAndReceiveMnyWarnVO> getSumReimburseMnyMap(List<Long> tenantIds);

    List<Map<String,Object>> queryBondExpireWarn(List<SqlParam> sqlParamList);

    JSONObject projectProgress(Long projectId, Date startDate, Date endDate);

    JSONObject projectIncome(Long projectId);

    JSONObject projectOut(Long projectId);

    Map<String,PayMnyWarnVO> warnPayMny(PubWarnQueryVO pubWarnQueryVO);

    Map<String,PayMnyWarnVO> warnMaterialPayMny(PubWarnQueryVO pubWarnQueryVO);

    Map<String,PayMnyWarnVO> warnMaterialPrePayMny(PubWarnQueryVO pubWarnQueryVO);

    TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs);

    TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs);

    TotalColumnVO getPendingTotalColumnInfo(QueryParam param, boolean isEs);

    ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumPayMny, BigDecimal payMny, BigDecimal contractMny);

    ProjectFinanceVO getProFinance(Long projectId);

    List<ProjectReimburseVO> getProjectReimburse(List<Long> projectIds, List<Integer> billStates);

    List<FinanceWarnV0> getProjectPayMny();
}
