package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.controller.api.PayContractApi;
import com.ejianc.business.finance.mapper.PayReimburseMapper;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.income.consts.EJCDateUtil;
import com.ejianc.business.plan.api.IBudgetPlanApi;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-05-28
 */
@Service
public class PayReimburseServiceImpl extends BaseServiceImpl<PayReimburseMapper, PayReimburseEntity> implements IPayReimburseService {
    private static final String REIM_PAYAPPLY_BILL_CODE = "REIM_PAYAPPLY";
    //系统是否开启专业分包预算标志
    private static final String SYS_IS_PROBUDGET_CODE = "P-D76yn127";
    //预算单据管理费控制
    private static final String CHECK_PARAM_PROBUDGET_CODE = "P-V4416932";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPayInvoiceService invoiceService;

    @Autowired
    private IPayRecordService payRecordService;

    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private FeignUtil feignUtil;

    @Autowired
    private PayContractApi payContractApi;

    @Autowired
    private ISettlementApi iSettlementApi;

    @Autowired
    private IBudgetPlanApi iBudgetPlanApi;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IPayContractService payContractService;

    @Override
    public PayReimburseVO insertOrUpdate(PayReimburseVO vo) {
        PayReimburseEntity entity = BeanMapper.map(vo, PayReimburseEntity.class);
        // 自动生成编码
        this.autoSetBillCode(entity);
        //设置默认值
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        // 设置默认是否需要发票
        /*if (StringUtils.isEmpty(entity.getInvoiceFlag())) {
            entity.setInvoiceFlag("3");
        }*/
        List<PayInvoiceVO> voList = vo.getInvoiceVOList();
        if(CollectionUtils.isNotEmpty(voList)){
            for(PayInvoiceVO invoiceVO : voList){
                // 保存时校验version是否一致
                if(!ValidateUtil.validateUpstreamVersion(String.valueOf(invoiceVO.getInvoiceId()),
                        BillTypeCodeEnum.税务收票.getBillTypeCode(), invoiceVO.getInvoiceVersion())){
                    throw new BusinessException("发票已被更新，请刷新后重做！");
                }
            }
        }
        CommonResponse<String> usedMnyRes = invoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId());
        if (!usedMnyRes.isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }
        // 保存主表
        super.saveOrUpdateNoES(entity);

        Long id = entity.getId();
        // 更新发票
        List<PayInvoiceVO> invoiceVOList = this.updateInvoiceVOS(vo, id);
        PayReimburseEntity byId = super.getById(id);
        // 返回VO
        PayReimburseVO backVO = BeanMapper.map(byId, PayReimburseVO.class);
        if(entity.getId() != null){
            QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>();
            wrapper.eq("payapply_id", entity.getId());
            invoiceVOList = invoiceService.list(wrapper);
        }
        backVO.setInvoiceVOList(invoiceVOList);// 发票列表
        ProjectFinanceVO v = BeanMapper.map(byId, ProjectFinanceVO.class);
        backVO.setProjectFinanceVO(v);
        return backVO;
    }

    /**
     * 更新发票
     * @param vo
     * @param id
     * @return
     */
    private List<PayInvoiceVO> updateInvoiceVOS(PayReimburseVO vo, Long id) {
        // 新增
        List<PayInvoiceVO> voList = vo.getInvoiceVOList();
        List<InvoiceReceiveFlagVO> flagVOS = new ArrayList<>();
        List<Long> receiveIds = new ArrayList<>();
        if(voList != null && !voList.isEmpty()){
            for(PayInvoiceVO invoiceVO : voList){
                InvoiceReceiveFlagVO flagVO = new InvoiceReceiveFlagVO();
                flagVO.setId(invoiceVO.getInvoiceId());
                flagVO.setFlag(1);
                flagVOS.add(flagVO);
                receiveIds.add(invoiceVO.getInvoiceId());
                invoiceVO.setPayapplyId(id);
            }
            List<PayInvoiceEntity> entityList = BeanMapper.mapList(voList, PayInvoiceEntity.class);
            invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList(entityList, PayInvoiceVO.class);
        }
        // 删除
        List<Long> voIds = voList.stream().map(PayInvoiceVO::getId).collect(Collectors.toList());
        List<PayInvoiceEntity> dataList = invoiceService.list(new QueryWrapper<PayInvoiceEntity>().eq("payapply_id", id));
        List<Long> dataIds = dataList.stream().map(PayInvoiceEntity::getId).collect(Collectors.toList());
        dataIds.removeAll(voIds);
        List<Long> delIds = dataIds;
        if(!delIds.isEmpty()){
            invoiceService.remove(new QueryWrapper<PayInvoiceEntity>().in("id", delIds), false);
        }
        return voList;
    }

    @Override
    public PayReimburseVO queryDetail(Long id) {
        // 查询主表
        PayReimburseEntity entity = this.selectById(id);
        PayReimburseVO vo = BeanMapper.map(entity, PayReimburseVO.class);
        // 查询关联发票
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List<PayInvoiceEntity> invoiceEntityList = invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList(invoiceEntityList, PayInvoiceVO.class));
        // 查询付款记录
        List<PayRecordEntity> recordList = payRecordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList(recordList, PayRecordVO.class));

        //项目资金详情
        vo.setProjectFinanceVO(BeanMapper.map(vo, ProjectFinanceVO.class));

        if(null != vo.getPayMny()){
            vo.setPayMnyCn(NumberToCN.number2CN(vo.getPayMny()));
        }
        return vo;
    }

    @Override
    public List<PayReimburseVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List<PayReimburseVO> resVos = (List<PayReimburseVO>) queryPageJson(param, false).get("records");
        Map<Long, String> defdocMap = feignUtil.getDefdocMap(324875125018329093L);
        if(!resVos.isEmpty()){
            for(int i = 0 ; i< resVos.size(); i++){
                PayReimburseVO vo = resVos.get(i);
                vo.setFeeTypeName(defdocMap.get(vo.getFeeType()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setIsShareFlagName(vo.getIsShareFlag() != null && vo.getIsShareFlag() == 1 ? "是" :"否");
            };
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<PayReimburseEntity> entityList = super.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(entityList)) {
            // 逆回写收票占用金额
            CommonResponse<String> res = invoiceService.updateInvoiceUsedMnyByDel(ids);
            if(res.isSuccess()){
                super.removeByIds(ids, false);
                // 删除发票
                QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>().in("payapply_id", ids);
                List<PayInvoiceEntity> invoiceList = invoiceService.list(wrapper);
                invoiceService.remove(wrapper, false);
            }
        }
        return "删除成功！";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payReason");

        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //页面跳转携带的orgId 没用使用本下
        if(!param.getParams().containsKey("orgId")){
            //移动端和pc端权限处理
            UserContext userContext = sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);

            if (StringUtils.isNotEmpty(authOrgIds)) {
                CommonResponse<List<OrgVO>> authResponse =
                        orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                                collect(Collectors.toList()));
                logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", authOrgIds, authResponse.getData() == null ? null : authResponse.getData().size());
                param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        // 组织本下
        //param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        Page<PayReimburseVO> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayReimburseVO> list = baseMapper.queryPageList(pages, wrapper, flag);
        list.forEach(vo -> {
            if(null != vo.getApplyMny()){
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }


    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper<PayReimburseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("ifnull(sum(pay_mny),0) as amt");

        queryWrapper.eq("tenant_id", tenantId);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
//        付款类型：1-组织付款 2-项目付款
        queryWrapper.eq("pay_type", 2);
//        支付状态：1-未支付 2-已支付
        queryWrapper.eq("pay_status", 2);

        if(CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in("project_id", projectIds);
        }
//        已生效的单据
        queryWrapper.in("bill_state",
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        if(ListUtil.isNotEmpty(orgIds)){
            queryWrapper.in("org_id", orgIds);
        }
        return super.getMap(queryWrapper);
    }

    @Override
    public CommonResponse<PayReimburseVO> pushCost(PayReimburseVO payReimburseVO) {
        PayReimburseEntity payReimburseEntity = baseMapper.selectById(payReimburseVO.getId());
        payReimburseEntity.setSubjectId(payReimburseVO.getSubjectId());
        payReimburseEntity.setSubjectName(payReimburseVO.getSubjectName());
        super.saveOrUpdate(payReimburseEntity,false);
        //推送数据
        costPush(payReimburseEntity);
        return CommonResponse.success(BeanMapper.map(payReimburseEntity, PayReimburseVO.class));
    }
    @Override
    public void costPush(PayReimburseEntity payReimburseEntity) {
        if (!"1".equals(payReimburseEntity.getDependOnProject())){
            return;
        }
        //1.判断是否关联
        Long subjectId = payReimburseEntity.getSubjectId();
        boolean newRelationFlag = true;
        if(null == subjectId){
            newRelationFlag = false;
        }
        //更新是否关联
        LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PayReimburseEntity::getId, payReimburseEntity.getId());
        updateWrapper.set(PayReimburseEntity::getRelationFlag, newRelationFlag ? "1":"0");//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = payReimburseEntity.getRelationFlag();
        //之前已关联
        if (oldRelationFlag.equals("1")){
            if (newRelationFlag){
                saveCost(payReimburseEntity);
            }
            if (!newRelationFlag){
                //删除成本中心之前的数据
                costDetailApi.deleteSubject(payReimburseEntity.getId());
            }
        }
        //之前未关联
        if (oldRelationFlag.equals("0")){
            if (newRelationFlag){
                //税率
                saveCost(payReimburseEntity);
            }
        }


    }
    private void saveCost(PayReimburseEntity payReimburseEntity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(payReimburseEntity.getSubjectId());
        costDetailVO.setSourceId(payReimburseEntity.getId());
        costDetailVO.setSourceDetailId(payReimburseEntity.getId());
        costDetailVO.setHappenTaxMny(payReimburseEntity.getPayMny());
        costDetailVO.setHappenMny(payReimburseEntity.getPayMny());
        costDetailVO.setHappenDate(payReimburseEntity.getApplyTime());
        costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(REIM_PAYAPPLY_BILL_CODE);
        costDetailVO.setSourceTabType(REIM_PAYAPPLY_BILL_CODE);
        costDetailVO.setProjectId(payReimburseEntity.getProjectId());
        costDetailVOList.add(costDetailVO);
        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)){
            costDetailVOList.toString();
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            if (stringCommonResponse.isSuccess()){
            }else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    /**
     * 自动生成编码
     * @param entity
     */
    private void autoSetBillCode(PayReimburseEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(REIM_PAYAPPLY_BILL_CODE, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //修改  校验合同编号是否重复
        LambdaQueryWrapper<PayReimburseEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(PayReimburseEntity::getBillCode, entity.getBillCode());
        lambda.eq(PayReimburseEntity::getTenantId, tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0, PayReimburseEntity::getId, entity.getId());
        List<PayReimburseEntity> entityList = super.list(lambda);
        if(entityList != null && entityList.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
    }
    //成本改造
    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PayReimburseEntity::getId, id);
        updateWrapper.set(PayReimburseEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //页面跳转携带的orgId 没用使用本下
        if(!param.getParams().containsKey("orgId")){
            param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else {
            param.getParams().remove("createUserCode");
        }
        if(param.getParams().containsKey("projectId")){
            param.getParams().remove("createUserCode");
        }

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayReimburseVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("org_id",new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayReimburseVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    @Override
    public ParamsCheckSpreadVO checkParams(Long projectId, BigDecimal appMoney) {
        List<Long> projectIds = new ArrayList<>();
        projectIds.add(projectId);
        String[] paramsArray = {"none", "warn", "alert"};
//        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ParamsCheckSpreadVO paramsCheckVO = new ParamsCheckSpreadVO();
        // 预警弹框控制
        paramsCheckVO.setWarnType(paramsArray[0]);
        // 管理费率
        BigDecimal manageRate = BigDecimal.ZERO;

        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(SYS_IS_PROBUDGET_CODE);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO data = byCode.getData();
            String valueData = data.getValueData();
            if ("1".equals(valueData)) {
                CommonResponse<BillParamVO> probudgetCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_PROBUDGET_CODE);
                if(probudgetCode.isSuccess() && null != probudgetCode.getData()){
                    paramsCheckVO.setWarnType(paramsArray[probudgetCode.getData().getControlType()]);
                    manageRate = probudgetCode.getData().getRoleValue();
                }else{
                    return paramsCheckVO;
                }
            }else{
                logger.info("未读取到费率配置参数！"+projectId);
                return paramsCheckVO;
            }
        }else{
            logger.info("非世纪阳光！"+projectId);
            return paramsCheckVO;
        }
        // 预警内容
        List<ParamsCheckDsSpreadVO> checkDsVOS = new ArrayList<>();
        // 累计已用额度
        BigDecimal oldSumMoney = BigDecimal.ZERO;
        // 当前总额度 (累计已用额度+本次申请额度)
        BigDecimal sumMoney = BigDecimal.ZERO;
        // 超额的值
        BigDecimal excessMoney = BigDecimal.ZERO;
        // 预警阀值
        BigDecimal endSum = BigDecimal.ZERO;
        // 管理费
        BigDecimal costbudgetMny = BigDecimal.ZERO;
        // 临时值，用于格式化费率
        BigDecimal temp = new BigDecimal(100);

        BigDecimal payReimburseMny = BigDecimal.ZERO;
        BigDecimal loadReimburseMny = BigDecimal.ZERO;
        BigDecimal rentSettleMny = BigDecimal.ZERO;
        BigDecimal purchaseSettleMny = BigDecimal.ZERO;

        List<ProjectReimburseVO> projectReimburse = payContractService.getProjectReimburse(projectIds, null);
        CommonResponse<List<SettlementVO>> settleMny = iSettlementApi.getSettleMny(projectIds);
        CommonResponse<BudgetTemVO> budget = iBudgetPlanApi.getBudget(projectId);
        if(CollectionUtils.isNotEmpty(projectReimburse)){
            payReimburseMny = projectReimburse.get(0).getPayReimburseMny();
            loadReimburseMny = projectReimburse.get(0).getLoadReimburseMny();
        }
        if(settleMny.isSuccess() && null != settleMny.getData() && settleMny.getData().size() > 0){
            rentSettleMny = settleMny.getData().get(0).getRentSettleMny();
            purchaseSettleMny = settleMny.getData().get(0).getPurchaseSettleMny();
        }
        if(budget.isSuccess() && null != budget.getData()){
            costbudgetMny = budget.getData().getManageMny();
            endSum = costbudgetMny.multiply(manageRate).divide(temp);
        }

        // 累加已用额度
        oldSumMoney = payReimburseMny.add(loadReimburseMny).add(rentSettleMny).add(purchaseSettleMny);
        // 计算当前总额度
        sumMoney = oldSumMoney.add(appMoney);
        // 计算已经超额的值
        excessMoney = sumMoney.subtract(endSum);
        //reimburseMmy 报销费用=付款申请中的报销费用+备用金报销
        BigDecimal reimburseMmy = payReimburseMny.add(loadReimburseMny).add(appMoney);
        //manageMmy  管理费
        BigDecimal manageMmy=costbudgetMny;
        paramsCheckVO.setManageMmy(manageMmy);
        paramsCheckVO.setReimburseMmy(reimburseMmy);
        if(sumMoney.compareTo(endSum) > 0){
            ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
            paramsCheckDsVO.setWarnItem("管理费超付");
            paramsCheckDsVO.setWarnName("管理费金额大于预算中管理费金额");
            paramsCheckDsVO.setContent("本次管理费金额："+appMoney.setScale(2, BigDecimal.ROUND_HALF_UP)
                    +"元，预算管理费金额*"+manageRate.setScale(2, BigDecimal.ROUND_HALF_UP)+"%："+endSum.setScale(2, BigDecimal.ROUND_HALF_UP)
                    +"元。超出金额:"+excessMoney.setScale(2, BigDecimal.ROUND_HALF_UP)+"元。");
            checkDsVOS.add(paramsCheckDsVO);
            paramsCheckVO.setDataSource(checkDsVOS);
        }
        return paramsCheckVO;
    }

    /**
     * 更新累计分摊金额
     * @param id
     * @param mny
     * @return
     */
    @Override
    public CommonResponse<PayReimburseVO> updateShareMoney(Long id, BigDecimal mny) {
        //查询费用报销单
        PayReimburseEntity payReimburseEntity = this.selectById(id);
        if(payReimburseEntity != null){
            //计算累计分摊金额
            BigDecimal countShareMny_old = payReimburseEntity.getCountShareMny();
            BigDecimal countShareMny_new = ComputeUtil.safeAdd(countShareMny_old, mny);
            if(countShareMny_new.compareTo(BigDecimal.ZERO)<0){
                return CommonResponse.error("累计分摊金额不能小于0！");
            }
            //更新费用报销单
            LambdaUpdateWrapper<PayReimburseEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(PayReimburseEntity::getId,id);
            wrapper.set(PayReimburseEntity::getCountShareMny,countShareMny_new);
            this.update(wrapper);
            return CommonResponse.success();
        }else{
            return CommonResponse.error("报销单不存在！");
        }
    }

    /**
     *  报销单参照
     * @param page
     * @param wrapper
     * @return
     */
    @Override
    public List<PayReimburseVO> queryReferData(Page<PayReimburseVO> page, QueryWrapper wrapper) {
        return baseMapper.queryReferData(page,wrapper);
    }

    @Override
    public CommonResponse<PayReimburseStatisticsVO> getPayReimburseInfo(Integer dependOnProject) {
        String lastMonthLastDayOfPreviousYear = EJCDateUtil.format(new Date(),"yyyy")+"-12-31";
        String firstDayOfCurrentYear = EJCDateUtil.getFirstDayOfCurrentYear(EJCDateUtil.DATE);
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        QueryWrapper<PayReimburseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("IFNULL(SUM(IF((is_share_flag = 0),apply_mny,0)),0)AS applyMny,IFNULL(SUM(IF((is_share_flag = 0),pay_mny,0)),0) AS payMny,IFNULL(SUM(IF((is_share_flag = 0),invoice_mny,0)),0) AS invoiceMny");
        queryWrapper.eq("depend_on_project",dependOnProject);
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in(CollectionUtils.isNotEmpty(orgIds),"org_id",orgIds);
        queryWrapper.between("apply_time",firstDayOfCurrentYear,lastMonthLastDayOfPreviousYear);
        PayReimburseEntity one = baseMapper.selectOne(queryWrapper);
        PayReimburseStatisticsVO payReimburseStatisticsVO = new PayReimburseStatisticsVO();
        payReimburseStatisticsVO.setThisYearApplyMny(one.getApplyMny());
        payReimburseStatisticsVO.setThisYearPayMny(one.getPayMny());
        payReimburseStatisticsVO.setThisYearInvoiceMny(one.getInvoiceMny());
        String month = EJCDateUtil.getCurrentDay(EJCDateUtil.MONTH);
        String startMonth=month+"-"+"01";
        String endMonth=month+"-"+"31";
        QueryWrapper<PayReimburseEntity> thisMonthQueryWrapper = new QueryWrapper<>();
        thisMonthQueryWrapper.select("IFNULL(SUM(IF((is_share_flag = 0),apply_mny,0)),0)AS applyMny,IFNULL(SUM(IF((is_share_flag = 0),pay_mny,0)),0) AS payMny,IFNULL(SUM(IF((is_share_flag = 0),invoice_mny,0)),0) AS invoiceMny");
        thisMonthQueryWrapper.eq("depend_on_project",dependOnProject);
        thisMonthQueryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode()));
        thisMonthQueryWrapper.in(CollectionUtils.isNotEmpty(orgIds),"org_id",orgIds);
        thisMonthQueryWrapper.between("apply_time",startMonth,endMonth);
        PayReimburseEntity thisMonthInfo = baseMapper.selectOne(thisMonthQueryWrapper);
        payReimburseStatisticsVO.setThisMonthApplyMny(thisMonthInfo.getApplyMny());
        payReimburseStatisticsVO.setThisMonthPayMny(thisMonthInfo.getPayMny());
        payReimburseStatisticsVO.setThisMonthInvoiceMny(thisMonthInfo.getInvoiceMny());
        return CommonResponse.success("获取报销信息成功！", payReimburseStatisticsVO);
    }

    @Override
    public IPage<PayReimburseStatisticsVO> payReimburseStatisticsList(Page<PayReimburseStatisticsVO> page, QueryWrapper wrapper, String dependOnProject, List<Long> feeType) {
        return baseMapper.payReimburseStatisticsList(page,wrapper,dependOnProject,feeType);
    }

    @Override
    public List<PayReimburseStatisticsVO> payReimburseStatisticsDetailList(Long projectId ,Long orgId,List<Long> feeType) {
        return baseMapper.payReimburseStatisticsDetailList(projectId,orgId,feeType);
    }
}
