/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/report/"})
public class ReportController {
    @Autowired
    private IPayContractService reportService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private RestHighLevelClient client;
    private final String INDEX_MONTH_RECEIVE_MNY = "month_receive_mny";
    private final String YEAR_FINANCE_PAY_REC = "year_finance_pay_rec";
    public static final Integer QUERY_TIMEOUT = 60;
    private static Map<Integer, String> MONTH_MAP = new HashMap<Integer, String>();
    List<String> YEAR_PAY_REC_KEY_LIST = Arrays.asList("planPayMny", "actPayMny", "jihuashijichaezhichu", "planRecMny", "actRecMny", "jihuashijichaeshouru");
    List<String> MONTH_REC_KEY_LIST = Arrays.asList("recMny", "recCount", "openInvoiceMny", "openInvoiceCount", "contractTaxMny", "contractCount");

    @RequestMapping(value={"/queryYearPayRec"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryYearPayRec(@RequestBody QueryParam param) {
        JSONObject resVO = this.queryYearPayRecData(param);
        return CommonResponse.success((String)"\u5e74\u5ea6\u8ba1\u5212\u8d44\u91d1\u6536\u652f\uff01", (Object)resVO);
    }

    @RequestMapping(value={"/exportYearPayRec"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportYearPayRec(@RequestBody QueryParam param, HttpServletResponse response) {
        JSONObject resVO = this.queryYearPayRecData(param);
        Object records = resVO.get((Object)"records");
        ArrayList<JSONObject> tableData = (ArrayList<JSONObject>)records;
        tableData = this.getSumRecords(tableData, this.YEAR_PAY_REC_KEY_LIST);
        HashMap<String, ArrayList<JSONObject>> beans = new HashMap<String, ArrayList<JSONObject>>();
        beans.put("records", tableData);
        ExcelExport.getInstance().export("year-pay-rec-export.xlsx", beans, response);
    }

    private JSONObject queryYearPayRecData(QueryParam param) {
        String yyear;
        JSONObject resVO = new JSONObject();
        JSONObject echartData = new JSONObject();
        SearchRequest searchRequest = new SearchRequest(new String[]{"year_finance_pay_rec"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter yyearPara = (Parameter)param.getParams().get("yyear");
        String string = yyear = yyearPara != null ? String.valueOf(yyearPara.getValue()) : null;
        if (StringUtils.isNotBlank((CharSequence)yyear)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"yyear", (String)yyear));
        }
        TermsAggregationBuilder aggregation = (TermsAggregationBuilder)AggregationBuilders.terms((String)"timeGroup").field("mmonth");
        for (String key : this.YEAR_PAY_REC_KEY_LIST) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)key).field(key));
        }
        sourceBuilder.aggregation((AggregationBuilder)aggregation);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            SearchResponse search = this.client.search(searchRequest, RequestOptions.DEFAULT);
            Aggregations aggregations = search.getAggregations();
            ParsedLongTerms terms = (ParsedLongTerms)aggregations.get("timeGroup");
            List buckets = terms.getBuckets();
            HashMap<Integer, JSONObject> tableDataMap = new HashMap<Integer, JSONObject>();
            HashMap<String, BigDecimal> echartItemDataMap = new HashMap<String, BigDecimal>();
            BigDecimal[] planPayMnyArr = new BigDecimal[12];
            BigDecimal[] actPayMnyArr = new BigDecimal[12];
            BigDecimal[] planActPayDiffMnyArr = new BigDecimal[12];
            BigDecimal[] planRecMnyArr = new BigDecimal[12];
            BigDecimal[] actRecMnyArr = new BigDecimal[12];
            BigDecimal[] planActRecDiffMnyArr = new BigDecimal[12];
            for (Object bucket : buckets) {
                Integer n = Integer.valueOf(String.valueOf(bucket.getKey()));
                Aggregations bucketAggregations = bucket.getAggregations();
                JSONObject itemObj = new JSONObject();
                itemObj.put("month", (Object)n);
                itemObj.put("monthStr", (Object)MONTH_MAP.get(n));
                for (String string2 : this.YEAR_PAY_REC_KEY_LIST) {
                    ParsedSum productionSumRes = (ParsedSum)bucketAggregations.get(string2);
                    BigDecimal val = ComputeUtil.toBigDecimal((Double)productionSumRes.getValue());
                    itemObj.put(string2, (Object)val);
                    echartItemDataMap.put(n + string2, val);
                }
                tableDataMap.put(n, itemObj);
            }
            Set<Map.Entry<Integer, String>> monEntry = MONTH_MAP.entrySet();
            for (Map.Entry entry : monEntry) {
                Integer mon = (Integer)entry.getKey();
                String monStr = (String)entry.getValue();
                if (!tableDataMap.containsKey(mon)) {
                    JSONObject itemObj = new JSONObject();
                    itemObj.put("month", (Object)mon);
                    itemObj.put("monthStr", (Object)monStr);
                    for (String key : this.YEAR_PAY_REC_KEY_LIST) {
                        itemObj.put(key, (Object)BigDecimal.ZERO);
                    }
                    tableDataMap.put(mon, itemObj);
                }
                for (String string3 : this.YEAR_PAY_REC_KEY_LIST) {
                    BigDecimal val = ComputeUtil.nullToZero((BigDecimal)ComputeUtil.toBigDecimal(echartItemDataMap.get(mon + string3)));
                    if ("planPayMny".equals(string3)) {
                        planPayMnyArr[mon.intValue() - 1] = val;
                        continue;
                    }
                    if ("actPayMny".equals(string3)) {
                        actPayMnyArr[mon.intValue() - 1] = val;
                        continue;
                    }
                    if ("jihuashijichaezhichu".equals(string3)) {
                        planActPayDiffMnyArr[mon.intValue() - 1] = val;
                        continue;
                    }
                    if ("planRecMny".equals(string3)) {
                        planRecMnyArr[mon.intValue() - 1] = val;
                        continue;
                    }
                    if ("actRecMny".equals(string3)) {
                        actRecMnyArr[mon.intValue() - 1] = val;
                        continue;
                    }
                    if (!"jihuashijichaeshouru".equals(string3)) continue;
                    planActRecDiffMnyArr[mon.intValue() - 1] = val;
                }
            }
            ArrayList tableData = new ArrayList(tableDataMap.values());
            Collections.sort(tableData, (o1, o2) -> {
                Integer m1 = Integer.valueOf(String.valueOf(o1.get((Object)"month")));
                Integer m2 = Integer.valueOf(String.valueOf(o2.get((Object)"month")));
                return m1.compareTo(m2);
            });
            echartData.put("month", new ArrayList<String>(MONTH_MAP.values()));
            echartData.put("planPayMny", (Object)planPayMnyArr);
            echartData.put("actPayMnyMny", (Object)actPayMnyArr);
            echartData.put("planActPayDiffMny", (Object)planActPayDiffMnyArr);
            echartData.put("planRecMny", (Object)planRecMnyArr);
            echartData.put("actRecMny", (Object)actRecMnyArr);
            echartData.put("planActRecDiffMny", (Object)planActRecDiffMnyArr);
            resVO.put("records", tableData);
            resVO.put("echartData", (Object)echartData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resVO;
    }

    @RequestMapping(value={"/queryMonthRec"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryMonthRec(@RequestBody QueryParam param) {
        JSONObject resVO = this.queryMonthRecData(param);
        return CommonResponse.success((String)"\u6708\u5ea6\u56de\u6b3e\u7edf\u8ba1\uff01", (Object)resVO);
    }

    @RequestMapping(value={"/exportMonthRec"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportMonthRec(@RequestBody QueryParam param, HttpServletResponse response) {
        JSONObject resVO = this.queryMonthRecData(param);
        Object records = resVO.get((Object)"records");
        ArrayList<JSONObject> tableData = (ArrayList<JSONObject>)records;
        tableData = this.getSumRecords(tableData, this.MONTH_REC_KEY_LIST);
        HashMap<String, ArrayList<JSONObject>> beans = new HashMap<String, ArrayList<JSONObject>>();
        beans.put("records", tableData);
        ExcelExport.getInstance().export("month-receive-mny-export.xlsx", beans, response);
    }

    private ArrayList<JSONObject> getSumRecords(ArrayList<JSONObject> tableData, List<String> keyList) {
        JSONObject sumObj = new JSONObject();
        sumObj.put("monthStr", (Object)"\u5408\u8ba1");
        for (String dataKey : keyList) {
            Object v = sumObj.get((Object)dataKey);
            BigDecimal sum = ComputeUtil.toBigDecimal((Object)v);
            for (JSONObject tableDatum : tableData) {
                Object _add = tableDatum.get((Object)dataKey);
                BigDecimal add = ComputeUtil.toBigDecimal((Object)_add);
                sum = ComputeUtil.safeAdd((BigDecimal)sum, (BigDecimal)add);
            }
            sumObj.put(dataKey, (Object)sum);
        }
        tableData.add(sumObj);
        return tableData;
    }

    private JSONObject queryMonthRecData(QueryParam param) {
        String yyear;
        JSONObject resVO = new JSONObject();
        JSONObject echartData = new JSONObject();
        SearchRequest searchRequest = new SearchRequest(new String[]{"month_receive_mny"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter yyearPara = (Parameter)param.getParams().get("yyear");
        String string = yyear = yyearPara != null ? String.valueOf(yyearPara.getValue()) : null;
        if (StringUtils.isNotBlank((CharSequence)yyear)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"yyear", (String)yyear));
        }
        TermsAggregationBuilder aggregation = (TermsAggregationBuilder)AggregationBuilders.terms((String)"timeGroup").field("mmonth");
        for (String key : this.MONTH_REC_KEY_LIST) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)key).field(key));
        }
        sourceBuilder.aggregation((AggregationBuilder)aggregation);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            SearchResponse search = this.client.search(searchRequest, RequestOptions.DEFAULT);
            Aggregations aggregations = search.getAggregations();
            ParsedLongTerms terms = (ParsedLongTerms)aggregations.get("timeGroup");
            List buckets = terms.getBuckets();
            HashMap<Integer, JSONObject> tableDataMap = new HashMap<Integer, JSONObject>();
            HashMap<String, BigDecimal> echartItemDataMap = new HashMap<String, BigDecimal>();
            BigDecimal[] recMnyArr = new BigDecimal[12];
            BigDecimal[] openInvoiceMnyArr = new BigDecimal[12];
            BigDecimal[] contractTaxMnyArr = new BigDecimal[12];
            for (Object bucket : buckets) {
                Integer n = Integer.valueOf(String.valueOf(bucket.getKey()));
                Aggregations bucketAggregations = bucket.getAggregations();
                JSONObject itemObj = new JSONObject();
                itemObj.put("month", (Object)n);
                itemObj.put("monthStr", (Object)MONTH_MAP.get(n));
                for (String string2 : this.MONTH_REC_KEY_LIST) {
                    ParsedSum productionSumRes = (ParsedSum)bucketAggregations.get(string2);
                    BigDecimal val = ComputeUtil.toBigDecimal((Double)productionSumRes.getValue());
                    itemObj.put(string2, (Object)val);
                    echartItemDataMap.put(n + string2, val);
                }
                tableDataMap.put(n, itemObj);
            }
            Set<Map.Entry<Integer, String>> monEntry = MONTH_MAP.entrySet();
            for (Map.Entry entry : monEntry) {
                Integer mon = (Integer)entry.getKey();
                String monStr = (String)entry.getValue();
                if (!tableDataMap.containsKey(mon)) {
                    JSONObject itemObj = new JSONObject();
                    itemObj.put("month", (Object)mon);
                    itemObj.put("monthStr", (Object)monStr);
                    for (String key : this.MONTH_REC_KEY_LIST) {
                        itemObj.put(key, (Object)BigDecimal.ZERO);
                    }
                    tableDataMap.put(mon, itemObj);
                }
                for (String string3 : this.MONTH_REC_KEY_LIST) {
                    BigDecimal val = ComputeUtil.nullToZero((BigDecimal)ComputeUtil.toBigDecimal(echartItemDataMap.get(mon + string3)));
                    if ("recMny".equals(string3)) {
                        recMnyArr[mon.intValue() - 1] = val;
                        continue;
                    }
                    if ("openInvoiceMny".equals(string3)) {
                        openInvoiceMnyArr[mon.intValue() - 1] = val;
                        continue;
                    }
                    if (!"contractTaxMny".equals(string3)) continue;
                    contractTaxMnyArr[mon.intValue() - 1] = val;
                }
            }
            ArrayList tableData = new ArrayList(tableDataMap.values());
            Collections.sort(tableData, (o1, o2) -> {
                Integer m1 = Integer.valueOf(String.valueOf(o1.get((Object)"month")));
                Integer m2 = Integer.valueOf(String.valueOf(o2.get((Object)"month")));
                return m1.compareTo(m2);
            });
            echartData.put("month", new ArrayList<String>(MONTH_MAP.values()));
            echartData.put("recMny", (Object)recMnyArr);
            echartData.put("openInvoiceMny", (Object)openInvoiceMnyArr);
            echartData.put("contractTaxMny", (Object)contractTaxMnyArr);
            resVO.put("records", tableData);
            resVO.put("echartData", (Object)echartData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resVO;
    }

    @RequestMapping(value={"/projectProgress"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> projectProgress(@RequestParam(value="projectId") Long projectId, @RequestParam(value="startDate", required=false) Date startDate, @RequestParam(value="endDate", required=false) Date endDate) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.projectProgress(projectId, startDate, endDate));
    }

    @RequestMapping(value={"/projectIncome"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> projectProgress(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.projectIncome(projectId));
    }

    @RequestMapping(value={"/projectOut"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> projectOut(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.projectOut(projectId));
    }

    static {
        MONTH_MAP.put(1, "\u4e00\u6708");
        MONTH_MAP.put(2, "\u4e8c\u6708");
        MONTH_MAP.put(3, "\u4e09\u6708");
        MONTH_MAP.put(4, "\u56db\u6708");
        MONTH_MAP.put(5, "\u4e94\u6708");
        MONTH_MAP.put(6, "\u516d\u6708");
        MONTH_MAP.put(7, "\u4e03\u6708");
        MONTH_MAP.put(8, "\u516b\u6708");
        MONTH_MAP.put(9, "\u4e5d\u6708");
        MONTH_MAP.put(10, "\u5341\u6708");
        MONTH_MAP.put(11, "\u5341\u4e00\u6708");
        MONTH_MAP.put(12, "\u5341\u4e8c\u6708");
    }
}

