package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayFocusDetailEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayFocusDetailVO;
import com.ejianc.business.finance.vo.PayFocusVO;
import com.ejianc.business.finance.vo.ProjectFinanceVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.PayFocusMapper;
import com.ejianc.business.finance.bean.PayFocusEntity;
import com.ejianc.business.finance.service.IPayFocusService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 集中付款申请实体
 * 
 * @author generator
 * 
 */
@Service("payFocusService")
public class PayFocusServiceImpl extends BaseServiceImpl<PayFocusMapper, PayFocusEntity> implements IPayFocusService{

    private static final String BILL_CODE = "PAY_FUCOS";//此处需要根据实际修改
    private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private ISubContractForPayApi subApi;
    @Autowired
    private IEquipmentContractApi equipmentApi;
    @Autowired
    private IMaterialSettlementApi materialApi;
    @Autowired
    private IInvoiceApi invoiceApi;

    @Autowired
    private IPayContractService payContractService;

    @Autowired
    private IPayContractSettleService payContractSettleService;

    @Autowired
    private SessionManager sessionManager;


    @Override
    public PayFocusVO insertOrUpdate(PayFocusVO saveOrUpdateVO) {
        PayFocusEntity entity = BeanMapper.map(saveOrUpdateVO, PayFocusEntity.class);
        // 校验同合同、同组织下只能有一张未生效单据, 已生效单据不做此校验 modifyby CJ 2021年7月21日 16:53:05
        if (!BillStateEnum.COMMITED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState()) && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())) {
            this.validateBeforeSave(entity);
        }
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //查询子表项目相关数据
        if(CollectionUtils.isNotEmpty(entity.getPayFocusDetailList())){
            List<PayFocusDetailEntity> list = updateFocusDetailProjectInfo(entity.getPayFocusDetailList());
            entity.setPayFocusDetailList(list);
        }
        super.saveOrUpdate(entity, false);
        PayFocusVO vo = BeanMapper.map(entity, PayFocusVO.class);
        return vo;
    }

    /**
     * 推送合同付款申请单
     * @param payFocusEntity
     */
    @Override
    public void pushPayContract(PayFocusEntity payFocusEntity) {
        List<PayFocusDetailEntity> detailList = payFocusEntity.getPayFocusDetailList();
        if(CollectionUtils.isNotEmpty(detailList)){
            Map<Long, List<PayFocusDetailEntity>> collect = detailList.stream().collect(Collectors.groupingBy(o -> o.getProjectId()));
            for (Map.Entry<Long, List<PayFocusDetailEntity>> p :collect.entrySet()){
                List<PayFocusDetailEntity> list = p.getValue();
                if(CollectionUtils.isNotEmpty(list)){
                    BigDecimal settleMny = list.stream().filter(PayFocusDetailEntity -> PayFocusDetailEntity.getSettleMny() != null).map(PayFocusDetailEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal bodyApplyMny = list.stream().filter(PayFocusDetailEntity -> PayFocusDetailEntity.getBodyApplyMny() != null).map(PayFocusDetailEntity::getBodyApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal surplusApplyMny = list.stream().filter(PayFocusDetailEntity -> PayFocusDetailEntity.getSurplusApplyMny() != null).map(PayFocusDetailEntity::getSurplusApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractPayMny = list.stream().filter(PayFocusDetailEntity -> PayFocusDetailEntity.getContractPayMny() != null).map(PayFocusDetailEntity::getContractPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                    PayContractEntity payContractEntity = new PayContractEntity();
                    Long tenantId = InvocationInfoProxy.getTenantid();
                    CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PAY_CONTRACT_BILL_CODE, tenantId);
                    if (billCode.isSuccess()) {
                        payContractEntity.setBillCode(billCode.getData());
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    payContractEntity.setBillState(1);
                    payContractEntity.setPayType(2);
                    payContractEntity.setPayStatus(1);
                    payContractEntity.setContractType(payFocusEntity.getContractType());
                    payContractEntity.setContractName(payFocusEntity.getContractName());
                    payContractEntity.setContractId(payFocusEntity.getContractId());
                    payContractEntity.setFeeType(2L);//过程款
                    payContractEntity.setPayUnitId(payFocusEntity.getPayUnitId());
                    payContractEntity.setPayUnitName(payFocusEntity.getPayUnitName());
                    payContractEntity.setDependOnProject("1");//属于项目
                    payContractEntity.setProjectId(p.getKey());
                    payContractEntity.setProjectName(list.get(0).getProjectName());
                    payContractEntity.setApplyTime(payFocusEntity.getApplyTime());
                    payContractEntity.setPayReason(payFocusEntity.getPayReason());
                    payContractEntity.setOrgId(list.get(0).getOrgId());
                    payContractEntity.setOrgName(list.get(0).getOrgName());
                    payContractEntity.setContractCode(payFocusEntity.getContractCode());
                    payContractEntity.setProjectType(list.get(0).getProjectType());
                    payContractEntity.setProjectTypeName(list.get(0).getProjectTypeName());
                    payContractEntity.setReceiveUnitId(payFocusEntity.getReceiveUnitId());
                    payContractEntity.setReceiveUnitName(payFocusEntity.getReceiveUnitName());
                    payContractEntity.setApplyUserId(payFocusEntity.getApplyUserId());
                    payContractEntity.setApplyUserName(payFocusEntity.getApplyUserName());
                    payContractEntity.setContractMny(payFocusEntity.getContractMny());
                    payContractEntity.setApplyMny(bodyApplyMny);//本期申请金额
                    payContractEntity.setApplyMnyCn(payFocusEntity.getApplyMnyCn());//申请金额大写
                    // 根据合同、项目查询结算金额
                    payContractEntity.setSumSettleMny(this.getSumSettleMny(payContractEntity));//已结算金额
                    //根据合同、项目查询付款相关金额字段
                    PayContractVO payContractInfo = this.getPayContractInfo(payContractEntity);

                    payContractEntity.setSumApplyMny(payContractInfo.getApplyMny());//截至上期已申请
                    payContractEntity.setSumPayMny(payContractInfo.getPayMny());//累计已付
                    payContractEntity.setSumInvoiceMny(this.getSumInvoiceMny(payContractEntity));//已收票金额
                    payContractEntity.setEndthisPayScaleByContract(payContractInfo.getEndthisPayScaleByContract());//截止本期申请比例（按合同）
                    payContractEntity.setEndthisPayScale(payContractInfo.getEndthisPayScale());//截止本期申请比例（按结算）
                    payContractEntity.setProSurplusMny(list.get(0).getProSurplusMny());// 项目可用资金
                    payContractEntity.setProSurplusApplyMny(list.get(0).getProSurplusApplyMny());//剩余可申请金额
                    payContractEntity.setCurSettleMoney(settleMny);//结算金额
                    payContractEntity.setCurContractPayMoney(contractPayMny);//合同应付金额
                    payContractEntity.setSumSurplusApplyMny(surplusApplyMny);//剩余申请金额
                    payContractEntity.setAccountName(payFocusEntity.getAccountName());
                    payContractEntity.setAccountNum(payFocusEntity.getAccountNum());
                    payContractEntity.setAccountBank(payFocusEntity.getAccountBank());

                    payContractService.saveOrUpdate(payContractEntity,false);
                    List<PayContractSettleEntity> payContractSettleList = BeanMapper.mapList(list,PayContractSettleEntity.class);
                    for (PayContractSettleEntity settleEntity : payContractSettleList) {
                        settleEntity.setId(IdWorker.getId());
                        settleEntity.setPayapplyId(payContractEntity.getId());
                        settleEntity.setCreateTime(new Date());
                        settleEntity.setCreateUserName(sessionManager.getUserContext().getUserName());
                        settleEntity.setCreateUserCode(sessionManager.getUserContext().getUserCode());
                        settleEntity.setUpdateTime(null);
                        settleEntity.setUpdateUserCode(null);
                        settleEntity.setVersion(1);
                    }
                    //子表需插入
                    payContractSettleService.saveOrUpdateBatch(payContractSettleList,payContractSettleList.size(),false);
                    //回写结算单累计申请金额、剩余可申请金额
                    writeBackSumApplyMny(payContractEntity,payContractSettleList,true);
                }
            }

        }
    }

    /**
     * 根据项目合同查询结算金额
     * @param entity
     * @return
     */
    public BigDecimal getSumSettleMny(PayContractEntity entity){
        BigDecimal sumSettleMny = BigDecimal.ZERO;
        if(entity.getContractType() == 1){ //分包
            CommonResponse<SubSettleVO> resp = subApi.getSumSettleTaxMny(entity.getContractId(),entity.getProjectId());
            if(resp.isSuccess()){
                sumSettleMny = resp.getData().getSumSettleTaxMny();
            }
        }
        if(entity.getContractType() == 2) {//设备采购
            CommonResponse<PurchaseSettlementVO> resp = equipmentApi.getSumSettleTaxMny(entity.getContractId(),entity.getProjectId());
            if(resp.isSuccess()){
                sumSettleMny = resp.getData().getSumSettlementTaxMny();
            }
        }
        if(entity.getContractType() == 4){//物资采购
            CommonResponse<BigDecimal> resp = materialApi.getSumSettleTaxMny(entity.getContractId(),entity.getProjectId());
            if(resp.isSuccess()){
                sumSettleMny = resp.getData();
            }
        }
        return sumSettleMny;
    }

    //根据项目合同查询合同付款申请相关金额数据
    public PayContractVO getPayContractInfo(PayContractEntity entity){
        LambdaQueryWrapper<PayContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(PayContractEntity::getTenantId,InvocationInfoProxy.getTenantid());
        wrapper.eq(PayContractEntity::getContractId,entity.getContractId());
        wrapper.eq(PayContractEntity::getProjectId,entity.getProjectId());
        List<PayContractEntity> list = payContractService.list(wrapper);
        BigDecimal applyMny = BigDecimal.ZERO;
        BigDecimal payMny = BigDecimal.ZERO;
        //list.stream().filter(PayContractEntity -> PayContractEntity.getApplyMny() != null).map(PayContractEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        //list.stream().filter(PayContractEntity -> PayContractEntity.getPayMny() != null).map(PayContractEntity::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (PayContractEntity contractEntity : list) {
            applyMny = MathUtil.safeAdd(applyMny,contractEntity.getApplyMny());
            payMny = MathUtil.safeAdd(payMny,contractEntity.getPayMny());
        }
        BigDecimal endthisPayScaleByContract = MathUtil.safeDiv(MathUtil.safeAdd(applyMny,entity.getApplyMny()),entity.getContractMny());
        BigDecimal endthisPayScale = MathUtil.safeDiv(MathUtil.safeAdd(applyMny,entity.getApplyMny()),entity.getSumSettleMny());

        PayContractVO vo = new PayContractVO();
        vo.setApplyMny(applyMny);
        vo.setPayMny(payMny);
        vo.setEndthisPayScaleByContract(endthisPayScaleByContract.multiply(new BigDecimal(100)));
        vo.setEndthisPayScale(endthisPayScale.multiply(new BigDecimal(100)));
        return vo;
    }
    //根据合同项目查询累计收票金额
    public BigDecimal getSumInvoiceMny(PayContractEntity entity){
        CommonResponse<BigDecimal> resp = invoiceApi.getSumInvoiceReceiveMny(entity.getContractId(),entity.getProjectId());
        BigDecimal currentReceiveMnyTax = BigDecimal.ZERO;
        if(resp.isSuccess()){
            currentReceiveMnyTax = resp.getData();
        }
        return currentReceiveMnyTax;
    }

    /**
     * 回写结算单累计申请金额、剩余可申请金额
     * @param entity
     * @param flag
     */
    public boolean writeBackSumApplyMny(PayContractEntity entity,List<PayContractSettleEntity> settleEntityList, boolean flag) {
        //List<PayContractSettleEntity> settleEntityList = settleService.list(new QueryWrapper<PayContractSettleEntity>().eq("payapply_id", billId));
        // 结算单对应本期申请金额
        Map<Long, BigDecimal> settleApplyMnyMap  = new HashMap<>();
        for(PayContractSettleEntity settleEntity : settleEntityList){
            // 本期申请金额   true为回写，false为逆回写
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub(new BigDecimal(0), settleEntity.getBodyApplyMny());
            settleApplyMnyMap.put(settleEntity.getSettleId(), applyMny);
        }
        if(entity.getContractType() == 1){//分包
            for(PayContractSettleEntity settleEntity : settleEntityList){
                subApi.updateSubSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 2){//设备采购
            for(PayContractSettleEntity settleEntity : settleEntityList){
                equipmentApi.updatePurchaseSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }

        if(entity.getContractType() == 4){//物资采购
            for(PayContractSettleEntity settleEntity : settleEntityList){
                materialApi.updateSettlementBillAlreadyApplyAmount(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        return true;
    }

    /**
     * 根据项目id查询项目相关信息
     * @param list
     */
    private List<PayFocusDetailEntity> updateFocusDetailProjectInfo(List<PayFocusDetailEntity> list){
        for (PayFocusDetailEntity detailVO : list) {
            if(detailVO.getProjectId() != null){
                CommonResponse<ProjectRegisterVO> commonResponse = projectApi.queryProjectDetail(detailVO.getProjectId());
                if(commonResponse.isSuccess()){
                    ProjectRegisterVO projectVO = commonResponse.getData();
                    detailVO.setProjectType(projectVO.getType());
                    detailVO.setProjectTypeName(projectVO.getTypeName());
                    detailVO.setParentOrgId(projectVO.getOrgId());
                    detailVO.setParentOrgName(projectVO.getOrgName());
                }
                // 还需要查询项目剩余可申请金额，项目资金，调合同付款申请接口
                ProjectFinanceVO proFinance = payContractService.getProFinance(detailVO.getProjectId());
                if(proFinance != null){
                    detailVO.setProSurplusMny(proFinance.getProSurplusMny());
                    detailVO.setProSurplusApplyMny(proFinance.getProSurplusApplyMny());
                }
            }
        }
        return list;
    }

    /**
     * 校验同一项目是否有未生效单据
     * @param entity
     */
    private void validateBeforeSave(PayFocusEntity entity){
        LambdaQueryWrapper<PayFocusEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(PayFocusEntity::getContractId, entity.getContractId());
        lambda.eq(PayFocusEntity::getOrgId, entity.getOrgId());
        lambda.eq(PayFocusEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambda.ne(entity.getId() != null && entity.getId() > 0,PayFocusEntity::getId, entity.getId());
        List<PayFocusEntity> list = super.list(lambda);
        if (CollectionUtils.isNotEmpty(list)) {
            for (PayFocusEntity f : list) {
                List<Integer> effectState = Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode());
                if (!effectState.contains(f.getBillState())) {
                    throw new BusinessException("该合同在同一组织下存在未生效单据,不允许新增!");
                }
            }
        }

    }
}
