/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.util.NoticeEnum;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PayRecordMessageService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${weixin_template.check_id}")
    private String weixinCheckTemplateId;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IDefdocApi defdocApi;

    public CommonResponse<String> sendMsg(PayRecordVO payRecordVO, String[] receivers, NoticeEnum notice) {
        if (payRecordVO != null) {
            String url = "";
            String feeTypeName = "";
            if ("\u5408\u540c\u4ed8\u6b3e".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/manageList/contractCard?id=" + payRecordVO.getPayapplyId();
                feeTypeName = payRecordVO.getFeeType() == 1L ? "-\u9884\u4ed8\u6b3e" : (payRecordVO.getFeeType() == 2L ? "-\u8fc7\u7a0b\u6b3e" : "-\u5176\u4ed6");
            }
            if ("\u96f6\u661f\u91c7\u8d2d".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/manageList/sporadicCard?id=" + payRecordVO.getPayapplyId();
            }
            if ("\u62a5\u9500".equals(payRecordVO.getApplyType())) {
                DefdocDetailVO defdocDetailVO;
                url = "ejc-finance-frontend/#/manageList/reimburseCard?id=" + payRecordVO.getPayapplyId();
                CommonResponse defResp = this.defdocApi.getDefDocByDefId(Long.valueOf(324875125018329093L));
                if (!defResp.isSuccess()) {
                    this.logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6863\u6848\u5217\u8868\u5931\u8d25\uff1a{}", (Object)defResp.getMsg());
                }
                if ((defdocDetailVO = ((List)defResp.getData()).stream().filter(defVo -> defVo.getId().equals(payRecordVO.getFeeType())).findFirst().get()) != null) {
                    feeTypeName = "-" + defdocDetailVO.getName();
                }
            }
            if ("\u62bc\u91d1".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/manageList/foregiftCard?id=" + payRecordVO.getPayapplyId();
            }
            this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb========= msgId = " + payRecordVO.getMsgId() + "\uff0cmsgBillCode = " + payRecordVO.getMsgBillCode());
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("sys");
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put("#FEETYPE#", payRecordVO.getApplyType() + feeTypeName);
            keyMap.put("#BILLCODE#", payRecordVO.getMsgBillCode());
            keyMap.put("#THISPAYMNY#", String.valueOf(ComputeUtil.scaleTwo((BigDecimal)payRecordVO.getThisPayMny())));
            keyMap.put("#ID#", String.valueOf(payRecordVO.getMsgId()));
            keyMap.put("#BASEHOST#", this.baseHost + url);
            this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb========= url = " + this.baseHost + url);
            if (StringUtils.isNotBlank((CharSequence)this.weixinCheckTemplateId)) {
                String remark = "\u8d39\u7528\u7c7b\u578b\uff1a" + payRecordVO.getApplyType() + feeTypeName + "\uff1b\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\uff1a" + ComputeUtil.scaleTwo((BigDecimal)payRecordVO.getThisPayMny()) + "\u5143\uff1b\u542b\u672c\u671f\u7d2f\u8ba1\u652f\u4ed8\u91d1\u989d\uff1a" + ComputeUtil.scaleTwo((BigDecimal)payRecordVO.getMsgPayMny()) + "\u5143\uff1b";
                JSONObject weixinParams = new JSONObject();
                weixinParams.put("template_id", (Object)this.weixinCheckTemplateId);
                JSONObject wxparams = new JSONObject();
                wxparams.put("first", (Object)NoticeEnum.getMobileContent((NoticeEnum)notice, keyMap));
                wxparams.put("keyword1", (Object)String.valueOf(ComputeUtil.scaleTwo((BigDecimal)payRecordVO.getThisPayMny())));
                wxparams.put("keyword2", (Object)payRecordVO.getMsgBillCode());
                wxparams.put("remark", (Object)remark);
                weixinParams.put("data", (Object)wxparams);
                this.logger.info("==============================\u5fae\u4fe1\u516c\u4f17\u53f7===================================================");
                parameter.setWeixinParams(weixinParams);
            } else {
                this.logger.info("\u672a\u914d\u7f6e\u5fae\u4fe1\u516c\u4f17\u53f7\u6a21\u677f\uff0c\u6545\u4e0d\u53d1\u5fae\u4fe1\u516c\u4f17\u53f7\u6d88\u606f");
            }
            parameter.setReceivers(receivers);
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setMsgType("notice");
            parameter.setSubject(notice.getSubject());
            this.logger.info("==============================\u7cfb\u7edf\u6d88\u606f===================================================");
            String sysContent = NoticeEnum.getPcContent((NoticeEnum)notice, keyMap);
            this.logger.info("sysContent = " + sysContent);
            parameter.setContent(sysContent);
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                } else {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
            }
        }
        return CommonResponse.success();
    }
}

