package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayFocusDetailEntity;
import com.ejianc.business.finance.bean.PayFocusEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayFocusService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

public class PayFocusThread implements Runnable {

    private Logger logger;

    private Long billId;
    private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT";
    private Integer state;

    private IPayContractService payContractService;
    private SessionManager sessionManager;
    private IPayContractSettleService payContractSettleService;

    private IPayFocusService payFocusService;
    private IBillCodeApi billCodeApi;
    private ISubContractForPayApi subApi;
    private IEquipmentContractApi equipmentApi;
    private IMaterialSettlementApi materialApi;
    private IInvoiceApi invoiceApi;


    private String userCode;
    private String userName;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public ISubContractForPayApi getSubApi() {
        return subApi;
    }

    public void setSubApi(ISubContractForPayApi subApi) {
        this.subApi = subApi;
    }

    public SessionManager getSessionManager() {
        return sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public IEquipmentContractApi getEquipmentApi() {
        return equipmentApi;
    }

    public IBillCodeApi getBillCodeApi() {
        return billCodeApi;
    }

    public void setBillCodeApi(IBillCodeApi billCodeApi) {
        this.billCodeApi = billCodeApi;
    }

    public void setEquipmentApi(IEquipmentContractApi equipmentApi) {
        this.equipmentApi = equipmentApi;
    }

    public IMaterialSettlementApi getMaterialApi() {
        return materialApi;
    }

    public void setMaterialApi(IMaterialSettlementApi materialApi) {
        this.materialApi = materialApi;
    }

    public IInvoiceApi getInvoiceApi() {
        return invoiceApi;
    }

    public void setInvoiceApi(IInvoiceApi invoiceApi) {
        this.invoiceApi = invoiceApi;
    }

    public void setState(Integer state) {
        this.state = state;
    }


    public IPayContractService getPayContractService() {
        return payContractService;
    }

    public void setPayContractService(IPayContractService payContractService) {
        this.payContractService = payContractService;
    }

    public IPayContractSettleService getPayContractSettleService() {
        return payContractSettleService;
    }

    public void setPayContractSettleService(IPayContractSettleService payContractSettleService) {
        this.payContractSettleService = payContractSettleService;
    }

    public IPayFocusService getPayFocusService() {
        return payFocusService;
    }

    public void setPayFocusService(IPayFocusService payFocusService) {
        this.payFocusService = payFocusService;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public void run() {
        try {
            doSomething();
        } catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw, true));
            String infomsg = sw.toString();
            logger.error(infomsg);
        }
    }

    public BigDecimal getSumSettleMny(PayContractEntity entity) {
        BigDecimal sumSettleMny = BigDecimal.ZERO;
        if (entity.getContractType() == 1) { //分包
            CommonResponse<SubSettleVO> resp = subApi.getSumSettleTaxMny(entity.getContractId(), entity.getProjectId());
            if (resp.isSuccess()) {
                sumSettleMny = resp.getData().getSumSettleTaxMny();
            }
        }
        if (entity.getContractType() == 2) {//设备采购
            CommonResponse<PurchaseSettlementVO> resp = equipmentApi.getSumSettleTaxMny(entity.getContractId(), entity.getProjectId());
            if (resp.isSuccess()) {
                sumSettleMny = resp.getData().getSumSettlementTaxMny();
            }
        }
        if (entity.getContractType() == 4) {//物资采购
            CommonResponse<BigDecimal> resp = materialApi.getSumSettleTaxMny(entity.getContractId(), entity.getProjectId());
            if (resp.isSuccess()) {
                sumSettleMny = resp.getData();
            }
        }
        return sumSettleMny;
    }

    public PayContractVO getPayContractInfo(PayContractEntity entity) {
        LambdaQueryWrapper<PayContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(PayContractEntity::getTenantId, InvocationInfoProxy.getTenantid());
        wrapper.eq(PayContractEntity::getContractId, entity.getContractId());
        wrapper.eq(PayContractEntity::getProjectId, entity.getProjectId());
        List<PayContractEntity> list = payContractService.list(wrapper);
        BigDecimal applyMny = BigDecimal.ZERO;
        BigDecimal payMny = BigDecimal.ZERO;
        //list.stream().filter(PayContractEntity -> PayContractEntity.getApplyMny() != null).map(PayContractEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        //list.stream().filter(PayContractEntity -> PayContractEntity.getPayMny() != null).map(PayContractEntity::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (PayContractEntity contractEntity : list) {
            applyMny = MathUtil.safeAdd(applyMny, contractEntity.getApplyMny());
            payMny = MathUtil.safeAdd(payMny, contractEntity.getPayMny());
        }
        BigDecimal endthisPayScaleByContract = MathUtil.safeDiv(MathUtil.safeAdd(applyMny, entity.getApplyMny()), entity.getContractMny());
        BigDecimal endthisPayScale = MathUtil.safeDiv(MathUtil.safeAdd(applyMny, entity.getApplyMny()), entity.getSumSettleMny());

        PayContractVO vo = new PayContractVO();
        vo.setApplyMny(applyMny);
        vo.setPayMny(payMny);
        vo.setEndthisPayScaleByContract(endthisPayScaleByContract.multiply(new BigDecimal(100)));
        vo.setEndthisPayScale(endthisPayScale.multiply(new BigDecimal(100)));
        return vo;
    }

    public BigDecimal getSumInvoiceMny(PayContractEntity entity) {
        CommonResponse<BigDecimal> resp = invoiceApi.getSumInvoiceReceiveMny(entity.getContractId(), entity.getProjectId());
        BigDecimal currentReceiveMnyTax = BigDecimal.ZERO;
        if (resp.isSuccess()) {
            currentReceiveMnyTax = resp.getData();
        }
        return currentReceiveMnyTax;
    }

    public boolean writeBackSumApplyMnyByFocus(PayFocusEntity entity, List<PayContractSettleEntity> settleEntityList, boolean flag) {
        // 结算单对应本期申请金额
        Map<Long, BigDecimal> settleApplyMnyMap = new HashMap<>();
        for (PayContractSettleEntity settleEntity : settleEntityList) {
            // 本期申请金额   true为回写，false为逆回写
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub(new BigDecimal(0), settleEntity.getBodyApplyMny());
            settleApplyMnyMap.put(settleEntity.getSettleId(), ComputeUtil.safeAdd(applyMny, settleApplyMnyMap.get(settleEntity.getSettleId())));
        }
        if (entity.getContractType() == 1) {//分包
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                subApi.updateSubSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 2) {//设备采购
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                equipmentApi.updatePurchaseSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }

        if (entity.getContractType() == 4) {//物资采购
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                materialApi.updateSettlementBillAlreadyApplyAmount(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        return true;
    }

    public void doSomething() {
        logger.info("线程开始----------------");
        if (billId != null) {
            PayFocusEntity payFocusEntity = payFocusService.selectById(billId);
            //推送合同付款申请单
            payFocusService.pushPayContract(payFocusEntity);

            List<PayFocusDetailEntity> detailList = payFocusEntity.getPayFocusDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                ArrayList<PayContractEntity> payContractEntitys = new ArrayList<>();
                ArrayList<PayContractSettleEntity> payContractSettleLists = new ArrayList<>();
                Map<Long, List<PayFocusDetailEntity>> collect = detailList.stream().collect(Collectors.groupingBy(o -> o.getProjectId()));
                for (Map.Entry<Long, List<PayFocusDetailEntity>> p : collect.entrySet()) {
                    List<PayFocusDetailEntity> list = p.getValue();
                    if (CollectionUtils.isNotEmpty(list)) {
                        BigDecimal settleMny = list.stream().filter(PayFocusDetailEntity -> PayFocusDetailEntity.getSettleMny() != null).map(PayFocusDetailEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal bodyApplyMny = list.stream().filter(PayFocusDetailEntity -> PayFocusDetailEntity.getBodyApplyMny() != null).map(PayFocusDetailEntity::getBodyApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal surplusApplyMny = list.stream().filter(PayFocusDetailEntity -> PayFocusDetailEntity.getSurplusApplyMny() != null).map(PayFocusDetailEntity::getSurplusApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal contractPayMny = list.stream().filter(PayFocusDetailEntity -> PayFocusDetailEntity.getContractPayMny() != null).map(PayFocusDetailEntity::getContractPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                        PayContractEntity payContractEntity = new PayContractEntity();
                        Long tenantId = InvocationInfoProxy.getTenantid();
                        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PAY_CONTRACT_BILL_CODE, tenantId);
                        if (billCode.isSuccess()) {
                            payContractEntity.setBillCode(billCode.getData());
                        } else {
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                        payContractEntity.setBillState(1);
                        payContractEntity.setPayType(2);
                        payContractEntity.setPayStatus(1);
                        payContractEntity.setContractType(payFocusEntity.getContractType());
                        payContractEntity.setContractName(payFocusEntity.getContractName());
                        payContractEntity.setContractId(payFocusEntity.getContractId());
                        payContractEntity.setFeeType(2L);//过程款
                        payContractEntity.setPayUnitId(payFocusEntity.getPayUnitId());
                        payContractEntity.setPayUnitName(payFocusEntity.getPayUnitName());
                        payContractEntity.setDependOnProject("1");//属于项目
                        payContractEntity.setProjectId(p.getKey());
                        payContractEntity.setProjectName(list.get(0).getProjectName());
                        payContractEntity.setApplyTime(payFocusEntity.getApplyTime());
                        payContractEntity.setPayReason(payFocusEntity.getPayReason());
                        payContractEntity.setOrgId(list.get(0).getOrgId());
                        payContractEntity.setOrgName(list.get(0).getOrgName());
                        payContractEntity.setContractCode(payFocusEntity.getContractCode());
                        payContractEntity.setProjectType(list.get(0).getProjectType());
                        payContractEntity.setProjectTypeName(list.get(0).getProjectTypeName());
                        payContractEntity.setReceiveUnitId(payFocusEntity.getReceiveUnitId());
                        payContractEntity.setReceiveUnitName(payFocusEntity.getReceiveUnitName());
                        payContractEntity.setApplyUserId(payFocusEntity.getApplyUserId());
                        payContractEntity.setApplyUserName(payFocusEntity.getApplyUserName());
                        payContractEntity.setContractMny(payFocusEntity.getContractMny());
                        payContractEntity.setApplyMny(bodyApplyMny);//本期申请金额
                        payContractEntity.setApplyMnyCn(payFocusEntity.getApplyMnyCn());//申请金额大写
                        // 根据合同、项目查询结算金额
                        payContractEntity.setSumSettleMny(this.getSumSettleMny(payContractEntity));//已结算金额
                        //根据合同、项目查询付款相关金额字段
                        PayContractVO payContractInfo = this.getPayContractInfo(payContractEntity);

                        payContractEntity.setSumApplyMny(payContractInfo.getApplyMny());//截至上期已申请
                        payContractEntity.setSumPayMny(payContractInfo.getPayMny());//累计已付
                        payContractEntity.setSumInvoiceMny(this.getSumInvoiceMny(payContractEntity));//已收票金额
                        payContractEntity.setEndthisPayScaleByContract(payContractInfo.getEndthisPayScaleByContract());//截止本期申请比例（按合同）
                        payContractEntity.setEndthisPayScale(payContractInfo.getEndthisPayScale());//截止本期申请比例（按结算）
                        payContractEntity.setProSurplusMny(list.get(0).getProSurplusMny());// 项目可用资金
                        payContractEntity.setProSurplusApplyMny(list.get(0).getProSurplusApplyMny());//剩余可申请金额
                        payContractEntity.setCurSettleMoney(settleMny);//结算金额
                        payContractEntity.setCurContractPayMoney(contractPayMny);//合同应付金额
                        payContractEntity.setSumSurplusApplyMny(surplusApplyMny);//剩余申请金额
                        payContractEntity.setAccountName(payFocusEntity.getAccountName());
                        payContractEntity.setAccountNum(payFocusEntity.getAccountNum());
                        payContractEntity.setAccountBank(payFocusEntity.getAccountBank());
                        payContractEntitys.add(payContractEntity);
                        List<PayContractSettleEntity> payContractSettleList = BeanMapper.mapList(list, PayContractSettleEntity.class);
                        for (PayContractSettleEntity settleEntity : payContractSettleList) {
                            settleEntity.setId(IdWorker.getId());
                            settleEntity.setPayapplyId(payContractEntity.getId());
                            settleEntity.setCreateTime(new Date());
                            settleEntity.setCreateUserName(sessionManager.getUserContext().getUserName());
                            settleEntity.setCreateUserCode(sessionManager.getUserContext().getUserCode());
                            settleEntity.setUpdateTime(null);
                            settleEntity.setUpdateUserCode(null);
                            settleEntity.setVersion(1);
                        }
                        //子表需插入
                        payContractSettleLists.addAll(payContractSettleList);
                        //回写结算单累计申请金额、剩余可申请金额
                        //writeBackSumApplyMny(payContractEntity,payContractSettleList,true);
                    }
                }
                logger.info("集中付款主表条数未插入=======" + payContractEntitys.size());
                logger.info("集中付款子表条数未插入=======" + payContractSettleLists.size());
                payContractService.saveOrUpdateBatch(payContractEntitys);
                payContractSettleService.saveOrUpdateBatch(payContractSettleLists);
                writeBackSumApplyMnyByFocus(payFocusEntity, payContractSettleLists, true);
                logger.info("集中付款主表条数未插入=======" + payContractEntitys.size());
                logger.info("集中付款子表条数未插入=======" + payContractSettleLists.size());
            }
        }
    }
}
