package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-05-28
 */
@TableName("ejc_finance_pay_invoice")
public class PayInvoiceEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 付款申请单主键
     */
    @TableField("payapply_id")
    private Long payapplyId;

    /**
     * 来源发票主键
     */
    @TableField("invoice_id")
    private Long invoiceId;

    /**
     * 发票号码
     */
    @TableField("invoice_number")
    private String invoiceNumber;

    /**
     * 发票代码
     */
    @TableField("invoice_code")
    private String invoiceCode;

    /**
     * 发票金额
     */
    @TableField("invoice_mny")
    private BigDecimal invoiceMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 价税合计
     */
    @TableField("invoice_tax_mny")
    private BigDecimal invoiceTaxMny;

    /**
     * 开票日期
     */
    @TableField("invoice_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date invoiceDate;

    /**
     * 创建者名称
     */
    @TableField("create_user_name")
    private String createUserName;

    /**
     * 是否占用：1 未占用， 2 已占用
     */
    @TableField("use_flag")
    private Integer useFlag;


    /**
     * 本期发票金额
     */
    @TableField("used_invoice_tax_mny")
    private BigDecimal usedInvoiceTaxMny;

    /**
     * 剩余发票金额
     */
    @TableField("surplus_invoice_tax_mny")
    private BigDecimal surplusInvoiceTaxMny;

    public BigDecimal getUsedInvoiceTaxMny() {
        return usedInvoiceTaxMny;
    }

    public void setUsedInvoiceTaxMny(BigDecimal usedInvoiceTaxMny) {
        this.usedInvoiceTaxMny = usedInvoiceTaxMny;
    }

    public BigDecimal getSurplusInvoiceTaxMny() {
        return surplusInvoiceTaxMny;
    }

    public void setSurplusInvoiceTaxMny(BigDecimal surplusInvoiceTaxMny) {
        this.surplusInvoiceTaxMny = surplusInvoiceTaxMny;
    }

    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }

    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }

    public Long getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }

    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

}
