/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.bean.PayFocusDetailEntity;
import com.ejianc.business.finance.bean.PayFocusEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayFocusService;
import com.ejianc.business.finance.service.impl.PayFocusThread;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payFocus")
public class PayFocusBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayFocusService payFocusService;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPayContractSettleService payContractSettleService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISubContractForPayApi subApi;
    private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT";
    @Autowired
    private IEquipmentContractApi equipmentApi;
    @Autowired
    private IMaterialSettlementApi materialApi;
    @Autowired
    private IInvoiceApi invoiceApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PayFocusEntity payFocusEntity = (PayFocusEntity)((Object)this.payFocusService.selectById(billId));
        this.payFocusService.pushPayContract(payFocusEntity);
        List<PayFocusDetailEntity> detailList = payFocusEntity.getPayFocusDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<Long, List<PayFocusDetailEntity>> collect = detailList.stream().collect(Collectors.groupingBy(o -> o.getProjectId()));
            Long tenantId = InvocationInfoProxy.getTenantid();
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PAY_CONTRACT_BILL_CODE, tenantId, collect.size());
            ArrayList<String> billCodeList = new ArrayList();
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            billCodeList = (List)billCode.getData();
            this.logger.info("billcode----------------\uff1a" + JSONObject.toJSONString((Object)billCode));
            this.logger.info("\u96c6\u4e2d\u4ed8\u6b3e\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406----------------\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
            PayFocusThread myThread = new PayFocusThread();
            UserContext userContext = this.sessionManager.getUserContext();
            myThread.setBillId(billId);
            myThread.setState(state);
            myThread.setLogger(this.logger);
            myThread.setPayFocusService(this.payFocusService);
            myThread.setPayContractService(this.payContractService);
            myThread.setPayContractSettleService(this.payContractSettleService);
            myThread.setEquipmentApi(this.equipmentApi);
            myThread.setInvoiceApi(this.invoiceApi);
            myThread.setMaterialApi(this.materialApi);
            myThread.setBillCodeList(billCodeList);
            myThread.setSessionManager(this.sessionManager);
            myThread.setSubApi(this.subApi);
            myThread.setUserCode(userContext.getUserCode());
            myThread.setUserName(userContext.getUserName());
            Thread thread = new Thread(myThread);
            thread.start();
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u8be5\u5355\u636e\u65e0\u6cd5\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

