package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DecimalFormat;

@Service("loadApply")
public class LoadApplyBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ILoadApplyService loadApplyService;
    @Autowired
    private IDeductionService ideductionService;
    @Autowired
    private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<String> stringCommonResponse = billTypeApi.checkQuote(billTypeCode, billId);
        boolean success = stringCommonResponse.isSuccess();
        if (!success)
        {
            return CommonResponse.error("已经被扣款单使用不能弃审和撤回");
        }
        LoadApplyEntity entity = loadApplyService.selectById(billId);
		BigDecimal surplusMny =  loadApplyService.querySurplusMny(null,null,entity.getOrgId(),0,String.valueOf(entity.getApplyEmployeeId()));
		BigDecimal applyMny = entity.getApplyMny();
		if(applyMny.compareTo(surplusMny)>0){
			DecimalFormat df1 = new DecimalFormat("###,###.##");
			return CommonResponse.error("申请金额大于可用金额【"+df1.format(surplusMny)+"】,不能弃审!");
		}

		LambdaQueryWrapper<LoadApplyEntity> lambdachange = Wrappers.<LoadApplyEntity>lambdaQuery();
		lambdachange.eq(LoadApplyEntity::getApplyEmployeeId,InvocationInfoProxy.getEmployeeId());
		lambdachange.eq(LoadApplyEntity::getOrgId,entity.getOrgId());
		lambdachange.notIn(LoadApplyEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
		int nums = loadApplyService.count(lambdachange);
		if (nums > 0) {
			return CommonResponse.error("审批回写异常!该组织下已存在未生效的单据,不允许撤回!");
		}else{
			return CommonResponse.success();
		}

    }

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
