/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayFocusDetailEntity;
import com.ejianc.business.finance.bean.PayFocusEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayFocusService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

public class PayFocusThread
implements Runnable {
    private Logger logger;
    private Long billId;
    private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT";
    private Integer state;
    private IPayContractService payContractService;
    private SessionManager sessionManager;
    private IPayContractSettleService payContractSettleService;
    private IPayFocusService payFocusService;
    private List<String> billCodeList;
    private ISubContractForPayApi subApi;
    private IEquipmentContractApi equipmentApi;
    private IMaterialSettlementApi materialApi;
    private IInvoiceApi invoiceApi;
    private String userCode;
    private String userName;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public ISubContractForPayApi getSubApi() {
        return this.subApi;
    }

    public void setSubApi(ISubContractForPayApi subApi) {
        this.subApi = subApi;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public IEquipmentContractApi getEquipmentApi() {
        return this.equipmentApi;
    }

    public List<String> getBillCodeList() {
        return this.billCodeList;
    }

    public void setBillCodeList(List<String> billCodeList) {
        this.billCodeList = billCodeList;
    }

    public void setEquipmentApi(IEquipmentContractApi equipmentApi) {
        this.equipmentApi = equipmentApi;
    }

    public IMaterialSettlementApi getMaterialApi() {
        return this.materialApi;
    }

    public void setMaterialApi(IMaterialSettlementApi materialApi) {
        this.materialApi = materialApi;
    }

    public IInvoiceApi getInvoiceApi() {
        return this.invoiceApi;
    }

    public void setInvoiceApi(IInvoiceApi invoiceApi) {
        this.invoiceApi = invoiceApi;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public IPayContractService getPayContractService() {
        return this.payContractService;
    }

    public void setPayContractService(IPayContractService payContractService) {
        this.payContractService = payContractService;
    }

    public IPayContractSettleService getPayContractSettleService() {
        return this.payContractSettleService;
    }

    public void setPayContractSettleService(IPayContractSettleService payContractSettleService) {
        this.payContractSettleService = payContractSettleService;
    }

    public IPayFocusService getPayFocusService() {
        return this.payFocusService;
    }

    public void setPayFocusService(IPayFocusService payFocusService) {
        this.payFocusService = payFocusService;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public void run() {
        try {
            this.doSomething();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            String infomsg = sw.toString();
            this.logger.error(infomsg);
        }
    }

    public BigDecimal getSumSettleMny(PayContractEntity entity) {
        CommonResponse resp;
        BigDecimal sumSettleMny = BigDecimal.ZERO;
        if (entity.getContractType() == 1L && (resp = this.subApi.getSumSettleTaxMny(entity.getContractId(), entity.getProjectId())).isSuccess()) {
            sumSettleMny = ((SubSettleVO)resp.getData()).getSumSettleTaxMny();
        }
        if (entity.getContractType() == 2L && (resp = this.equipmentApi.getSumSettleTaxMny(entity.getContractId(), entity.getProjectId())).isSuccess()) {
            sumSettleMny = ((PurchaseSettlementVO)resp.getData()).getSumSettlementTaxMny();
        }
        if (entity.getContractType() == 4L && (resp = this.materialApi.getSumSettleTaxMny(entity.getContractId(), entity.getProjectId())).isSuccess()) {
            sumSettleMny = (BigDecimal)resp.getData();
        }
        return sumSettleMny;
    }

    public PayContractVO getPayContractInfo(PayContractEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq(PayContractEntity::getContractId, (Object)entity.getContractId());
        wrapper.eq(PayContractEntity::getProjectId, (Object)entity.getProjectId());
        List list = this.payContractService.list((Wrapper)wrapper);
        BigDecimal applyMny = BigDecimal.ZERO;
        BigDecimal payMny = BigDecimal.ZERO;
        for (PayContractEntity contractEntity : list) {
            applyMny = MathUtil.safeAdd((BigDecimal)applyMny, (BigDecimal)contractEntity.getApplyMny());
            payMny = MathUtil.safeAdd((BigDecimal)payMny, (BigDecimal)contractEntity.getPayMny());
        }
        BigDecimal endthisPayScaleByContract = MathUtil.safeDiv((BigDecimal)MathUtil.safeAdd((BigDecimal)applyMny, (BigDecimal)entity.getApplyMny()), (BigDecimal)entity.getContractMny());
        BigDecimal endthisPayScale = MathUtil.safeDiv((BigDecimal)MathUtil.safeAdd((BigDecimal)applyMny, (BigDecimal)entity.getApplyMny()), (BigDecimal)entity.getSumSettleMny());
        PayContractVO vo = new PayContractVO();
        vo.setApplyMny(applyMny);
        vo.setPayMny(payMny);
        vo.setEndthisPayScaleByContract(endthisPayScaleByContract.multiply(new BigDecimal(100)));
        vo.setEndthisPayScale(endthisPayScale.multiply(new BigDecimal(100)));
        return vo;
    }

    public BigDecimal getSumInvoiceMny(PayContractEntity entity) {
        CommonResponse resp = this.invoiceApi.getSumInvoiceReceiveMny(entity.getContractId(), entity.getProjectId());
        BigDecimal currentReceiveMnyTax = BigDecimal.ZERO;
        if (resp.isSuccess()) {
            currentReceiveMnyTax = (BigDecimal)resp.getData();
        }
        return currentReceiveMnyTax;
    }

    public boolean writeBackSumApplyMnyByFocus(PayFocusEntity entity, List<PayContractSettleEntity> settleEntityList, boolean flag) {
        HashMap<Long, BigDecimal> settleApplyMnyMap = new HashMap<Long, BigDecimal>();
        for (PayContractSettleEntity settleEntity : settleEntityList) {
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)settleEntity.getBodyApplyMny());
            settleApplyMnyMap.put(settleEntity.getSettleId(), ComputeUtil.safeAdd((BigDecimal)applyMny, (BigDecimal)((BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()))));
        }
        if (entity.getContractType() == 1L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.subApi.updateSubSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 2L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.equipmentApi.updatePurchaseSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 4L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.materialApi.updateSettlementBillAlreadyApplyAmount(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        return true;
    }

    public void doSomething() {
        PayFocusEntity payFocusEntity;
        List<PayFocusDetailEntity> detailList;
        this.logger.info("\u7ebf\u7a0b\u5f00\u59cb----------------");
        if (this.billId != null && CollectionUtils.isNotEmpty(detailList = (payFocusEntity = (PayFocusEntity)((Object)this.payFocusService.selectById(this.billId))).getPayFocusDetailList())) {
            ArrayList<PayContractEntity> payContractEntitys = new ArrayList<PayContractEntity>();
            ArrayList<PayContractSettleEntity> payContractSettleLists = new ArrayList<PayContractSettleEntity>();
            Map<Long, List<PayFocusDetailEntity>> collect = detailList.stream().collect(Collectors.groupingBy(o -> o.getProjectId()));
            int i = 0;
            for (Map.Entry<Long, List<PayFocusDetailEntity>> p : collect.entrySet()) {
                List<PayFocusDetailEntity> list = p.getValue();
                if (!CollectionUtils.isNotEmpty(list)) continue;
                BigDecimal settleMny = list.stream().filter(PayFocusDetailEntity2 -> PayFocusDetailEntity2.getSettleMny() != null).map(PayFocusDetailEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal bodyApplyMny = list.stream().filter(PayFocusDetailEntity2 -> PayFocusDetailEntity2.getBodyApplyMny() != null).map(PayFocusDetailEntity::getBodyApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal surplusApplyMny = list.stream().filter(PayFocusDetailEntity2 -> PayFocusDetailEntity2.getSurplusApplyMny() != null).map(PayFocusDetailEntity::getSurplusApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal contractPayMny = list.stream().filter(PayFocusDetailEntity2 -> PayFocusDetailEntity2.getContractPayMny() != null).map(PayFocusDetailEntity::getContractPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                PayContractEntity payContractEntity = new PayContractEntity();
                payContractEntity.setBillCode(this.billCodeList.get(i));
                ++i;
                payContractEntity.setSourceType(1);
                payContractEntity.setBillState(1);
                payContractEntity.setPayType(2);
                payContractEntity.setPayStatus(1);
                payContractEntity.setContractType(payFocusEntity.getContractType());
                payContractEntity.setContractName(payFocusEntity.getContractName());
                payContractEntity.setContractId(payFocusEntity.getContractId());
                payContractEntity.setFeeType(2L);
                payContractEntity.setPayUnitId(payFocusEntity.getPayUnitId());
                payContractEntity.setPayUnitName(payFocusEntity.getPayUnitName());
                payContractEntity.setDependOnProject("1");
                payContractEntity.setProjectId(p.getKey());
                payContractEntity.setProjectName(list.get(0).getProjectName());
                payContractEntity.setApplyTime(payFocusEntity.getApplyTime());
                payContractEntity.setPayReason(payFocusEntity.getPayReason());
                payContractEntity.setOrgId(list.get(0).getOrgId());
                payContractEntity.setOrgName(list.get(0).getOrgName());
                payContractEntity.setContractCode(payFocusEntity.getContractCode());
                payContractEntity.setProjectType(list.get(0).getProjectType());
                payContractEntity.setProjectTypeName(list.get(0).getProjectTypeName());
                payContractEntity.setReceiveUnitId(payFocusEntity.getReceiveUnitId());
                payContractEntity.setReceiveUnitName(payFocusEntity.getReceiveUnitName());
                payContractEntity.setApplyUserId(payFocusEntity.getApplyUserId());
                payContractEntity.setApplyUserName(payFocusEntity.getApplyUserName());
                payContractEntity.setContractMny(payFocusEntity.getContractMny());
                payContractEntity.setApplyMny(bodyApplyMny);
                payContractEntity.setApplyMnyCn(payFocusEntity.getApplyMnyCn());
                payContractEntity.setSumSettleMny(this.getSumSettleMny(payContractEntity));
                PayContractVO payContractInfo = this.getPayContractInfo(payContractEntity);
                payContractEntity.setSumApplyMny(payContractInfo.getApplyMny());
                payContractEntity.setSumPayMny(payContractInfo.getPayMny());
                payContractEntity.setSumInvoiceMny(this.getSumInvoiceMny(payContractEntity));
                payContractEntity.setEndthisPayScaleByContract(payContractInfo.getEndthisPayScaleByContract());
                payContractEntity.setEndthisPayScale(payContractInfo.getEndthisPayScale());
                payContractEntity.setProSurplusMny(list.get(0).getProSurplusMny());
                payContractEntity.setProSurplusApplyMny(list.get(0).getProSurplusApplyMny());
                payContractEntity.setCurSettleMoney(settleMny);
                payContractEntity.setCurContractPayMoney(contractPayMny);
                payContractEntity.setSumSurplusApplyMny(surplusApplyMny);
                payContractEntity.setAccountName(payFocusEntity.getAccountName());
                payContractEntity.setAccountNum(payFocusEntity.getAccountNum());
                payContractEntity.setAccountBank(payFocusEntity.getAccountBank());
                payContractEntitys.add(payContractEntity);
                List payContractSettleList = BeanMapper.mapList(list, PayContractSettleEntity.class);
                for (PayContractSettleEntity settleEntity : payContractSettleList) {
                    settleEntity.setId(IdWorker.getId());
                    settleEntity.setPayapplyId(payContractEntity.getId());
                    settleEntity.setCreateTime(new Date());
                    settleEntity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                    settleEntity.setCreateUserCode(this.sessionManager.getUserContext().getUserCode());
                    settleEntity.setUpdateTime(null);
                    settleEntity.setUpdateUserCode(null);
                    settleEntity.setVersion(1);
                }
                payContractSettleLists.addAll(payContractSettleList);
            }
            this.logger.info("\u96c6\u4e2d\u4ed8\u6b3e\u4e3b\u8868\u6761\u6570\u672a\u63d2\u5165=======" + payContractEntitys.size());
            this.logger.info("\u96c6\u4e2d\u4ed8\u6b3e\u5b50\u8868\u6761\u6570\u672a\u63d2\u5165=======" + payContractSettleLists.size());
            this.payContractService.saveOrUpdateBatch(payContractEntitys);
            this.payContractSettleService.saveOrUpdateBatch(payContractSettleLists);
            this.writeBackSumApplyMnyByFocus(payFocusEntity, payContractSettleLists, true);
            this.logger.info("\u96c6\u4e2d\u4ed8\u6b3e\u4e3b\u8868\u6761\u6570\u672a\u63d2\u5165=======" + payContractEntitys.size());
            this.logger.info("\u96c6\u4e2d\u4ed8\u6b3e\u5b50\u8868\u6761\u6570\u672a\u63d2\u5165=======" + payContractSettleLists.size());
        }
    }
}

