package com.ejianc.business.finance.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 借款报销
 *
 * @author generator
 *
 */
 @TableName("ejc_finance_load_reimburse")
public class LoadReimburseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    /**
     * 是否属于项目
     */
    @TableField(value = "depend_on_project")
    private String dependOnProject;
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @TableField(value="cost_type")
    private java.lang.Long costType; // 费用类型
    @TableField(value="bill_code")
    private java.lang.String billCode; // 报销编号
    @TableField(value="memo")
    private java.lang.String memo; // 备注
    @TableField(value="reimburse_mny")
    private java.math.BigDecimal reimburseMny; // 本次报销金额
    @TableField(value="surplus_mny")
    private java.math.BigDecimal surplusMny; // 剩余可报销金额
    @TableField(value="invoice_mny")
    private java.math.BigDecimal invoiceMny; // 发票金额
    @TableField(value="apply_employee_id")
    private java.lang.Long applyEmployeeId; // 申请人
    @TableField(value="apply_employee_name")
    private java.lang.String applyEmployeeName; // 申请人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="apply_time")
    private java.util.Date applyTime; // 申请时间
    @TableField(value="account_name")
    private java.lang.String accountName; // 账户名
    @TableField(value="bank_account")
    private java.lang.String bankAccount; // 银行账号
    @TableField(value="bank_name")
    private java.lang.String bankName; // 开户行
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态
    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;
    /**
     * 关联状态(1:是，0：否)
     */
    @TableField("relation_flag")
    private String relationFlag;
    /**
     * 分摊状态(1:是，0：否)
     */
    @TableField("proportion_flag")
    private String proportionFlag;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;
    @TableField(value="reimburse_mmy")
    private java.math.BigDecimal reimburseMmy; // 报销费用（报销费用=付款申请中的报销费用+备用金报销）
    @TableField(value="manage_mmy")
    private java.math.BigDecimal manageMmy;
    @TableField(value="cumulative_mny")
    private java.math.BigDecimal cumulativeMny; //  累计报销

    /**
     * 是否需要发票：1 有，2 没有，3 不确定
     */
    @TableField(value="invoice_flag")
    private String invoiceFlag;

    @TableField(value="org_code")
    private String orgCode; // 组织编码

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="loadInvoiceService",pidName = "reimburseId")
    private List<LoadInvoiceEntity> invoiceVOList = new ArrayList<>();

    public List<LoadInvoiceEntity> getInvoiceVOList() {
        return invoiceVOList;
    }

    public void setInvoiceVOList(List<LoadInvoiceEntity> invoiceVOList) {
        this.invoiceVOList = invoiceVOList;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getCostType() {
        return costType;
    }

    public void setCostType(Long costType) {
        this.costType = costType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getReimburseMny() {
        return reimburseMny;
    }

    public void setReimburseMny(BigDecimal reimburseMny) {
        this.reimburseMny = reimburseMny;
    }

    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }

    public Long getApplyEmployeeId() {
        return applyEmployeeId;
    }

    public void setApplyEmployeeId(Long applyEmployeeId) {
        this.applyEmployeeId = applyEmployeeId;
    }

    public String getApplyEmployeeName() {
        return applyEmployeeName;
    }

    public void setApplyEmployeeName(String applyEmployeeName) {
        this.applyEmployeeName = applyEmployeeName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getReimburseMmy() {
        return reimburseMmy;
    }

    public void setReimburseMmy(BigDecimal reimburseMmy) {
        this.reimburseMmy = reimburseMmy;
    }

    public BigDecimal getManageMmy() {
        return manageMmy;
    }

    public void setManageMmy(BigDecimal manageMmy) {
        this.manageMmy = manageMmy;
    }
    /**
     *  累计报销
     */
    public BigDecimal getCumulativeMny() {
        return cumulativeMny;
    }
    /**
     *  累计报销
     */
    public void setCumulativeMny(BigDecimal cumulativeMny) {
        this.cumulativeMny = cumulativeMny;
    }

    public String getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(String invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }
}
