/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payContract")
public class PayContractBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayContractService service;
    @Autowired
    private IPayContractSettleService settleService;
    @Autowired
    private IPayRecordService recordService;
    @Autowired
    private ISubContractForPayApi subApi;
    @Autowired
    private IEquipmentContractApi equipmentApi;
    @Autowired
    private ISettlementApi equipmentSettleApi;
    @Autowired
    private IMaterialSettlementApi materialApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity entity = (PayContractEntity)((Object)this.service.selectById(billId));
        this.writeBackSumApplyMny(billId, entity, true);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(PayContractEntity::getApproveTime, (Object)new Date());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity entity = (PayContractEntity)((Object)this.service.selectById(billId));
        if (!this.validateApproveTime(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5728\u672c\u7ec4\u7ec7\u4e0b\u975e\u6700\u65b0\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        if (!this.validateEffective(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5728\u672c\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        if (entity.getFeeType() != null && entity.getFeeType() == 1L && entity.getPayStatus() == 2 && !this.validatePrepayMny(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u4ed8\u6b3e\u7533\u8bf7\u5df2\u88ab\u7ed3\u7b97\u5355\u9884\u4ed8\u6b3e\u62b5\u6263\u5f15\u7528,\u4e0d\u80fd\u5f03\u5ba1!");
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity entity = (PayContractEntity)((Object)this.service.selectById(billId));
        if (2 == entity.getPayStatus()) {
            this.service.writeBackSumPayMny(billId, entity, false);
        }
        this.writeBackSumApplyMny(billId, entity, false);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(PayContractSettleEntity::getPayapplyId, (Object)billId);
        wrapper.set(PayContractSettleEntity::getSumPayMny, (Object)BigDecimal.ZERO);
        if (Optional.ofNullable(entity.getCloseFlag()).orElse(false).booleanValue()) {
            wrapper.setSql("body_apply_mny = body_apply_mny_before_close");
            entity.setApplyMny(entity.getApplyMnyBeforeClose());
            entity.setApplyMnyCn(NumberToCN.number2CN(entity.getApplyMny()));
            entity.setApplyMnyBeforeClose(null);
            entity.setCloseFlag(Boolean.FALSE);
            entity.setCloseState(null);
            entity.setCloseTime(null);
            entity.setCloseUser(null);
        }
        this.settleService.update((Wrapper)wrapper);
        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setApproveTime(null);
        entity.setConfirmTime(null);
        this.service.saveOrUpdate((Object)entity);
        this.recordService.remove((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public boolean writeBackSumApplyMny(Long billId, PayContractEntity entity, boolean flag) {
        List settleEntityList = this.settleService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        HashMap<Long, BigDecimal> settleApplyMnyMap = new HashMap<Long, BigDecimal>();
        for (PayContractSettleEntity settleEntity : settleEntityList) {
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)settleEntity.getBodyApplyMny());
            settleApplyMnyMap.put(settleEntity.getSettleId(), applyMny);
        }
        if (entity.getContractType() == 1L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.subApi.updateSubSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 2L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.equipmentApi.updatePurchaseSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 3L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.equipmentApi.updateRentSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 4L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.materialApi.updateSettlementBillAlreadyApplyAmount(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 5L) {
            // empty if block
        }
        return true;
    }

    private boolean validateEffective(PayContractEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.ne((Object)"bill_state", (Object)1);
        wrapper.ne((Object)"bill_state", (Object)3);
        List list = this.service.list((Wrapper)wrapper);
        return list.isEmpty();
    }

    private boolean validateApproveTime(PayContractEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.gt((Object)"apply_time", (Object)entity.getApplyTime());
        List list = this.service.list((Wrapper)wrapper);
        return list.isEmpty();
    }

    private boolean validatePrepayMny(PayContractEntity entity) {
        BigDecimal prepayMny;
        CommonResponse materialResponse;
        CommonResponse settleResponse;
        Long contractId = entity.getContractId();
        Long orgId = entity.getOrgId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)orgId);
        List list = this.service.list((Wrapper)wrapper);
        BigDecimal sumPrepayMny = null;
        for (PayContractEntity data : list) {
            if (data.getFeeType() != 1L) continue;
            sumPrepayMny = MathUtil.safeAdd(sumPrepayMny, (BigDecimal)data.getPayMny());
        }
        BigDecimal sumOffsetMny = null;
        if (entity.getContractType() == 1L && (settleResponse = this.subApi.getSubSettleById(contractId, orgId)).isSuccess()) {
            sumOffsetMny = ((SubSettleVO)settleResponse.getData()).getSumOffsetMny();
        }
        if (entity.getContractType() == 2L && (settleResponse = this.equipmentSettleApi.getPurchaseSettlementById(contractId, orgId)).isSuccess()) {
            sumOffsetMny = ((SettlementVO)settleResponse.getData()).getSumOffsetMny();
        }
        if (entity.getContractType() == 3L && (settleResponse = this.equipmentSettleApi.getRentSettlementById(contractId, orgId)).isSuccess()) {
            sumOffsetMny = ((SettlementVO)settleResponse.getData()).getSumOffsetMny();
        }
        if (entity.getContractType() == 4L && (materialResponse = this.materialApi.getTotalOffsetAmountByContractIdAndOrgId(contractId, orgId)).isSuccess()) {
            sumOffsetMny = (BigDecimal)materialResponse.getData();
        }
        if (entity.getContractType() == 5L) {
            // empty if block
        }
        BigDecimal bigDecimal = prepayMny = entity.getPayMny() != null ? entity.getPayMny() : new BigDecimal(0);
        if (prepayMny.compareTo(MathUtil.safeSub((BigDecimal)sumPrepayMny, (BigDecimal)sumOffsetMny)) > 0) {
            this.logger.info("prepayMny:" + prepayMny + "> sumPrepayMny:" + sumPrepayMny + " - sumOffsetMny:" + sumOffsetMny);
            return false;
        }
        return true;
    }
}

