/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.controller.api.PayContractApi;
import com.ejianc.business.finance.mapper.LoadReimburseMapper;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IloadInvoiceService;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.finance.vo.ParamsCheckDsSpreadVO;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.finance.vo.ProjectReimburseVO;
import com.ejianc.business.plan.api.IBudgetPlanApi;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="LoadReimburseService")
public class LoadReimburseServiceImpl
extends BaseServiceImpl<LoadReimburseMapper, LoadReimburseEntity>
implements ILoadReimburseService {
    private static final String BONDUP_BILL_CODE = "LOAD_REIMBURSE";
    private static final String SYS_IS_PROBUDGET_CODE = "P-D76yn127";
    private static final String CHECK_PARAM_PROBUDGET_CODE = "P-V4416932";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILoadApplyService loadApplyService;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IloadInvoiceService loadInvoiceService;
    @Autowired
    private PayContractApi payContractApi;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private ISettlementApi iSettlementApi;
    @Autowired
    private IBudgetPlanApi iBudgetPlanApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public LoadReimburseVO insertOrUpdate(LoadReimburseVO loadReimburseVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (null != loadReimburseVO && com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)loadReimburseVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                loadReimburseVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LoadReimburseEntity entity = (LoadReimburseEntity)((Object)BeanMapper.map((Object)loadReimburseVO, LoadReimburseEntity.class));
        BigDecimal surplusMny = this.loadApplyService.querySurplusMny(entity.getId(), null, entity.getOrgId(), 0, String.valueOf(entity.getApplyEmployeeId()));
        BigDecimal reimburseMny = entity.getReimburseMny();
        if (reimburseMny.compareTo(surplusMny) > 0) {
            DecimalFormat df1 = new DecimalFormat("###,###.##");
            throw new BusinessException("\u672c\u6b21\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5269\u4f59\u53ef\u62a5\u9500\u91d1\u989d\u3010" + df1.format(surplusMny) + "\u3011\u5143");
        }
        List voList = loadReimburseVO.getInvoiceVOList();
        CommonResponse<String> usedMnyRes = this.loadInvoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId());
        if (!usedMnyRes.isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }
        entity.setSurplusMny(surplusMny);
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        super.saveOrUpdate((Object)entity, false);
        return (LoadReimburseVO)BeanMapper.map((Object)((Object)entity), LoadReimburseVO.class);
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"ifnull(sum(reimburse_mny),0) as amt"});
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"depend_on_project", (Object)"1");
        if (CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in((Object)"project_id", projectIds);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (ListUtil.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        return super.getMap((Wrapper)queryWrapper);
    }

    @Override
    public CommonResponse<LoadReimburseVO> pushCost(LoadReimburseVO loadReimburseVO) {
        LoadReimburseEntity loadReimburseEntity = (LoadReimburseEntity)((Object)((LoadReimburseMapper)this.baseMapper).selectById(loadReimburseVO.getId()));
        loadReimburseEntity.setSubjectId(loadReimburseVO.getSubjectId());
        loadReimburseEntity.setSubjectName(loadReimburseVO.getSubjectName());
        super.saveOrUpdate((Object)loadReimburseEntity, false);
        this.costPush(loadReimburseEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)loadReimburseEntity), LoadReimburseVO.class));
    }

    @Override
    public void costPush(LoadReimburseEntity loadReimburseEntity) {
        if (!"1".equals(loadReimburseEntity.getDependOnProject())) {
            return;
        }
        Long subjectId = loadReimburseEntity.getSubjectId();
        boolean newRelationFlag = true;
        if (null == subjectId) {
            newRelationFlag = false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{loadReimburseEntity.getId()});
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, (Object)(newRelationFlag ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = loadReimburseEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                this.saveCost(loadReimburseEntity);
            }
            if (!newRelationFlag) {
                this.costDetailApi.deleteSubject(loadReimburseEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0") && newRelationFlag) {
            this.saveCost(loadReimburseEntity);
        }
    }

    private void saveCost(LoadReimburseEntity loadReimburseEntity) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(loadReimburseEntity.getSubjectId());
        costDetailVO.setSourceId(loadReimburseEntity.getId());
        costDetailVO.setSourceDetailId(loadReimburseEntity.getId());
        costDetailVO.setHappenTaxMny(loadReimburseEntity.getReimburseMny());
        costDetailVO.setHappenMny(loadReimburseEntity.getReimburseMny());
        costDetailVO.setHappenDate(loadReimburseEntity.getApplyTime());
        costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(BONDUP_BILL_CODE);
        costDetailVO.setSourceTabType(BONDUP_BILL_CODE);
        costDetailVO.setProjectId(loadReimburseEntity.getProjectId());
        costDetailVOList.add(costDetailVO);
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            ((Object)costDetailVOList).toString();
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ParamsCheckSpreadVO checkParams(Long projectId, BigDecimal appMoney) {
        CommonResponse budget;
        CommonResponse settleMny;
        BigDecimal purchaseSettleMny;
        BigDecimal rentSettleMny;
        BigDecimal loadReimburseMny;
        BigDecimal payReimburseMny;
        BigDecimal temp;
        BigDecimal costbudgetMny;
        BigDecimal endSum;
        BigDecimal excessMoney;
        BigDecimal sumMoney;
        BigDecimal oldSumMoney;
        ArrayList<ParamsCheckDsSpreadVO> checkDsVOS;
        BigDecimal manageRate;
        ParamsCheckSpreadVO paramsCheckVO;
        block6: {
            List<ProjectReimburseVO> projectReimburse;
            block7: {
                block4: {
                    block5: {
                        ArrayList<Long> projectIds = new ArrayList<Long>();
                        projectIds.add(projectId);
                        String[] paramsArray = new String[]{"none", "warn", "alert"};
                        paramsCheckVO = new ParamsCheckSpreadVO();
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        manageRate = BigDecimal.ZERO;
                        CommonResponse byCode = this.paramConfigApi.getByCode(SYS_IS_PROBUDGET_CODE);
                        if (!byCode.isSuccess() || null == byCode.getData()) break block4;
                        ParamRegisterSetVO data = (ParamRegisterSetVO)byCode.getData();
                        String valueData = data.getValueData();
                        if (!"1".equals(valueData)) {
                            this.logger.info("\u672a\u8bfb\u53d6\u5230\u8d39\u7387\u914d\u7f6e\u53c2\u6570\uff01" + projectId);
                            return paramsCheckVO;
                        }
                        CommonResponse probudgetCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_PROBUDGET_CODE);
                        if (!probudgetCode.isSuccess() || null == probudgetCode.getData()) break block5;
                        paramsCheckVO.setWarnType(paramsArray[((BillParamVO)probudgetCode.getData()).getControlType()]);
                        manageRate = ((BillParamVO)probudgetCode.getData()).getRoleValue();
                        checkDsVOS = new ArrayList<ParamsCheckDsSpreadVO>();
                        oldSumMoney = BigDecimal.ZERO;
                        sumMoney = BigDecimal.ZERO;
                        excessMoney = BigDecimal.ZERO;
                        endSum = BigDecimal.ZERO;
                        costbudgetMny = BigDecimal.ZERO;
                        temp = new BigDecimal(100);
                        payReimburseMny = BigDecimal.ZERO;
                        loadReimburseMny = BigDecimal.ZERO;
                        rentSettleMny = BigDecimal.ZERO;
                        purchaseSettleMny = BigDecimal.ZERO;
                        projectReimburse = this.payContractService.getProjectReimburse(projectIds, null);
                        settleMny = this.iSettlementApi.getSettleMny(projectIds);
                        budget = this.iBudgetPlanApi.getBudget(projectId);
                        if (!CollectionUtils.isNotEmpty(projectReimburse)) break block6;
                        break block7;
                    }
                    this.logger.info("\u4e0d\u7ba1\u63a7");
                    return paramsCheckVO;
                }
                this.logger.info("\u975e\u4e16\u7eaa\u9633\u5149\uff01" + projectId);
                return paramsCheckVO;
            }
            payReimburseMny = projectReimburse.get(0).getPayReimburseMny();
            loadReimburseMny = projectReimburse.get(0).getLoadReimburseMny();
        }
        if (settleMny.isSuccess() && null != settleMny.getData() && ((List)settleMny.getData()).size() > 0) {
            rentSettleMny = ((SettlementVO)((List)settleMny.getData()).get(0)).getRentSettleMny();
            purchaseSettleMny = ((SettlementVO)((List)settleMny.getData()).get(0)).getPurchaseSettleMny();
        }
        if (budget.isSuccess() && null != budget.getData()) {
            costbudgetMny = ((BudgetTemVO)budget.getData()).getManageMny();
            endSum = costbudgetMny.multiply(manageRate).divide(temp);
        }
        oldSumMoney = payReimburseMny.add(loadReimburseMny).add(rentSettleMny).add(purchaseSettleMny);
        sumMoney = oldSumMoney.add(appMoney);
        excessMoney = sumMoney.subtract(endSum);
        BigDecimal reimburseMmy = payReimburseMny.add(loadReimburseMny).add(appMoney);
        BigDecimal manageMmy = costbudgetMny;
        paramsCheckVO.setManageMmy(manageMmy);
        paramsCheckVO.setReimburseMmy(reimburseMmy);
        if (sumMoney.compareTo(endSum) > 0) {
            ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
            paramsCheckDsVO.setWarnItem("\u7ba1\u7406\u8d39\u8d85\u4ed8");
            paramsCheckDsVO.setWarnName("\u7ba1\u7406\u8d39\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u4e2d\u7ba1\u7406\u8d39\u91d1\u989d");
            paramsCheckDsVO.setContent("\u672c\u6b21\u7ba1\u7406\u8d39\u91d1\u989d\uff1a" + appMoney.setScale(2, 4) + "\u5143\uff0c\u9884\u7b97\u7ba1\u7406\u8d39\u91d1\u989d*" + manageRate.setScale(2, 4) + "%\uff1a" + endSum.setScale(2, 4) + "\u5143\u3002\u8d85\u51fa\u91d1\u989d:" + excessMoney.setScale(2, 4) + "\u5143\u3002");
            checkDsVOS.add(paramsCheckDsVO);
            paramsCheckVO.setDataSource(checkDsVOS);
        }
        return paramsCheckVO;
    }
}

