/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayFocusDetailEntity;
import com.ejianc.business.finance.bean.PayFocusEntity;
import com.ejianc.business.finance.mapper.PayFocusMapper;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayFocusService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayFocusVO;
import com.ejianc.business.finance.vo.ProjectFinanceVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payFocusService")
public class PayFocusServiceImpl
extends BaseServiceImpl<PayFocusMapper, PayFocusEntity>
implements IPayFocusService {
    private static final String BILL_CODE = "PAY_FUCOS";
    private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ISubContractForPayApi subApi;
    @Autowired
    private IEquipmentContractApi equipmentApi;
    @Autowired
    private IMaterialSettlementApi materialApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPayContractSettleService payContractSettleService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public PayFocusVO insertOrUpdate(PayFocusVO saveOrUpdateVO) {
        PayFocusEntity entity = (PayFocusEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PayFocusEntity.class));
        if (!BillStateEnum.COMMITED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState()) && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())) {
            this.validateBeforeSave(entity);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getPayFocusDetailList())) {
            List<PayFocusDetailEntity> list = this.updateFocusDetailProjectInfo(entity.getPayFocusDetailList());
            entity.setPayFocusDetailList(list);
        }
        super.saveOrUpdate((Object)entity, false);
        PayFocusVO vo = (PayFocusVO)BeanMapper.map((Object)((Object)entity), PayFocusVO.class);
        return vo;
    }

    @Override
    public void pushPayContract(PayFocusEntity payFocusEntity) {
        List<PayFocusDetailEntity> detailList = payFocusEntity.getPayFocusDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            ArrayList<PayContractEntity> payContractEntitys = new ArrayList<PayContractEntity>();
            ArrayList<PayContractSettleEntity> payContractSettleLists = new ArrayList<PayContractSettleEntity>();
            Map<Long, List<PayFocusDetailEntity>> collect = detailList.stream().collect(Collectors.groupingBy(o -> o.getProjectId()));
            int i = 1;
            for (Map.Entry<Long, List<PayFocusDetailEntity>> p : collect.entrySet()) {
                List<PayFocusDetailEntity> list = p.getValue();
                if (!CollectionUtils.isNotEmpty(list)) continue;
                BigDecimal settleMny = list.stream().filter(PayFocusDetailEntity2 -> PayFocusDetailEntity2.getSettleMny() != null).map(PayFocusDetailEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal bodyApplyMny = list.stream().filter(PayFocusDetailEntity2 -> PayFocusDetailEntity2.getBodyApplyMny() != null).map(PayFocusDetailEntity::getBodyApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal surplusApplyMny = list.stream().filter(PayFocusDetailEntity2 -> PayFocusDetailEntity2.getSurplusApplyMny() != null).map(PayFocusDetailEntity::getSurplusApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal contractPayMny = list.stream().filter(PayFocusDetailEntity2 -> PayFocusDetailEntity2.getContractPayMny() != null).map(PayFocusDetailEntity::getContractPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                PayContractEntity payContractEntity = new PayContractEntity();
                payContractEntity.setBillCode(payFocusEntity.getBillCode() + "-" + i);
                ++i;
                payContractEntity.setBillState(1);
                payContractEntity.setSourceType(1);
                payContractEntity.setPayType(2);
                payContractEntity.setPayStatus(1);
                payContractEntity.setContractType(payFocusEntity.getContractType());
                payContractEntity.setContractName(payFocusEntity.getContractName());
                payContractEntity.setContractId(payFocusEntity.getContractId());
                payContractEntity.setFeeType(2L);
                payContractEntity.setPayUnitId(payFocusEntity.getPayUnitId());
                payContractEntity.setPayUnitName(payFocusEntity.getPayUnitName());
                payContractEntity.setDependOnProject("1");
                payContractEntity.setProjectId(p.getKey());
                payContractEntity.setProjectName(list.get(0).getProjectName());
                payContractEntity.setApplyTime(payFocusEntity.getApplyTime());
                payContractEntity.setPayReason(payFocusEntity.getPayReason());
                payContractEntity.setOrgId(list.get(0).getOrgId());
                payContractEntity.setOrgName(list.get(0).getOrgName());
                payContractEntity.setContractCode(payFocusEntity.getContractCode());
                payContractEntity.setProjectType(list.get(0).getProjectType());
                payContractEntity.setProjectTypeName(list.get(0).getProjectTypeName());
                payContractEntity.setReceiveUnitId(payFocusEntity.getReceiveUnitId());
                payContractEntity.setReceiveUnitName(payFocusEntity.getReceiveUnitName());
                payContractEntity.setApplyUserId(payFocusEntity.getApplyUserId());
                payContractEntity.setApplyUserName(payFocusEntity.getApplyUserName());
                payContractEntity.setContractMny(payFocusEntity.getContractMny());
                payContractEntity.setApplyMny(bodyApplyMny);
                payContractEntity.setApplyMnyCn(payFocusEntity.getApplyMnyCn());
                payContractEntity.setSumSettleMny(this.getSumSettleMny(payContractEntity));
                PayContractVO payContractInfo = this.getPayContractInfo(payContractEntity);
                payContractEntity.setSumApplyMny(payContractInfo.getApplyMny());
                payContractEntity.setSumPayMny(payContractInfo.getPayMny());
                payContractEntity.setSumInvoiceMny(this.getSumInvoiceMny(payContractEntity));
                payContractEntity.setEndthisPayScaleByContract(payContractInfo.getEndthisPayScaleByContract());
                payContractEntity.setEndthisPayScale(payContractInfo.getEndthisPayScale());
                payContractEntity.setProSurplusMny(list.get(0).getProSurplusMny());
                payContractEntity.setProSurplusApplyMny(list.get(0).getProSurplusApplyMny());
                payContractEntity.setCurSettleMoney(settleMny);
                payContractEntity.setCurContractPayMoney(contractPayMny);
                payContractEntity.setSumSurplusApplyMny(surplusApplyMny);
                payContractEntity.setAccountName(payFocusEntity.getAccountName());
                payContractEntity.setAccountNum(payFocusEntity.getAccountNum());
                payContractEntity.setAccountBank(payFocusEntity.getAccountBank());
                payContractEntitys.add(payContractEntity);
                List payContractSettleList = BeanMapper.mapList(list, PayContractSettleEntity.class);
                for (PayContractSettleEntity settleEntity : payContractSettleList) {
                    settleEntity.setId(IdWorker.getId());
                    settleEntity.setPayapplyId(payContractEntity.getId());
                    settleEntity.setCreateTime(new Date());
                    settleEntity.setCreateUserCode(payFocusEntity.getCreateUserCode());
                    settleEntity.setUpdateTime(null);
                    settleEntity.setUpdateUserCode(null);
                    settleEntity.setVersion(1);
                }
                payContractSettleLists.addAll(payContractSettleList);
            }
            this.logger.info("\u96c6\u4e2d\u4ed8\u6b3e\u4e3b\u8868\u6761\u6570\u672a\u63d2\u5165=======" + payContractSettleLists.size());
            this.logger.info("\u96c6\u4e2d\u4ed8\u6b3e\u5b50\u8868\u6761\u6570\u672a\u63d2\u5165=======" + payContractEntitys.size());
            this.payContractService.saveOrUpdateBatch(payContractEntitys);
            this.payContractSettleService.saveOrUpdateBatch(payContractSettleLists);
            this.writeBackSumApplyMnyByFocus(payFocusEntity, payContractSettleLists, true);
            this.logger.info("\u96c6\u4e2d\u4ed8\u6b3e\u4e3b\u8868\u6761\u6570=======" + payContractSettleLists.size());
            this.logger.info("\u96c6\u4e2d\u4ed8\u6b3e\u5b50\u8868\u6761\u6570=======" + payContractEntitys.size());
        }
    }

    public boolean writeBackSumApplyMnyByFocus(PayFocusEntity entity, List<PayContractSettleEntity> settleEntityList, boolean flag) {
        HashMap<Long, BigDecimal> settleApplyMnyMap = new HashMap<Long, BigDecimal>();
        for (PayContractSettleEntity settleEntity : settleEntityList) {
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)settleEntity.getBodyApplyMny());
            settleApplyMnyMap.put(settleEntity.getSettleId(), ComputeUtil.safeAdd((BigDecimal)applyMny, (BigDecimal)((BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()))));
        }
        if (entity.getContractType() == 1L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.subApi.updateSubSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 2L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.equipmentApi.updatePurchaseSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 4L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.materialApi.updateSettlementBillAlreadyApplyAmount(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        return true;
    }

    public BigDecimal getSumSettleMny(PayContractEntity entity) {
        CommonResponse resp;
        BigDecimal sumSettleMny = BigDecimal.ZERO;
        if (entity.getContractType() == 1L && (resp = this.subApi.getSumSettleTaxMny(entity.getContractId(), entity.getProjectId())).isSuccess()) {
            sumSettleMny = ((SubSettleVO)resp.getData()).getSumSettleTaxMny();
        }
        if (entity.getContractType() == 2L && (resp = this.equipmentApi.getSumSettleTaxMny(entity.getContractId(), entity.getProjectId())).isSuccess()) {
            sumSettleMny = ((PurchaseSettlementVO)resp.getData()).getSumSettlementTaxMny();
        }
        if (entity.getContractType() == 4L && (resp = this.materialApi.getSumSettleTaxMny(entity.getContractId(), entity.getProjectId())).isSuccess()) {
            sumSettleMny = (BigDecimal)resp.getData();
        }
        return sumSettleMny;
    }

    public PayContractVO getPayContractInfo(PayContractEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq(PayContractEntity::getContractId, (Object)entity.getContractId());
        wrapper.eq(PayContractEntity::getProjectId, (Object)entity.getProjectId());
        List list = this.payContractService.list((Wrapper)wrapper);
        BigDecimal applyMny = BigDecimal.ZERO;
        BigDecimal payMny = BigDecimal.ZERO;
        for (PayContractEntity contractEntity : list) {
            applyMny = MathUtil.safeAdd((BigDecimal)applyMny, (BigDecimal)contractEntity.getApplyMny());
            payMny = MathUtil.safeAdd((BigDecimal)payMny, (BigDecimal)contractEntity.getPayMny());
        }
        BigDecimal endthisPayScaleByContract = MathUtil.safeDiv((BigDecimal)MathUtil.safeAdd((BigDecimal)applyMny, (BigDecimal)entity.getApplyMny()), (BigDecimal)entity.getContractMny());
        BigDecimal endthisPayScale = MathUtil.safeDiv((BigDecimal)MathUtil.safeAdd((BigDecimal)applyMny, (BigDecimal)entity.getApplyMny()), (BigDecimal)entity.getSumSettleMny());
        PayContractVO vo = new PayContractVO();
        vo.setApplyMny(applyMny);
        vo.setPayMny(payMny);
        vo.setEndthisPayScaleByContract(endthisPayScaleByContract.multiply(new BigDecimal(100)));
        vo.setEndthisPayScale(endthisPayScale.multiply(new BigDecimal(100)));
        return vo;
    }

    public BigDecimal getSumInvoiceMny(PayContractEntity entity) {
        CommonResponse resp = this.invoiceApi.getSumInvoiceReceiveMny(entity.getContractId(), entity.getProjectId());
        BigDecimal currentReceiveMnyTax = BigDecimal.ZERO;
        if (resp.isSuccess()) {
            currentReceiveMnyTax = (BigDecimal)resp.getData();
        }
        return currentReceiveMnyTax;
    }

    public boolean writeBackSumApplyMny(PayContractEntity entity, List<PayContractSettleEntity> settleEntityList, boolean flag) {
        HashMap<Long, BigDecimal> settleApplyMnyMap = new HashMap<Long, BigDecimal>();
        for (PayContractSettleEntity settleEntity : settleEntityList) {
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)settleEntity.getBodyApplyMny());
            settleApplyMnyMap.put(settleEntity.getSettleId(), applyMny);
        }
        if (entity.getContractType() == 1L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.subApi.updateSubSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 2L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.equipmentApi.updatePurchaseSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 4L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.materialApi.updateSettlementBillAlreadyApplyAmount(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        return true;
    }

    private List<PayFocusDetailEntity> updateFocusDetailProjectInfo(List<PayFocusDetailEntity> list) {
        for (PayFocusDetailEntity detailVO : list) {
            ProjectFinanceVO proFinance;
            if (detailVO.getProjectId() == null) continue;
            CommonResponse commonResponse = this.projectApi.queryProjectDetail(detailVO.getProjectId());
            if (commonResponse.isSuccess()) {
                ProjectRegisterVO projectVO = (ProjectRegisterVO)commonResponse.getData();
                detailVO.setProjectType(projectVO.getType());
                detailVO.setProjectTypeName(projectVO.getTypeName());
                detailVO.setParentOrgId(projectVO.getOrgId());
                detailVO.setParentOrgName(projectVO.getOrgName());
            }
            if ((proFinance = this.payContractService.getProFinance(detailVO.getProjectId())) == null) continue;
            detailVO.setProSurplusMny(proFinance.getProSurplusMny());
            detailVO.setProSurplusApplyMny(proFinance.getProSurplusApplyMny());
        }
        return list;
    }

    private void validateBeforeSave(PayFocusEntity entity) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayFocusEntity::getContractId, (Object)entity.getContractId());
        lambda.eq(PayFocusEntity::getOrgId, (Object)entity.getOrgId());
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        List list = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (PayFocusEntity f : list) {
                List<Integer> effectState = Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
                if (effectState.contains(f.getBillState())) continue;
                throw new BusinessException("\u8be5\u5408\u540c\u5728\u540c\u4e00\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u5355\u636e,\u4e0d\u5141\u8bb8\u65b0\u589e!");
            }
        }
    }
}

