package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.BidBondBackEntity;
import com.ejianc.business.finance.bean.BidBondDealEntity;
import com.ejianc.business.finance.bean.BidBondEntity;
import com.ejianc.business.finance.service.IBidBondBackService;
import com.ejianc.business.finance.service.IBidBondDealService;
import com.ejianc.business.finance.service.IBidBondService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;

@Service("bidBond") 
public class BidBondBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBidBondService bidBondService;
	@Autowired
	private IBidBondDealService bidBondDealService;
	@Autowired
	private IBidBondBackService bidBondBackService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("进入弃审后回写--- billId:"+billId+"  state:"+state);
		BidBondEntity upEntity = bidBondService.selectById(billId);
		upEntity.setBondStatus("0");
		upEntity.setBackMny(BigDecimal.ZERO);
		upEntity.setPayMny(BigDecimal.ZERO);
		upEntity.setEmployeeId(null);
		upEntity.setEmployeeName(null);
		boolean res = bidBondService.saveOrUpdate(upEntity,false);
		QueryWrapper<BidBondDealEntity> dealWrapper = new QueryWrapper<>();
		dealWrapper.eq("bond_id", billId);
		bidBondDealService.remove(dealWrapper,false);

		QueryWrapper<BidBondBackEntity> backWrapper = new QueryWrapper<>();
		backWrapper.eq("bond_id", billId);
		bidBondBackService.remove(backWrapper,false);
		if(res){
			return CommonResponse.success("回退成功!");
		}else{
			return CommonResponse.error("回退出现异常，请刷新后再试!");
		}
	}

}
