package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpBackMapper;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondUpBackVO;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 保证金退还表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondUpBackServiceImpl extends BaseServiceImpl<BondUpBackMapper, BondUpBackEntity> implements IBondUpBackService {

    private static final String BONGUP_BACK = "BONGUP_BACK";

    @Autowired
    private IBondUpService bondUpService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public BondUpBackVO insertOrUpdate(BondUpBackVO bondUpBackVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BondUpBackEntity> entities = null;
        if(StringUtils.isEmpty(bondUpBackVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONGUP_BACK,tenantId);
            if(billCode.isSuccess()) {
                bondUpBackVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BondUpBackEntity entity = BeanMapper.map(bondUpBackVO, BondUpBackEntity.class);
        if(null!=bondUpBackVO.getId()&&bondUpBackVO.getId()>0){
            //编辑
            LambdaQueryWrapper<BondUpBackEntity> lambda = Wrappers.<BondUpBackEntity>lambdaQuery();
            lambda.eq(BondUpBackEntity::getBillCode, bondUpBackVO.getBillCode());
            lambda.eq(BondUpBackEntity::getTenantId, tenantId);
            lambda.ne(BondUpBackEntity::getId, bondUpBackVO.getId());
            entities = super.list(lambda);
        }else{
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<BondUpBackEntity> lambda = Wrappers.<BondUpBackEntity>lambdaQuery();
            lambda.eq(BondUpBackEntity::getTenantId, tenantId);
            lambda.eq(BondUpBackEntity::getBillCode, bondUpBackVO.getBillCode());
            entities = super.list(lambda);
        }
        if(entities != null && entities.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBackTime(new Date());
        super.saveOrUpdate(entity,false);
        //回写申请单
        BondUpEntity upentity= bondUpService.selectById(bondUpBackVO.getBondId());
        BigDecimal sumBackMny = upentity.getBackMny()==null?BigDecimal.ZERO:upentity.getBackMny();
        BigDecimal applyMny = upentity.getApplyMny()==null?BigDecimal.ZERO:upentity.getApplyMny();
        if(applyMny.compareTo(sumBackMny.add(entity.getBackMny()))<0){
            throw new BusinessException("本次退还金额不能超过剩余金额!");
        }
        LambdaUpdateWrapper<BondUpEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BondUpEntity::getId,entity.getBondId());
        updateWrapper.set(BondUpEntity::getBackMny,sumBackMny.add(entity.getBackMny()));
        bondUpService.update(updateWrapper);
        return BeanMapper.map(entity, BondUpBackVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = bondUpService.selectById(id);
        LambdaQueryWrapper<BondUpBackEntity> lambda = Wrappers.<BondUpBackEntity>lambdaQuery();
        lambda.eq(BondUpBackEntity::getBondId, id);
        lambda.orderBy(true,false,BondUpBackEntity::getBackTime);
        List<BondUpBackEntity> list = super.list(lambda);
        vo.setId(id);
        vo.setBondStatus(upEntity.getBondStatus());
        vo.setContractId(upEntity.getContractId());
        vo.setContractName(upEntity.getContractName());
        vo.setApplyMny(upEntity.getApplyMny()==null?BigDecimal.ZERO:upEntity.getApplyMny());
        vo.setContractTaxMny(upEntity.getContractTaxMny()==null?BigDecimal.ZERO:upEntity.getContractTaxMny());
        vo.setBackMny(upEntity.getBackMny()==null?BigDecimal.ZERO:upEntity.getBackMny());
        vo.setSurplusMny(vo.getApplyMny().subtract(vo.getBackMny()));
        if(CollectionUtils.isNotEmpty(list)){
            vo.setBackRecord(BeanMapper.mapList(list,BondUpBackVO.class));
        }
        return vo;
    }
}
