/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.finance.bean.LoadBackEntity;
import com.ejianc.business.finance.mapper.LoadBackMapper;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadBackService;
import com.ejianc.business.finance.vo.LoadBackVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoadBackServiceImpl
extends BaseServiceImpl<LoadBackMapper, LoadBackEntity>
implements ILoadBackService {
    private static final String BONDUP_BILL_CODE = "LOAD_BACK";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILoadApplyService loadApplyService;

    @Override
    public LoadBackVO insertOrUpdate(LoadBackVO loadBackVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (null != loadBackVO && StringUtils.isEmpty((CharSequence)loadBackVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                loadBackVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LoadBackEntity entity = (LoadBackEntity)((Object)BeanMapper.map((Object)loadBackVO, LoadBackEntity.class));
        BigDecimal surplusMny = this.loadApplyService.querySurplusMny(null, entity.getId(), entity.getOrgId(), 0, String.valueOf(loadBackVO.getApplyEmployeeId()));
        BigDecimal backMny = entity.getBackMny();
        if (backMny.compareTo(surplusMny) > 0) {
            DecimalFormat df1 = new DecimalFormat("###,###.##");
            throw new BusinessException("\u672c\u6b21\u9000\u8fd8\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5269\u4f59\u53ef\u9000\u8fd8\u91d1\u989d\u3010" + df1.format(surplusMny) + "\u3011\u5143");
        }
        entity.setSurplusMny(surplusMny);
        super.saveOrUpdate((Object)entity, false);
        return (LoadBackVO)BeanMapper.map((Object)((Object)entity), LoadBackVO.class);
    }
}

