package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.BidBondEntity;
import com.ejianc.business.finance.bean.BondDownDealEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.service.IBidBondService;
import com.ejianc.business.finance.vo.BidBondDealVO;
import com.ejianc.business.finance.vo.BondDownDealVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.BidBondDealMapper;
import com.ejianc.business.finance.bean.BidBondDealEntity;
import com.ejianc.business.finance.service.IBidBondDealService;

import java.util.Date;
import java.util.List;

/**
 * 投标保证金申请子表
 * 
 * @author generator
 * 
 */
@Service("bidBondDealService")
public class BidBondDealServiceImpl extends BaseServiceImpl<BidBondDealMapper, BidBondDealEntity> implements IBidBondDealService{

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BIDBOND_DEL";//此处需要根据实际修改

    @Autowired
    private IBidBondDealService service;

    @Autowired
    private IBidBondService bidBondService;

    @Override
    public BidBondDealVO insertOrUpdate(BidBondDealVO saveOrUpdateVO) {
        BidBondDealEntity entity = BeanMapper.map(saveOrUpdateVO, BidBondDealEntity.class);
        if(StringUtils.isEmpty(saveOrUpdateVO.getBillCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<BidBondDealEntity> entities = null;
        if(null!=saveOrUpdateVO.getId()&&saveOrUpdateVO.getId()>0){
            //编辑
            LambdaQueryWrapper<BidBondDealEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(BidBondDealEntity::getBillCode, saveOrUpdateVO.getBillCode());
            lambda.eq(BidBondDealEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambda.ne(BidBondDealEntity::getId, saveOrUpdateVO.getId());
            entities = super.list(lambda);
            //需要将本次数据新增，将之前数据改为作废
            LambdaUpdateWrapper<BidBondDealEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(BidBondDealEntity::getDealStatus,"2");
            super.update(updateWrapper);
            entity.setId(null);
        }else{
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<BidBondDealEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(BidBondDealEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambda.eq(BidBondDealEntity::getBillCode, saveOrUpdateVO.getBillCode());
            entities = super.list(lambda);
        }
        if(entities != null && entities.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setDealStatus("1");
        entity.setDealTime(new Date());
        service.saveOrUpdate(entity,false);
        //回写申请单
        LambdaUpdateWrapper<BidBondEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BidBondEntity::getId,entity.getBondId());
        updateWrapper.set(BidBondEntity::getBondStatus,"1");
        updateWrapper.set(BidBondEntity::getBeginDate,entity.getBeginDate());
        updateWrapper.set(BidBondEntity::getEndDate,entity.getEndDate());
        updateWrapper.set(BidBondEntity::getEmployeeId,entity.getEmployeeId());
        updateWrapper.set(BidBondEntity::getEmployeeName,entity.getEmployeeName());
        updateWrapper.set(BidBondEntity::getPayMny,entity.getBondMny());
        updateWrapper.set(BidBondEntity::getDealTime,entity.getDealTime());
        bidBondService.update(updateWrapper);
        return BeanMapper.map(entity, BidBondDealVO.class);
    }
}
