package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.PayFocusDetailEntity;
import com.ejianc.business.finance.bean.PayFocusEntity;
import com.ejianc.business.finance.service.IPayFocusService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

@Service("payFocus")
public class PayFocusBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());


	@Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IBillCodeApi billCodeApi;
	private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT";
	@Autowired
	private SessionManager sessionManager;
    @Autowired
    private IPayFocusService payFocusService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if (billId != null) {
			logger.info("集中付款审批完成回调处理----------------：billId: {}, state: {}", billId, state);
			PayFocusEntity payFocusEntity = payFocusService.selectById(billId);

			List<PayFocusDetailEntity> detailList = payFocusEntity.getPayFocusDetailList();
			if (CollectionUtils.isNotEmpty(detailList)) {
				Map<Long, List<PayFocusDetailEntity>> collect = detailList.stream().collect(Collectors.groupingBy(o -> o.getProjectId()));
				Long tenantId = InvocationInfoProxy.getTenantid();
				CommonResponse<List<String>> billCode = billCodeApi.getCodeBatchByRuleCode(PAY_CONTRACT_BILL_CODE, tenantId, collect.size());
				List<String> billCodeList = new ArrayList<>();
				if (billCode.isSuccess()) {
					billCodeList = billCode.getData();
				} else {
					throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
				}
				logger.info("billcode----------------："+ JSONObject.toJSONString(billCode));
				ExecutorService threadPool = Executors.newFixedThreadPool(2);
				try {
					UserContext userContext = sessionManager.getUserContext();
					PayFocusCallable payFocusCallable = new PayFocusCallable(payFocusService, payFocusEntity, billCodeList, userContext.getUserCode());
					threadPool.submit(payFocusCallable);
				} catch (Exception e) {
					logger.error("集中付款推送付款申请数据异常", e);
					throw new BusinessException("集中付款推送付款申请数据异常！");
				} finally {
					threadPool.shutdown();
				}
			}
		}
		return CommonResponse.success();
	}

	class PayFocusCallable implements Callable<PayFocusEntity> {

		private RequestAttributes context = RequestContextHolder.getRequestAttributes();
		private IPayFocusService payFocusService;
		private PayFocusEntity payFocusEntity;
		private List<String> billCodeList;
		private String userCode;

		public PayFocusCallable(IPayFocusService payFocusService, PayFocusEntity payFocusEntity, List<String> billCodeList, String userCode) {
			this.payFocusService = payFocusService;
			this.payFocusEntity = payFocusEntity;
			this.billCodeList = billCodeList;
			this.userCode = userCode;
		}

		@Override
		public PayFocusEntity call() {
			logger.info("线程开始----------------");
			RequestContextHolder.setRequestAttributes(context);
			//推送合同付款申请单
			payFocusService.pushPayContract(payFocusEntity, billCodeList, userCode);
			logger.info("线程结束----------------");
			return payFocusEntity;
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//return CommonResponse.success();
		return CommonResponse.success("该单据无法弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
