package com.ejianc.business.finance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.enums.ReceiveTypeEnum;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.vo.ReceiveQuteDetailVO;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.finance.vo.SumReceiveVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/receive/")
public class ReceiveManageApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private IPayReimburseService payReimburseService;
    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    IReceiveService iReceiveService;
    @Autowired
    private IReceiveQuteDetailService receiveQuteDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;


    @GetMapping("queryList")
    public CommonResponse<List<ReceiveVO>> queryList(@RequestParam(value = "projectId", required = true) Long projectId) {
        try {
            QueryParam param = new QueryParam();
            /** 租户隔离 */
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            //收入类型 合同收款
            param.getParams().put("receiveType", new Parameter(QueryParam.EQ, 1275321308270993409L));
            //已生效状态的单据
            param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
            orderMap.put("createTime", "desc");
            param.setOrderMap(orderMap);

            List<ReceiveEntity> receiveEntities = receiveService.queryList(param);
            return CommonResponse.success(BeanMapper.mapList(receiveEntities, ReceiveVO.class));
        } catch (Exception e) {
            logger.error("系统异常：" + e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error("查询失败");
    }

    @GetMapping("getSumReceiveVOList")
    public CommonResponse<SumReceiveVO> getSumReceiveVOList(@RequestParam(value = "contractId", required = true) Long contractId) {
        try {
            SumReceiveVO vo = receiveService.getSumReceiveVOList(contractId);
            return CommonResponse.success(vo);
        } catch (Exception e) {
            logger.error("系统异常：" + e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error("查询失败");
    }


    /**
     * 统计已生效的有合同收款登记金额（含税）: 金额单位-万元
     *
     * @param param tenantId 租户I
     *              projectIds 项目Id列表
     * @return
     */
    @PostMapping(value = "countByProperties")
    public CommonResponse<BigDecimal> countByProperties(@RequestBody Map<String, Object> param) {
        Map<String, Object> result = receiveService.countRecAmt(Long.valueOf(param.get("tenantId").toString()),
                null != param.get("projectIds") ? (List<Long>) param.get("projectIds") : null,null != param.get("orgIds") ? (List<Long>) param.get("orgIds") : null, true);
        return CommonResponse.success(new BigDecimal(result.get("amt").toString()));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/9/23 移动端 ---年度经营指标---累计收款 累计支出 查询
     * @Description contractDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.income.vo.ContractVo>
     */
    @PostMapping(value = "getAnnuallyCountData")
    public CommonResponse<JSONObject> getAnnuallyCountData(@RequestBody List<Long> projectIds) {
        QueryParam queryParam = new QueryParam();
        Calendar calendar = Calendar.getInstance();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));//租户隔离
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));//单据状态已提交和审批通过
        if (ListUtil.isNotEmpty(projectIds)) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        }
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        if(ListUtil.isNotEmpty(orgIds)){
            queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));
        }
        /** 收款 */
        queryParam.getParams().put("confirmTime", new Parameter(QueryParam.BETWEEN, calendar.get(Calendar.YEAR) + "-01-01," + calendar.get(Calendar.YEAR) + "-12-31"));//
        List<ReceiveEntity> receiveEntities = receiveService.queryList(queryParam, false);
        /** 付款申请 */
        queryParam.getParams().put("dependOnProject", new Parameter(QueryParam.EQ, "1"));//属于项目
        queryParam.getParams().put("payStatus", new Parameter(QueryParam.EQ, "2"));//支付状态：2-已支付
        List<PayContractEntity> contractEntities = contractService.queryList(queryParam, false);
        /** 零星材料付款申请 */
        List<PaySporadicEntity> paySporadicEntities = paySporadicService.queryList(queryParam, false);
        /** 报销 */
        List<PayReimburseEntity> reimburseEntities = payReimburseService.queryList(queryParam, false);
        /** 借款报销 */
        queryParam.getParams().remove("confirmTime");
        queryParam.getParams().remove("payStatus");
        queryParam.getParams().put("applyTime", new Parameter(QueryParam.BETWEEN, calendar.get(Calendar.YEAR) + "-01-01," + calendar.get(Calendar.YEAR) + "-12-31"));//
        List<LoadReimburseEntity> loadReimburseEntities = loadReimburseService.queryList(queryParam, false);

        BigDecimal totalReceive = new BigDecimal("0.00");
        BigDecimal totalOut = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty(receiveEntities)) {
            for (ReceiveEntity entity : receiveEntities) {
                if (entity.getReceiveMny() != null) {
                    totalReceive = totalReceive.add(entity.getReceiveMny());
                }
            }
        }
        if (ListUtil.isNotEmpty(contractEntities)) {
            for (PayContractEntity entity : contractEntities) {
                if (entity.getPayMny() != null) {
                    totalOut = totalOut.add(entity.getPayMny());
                }
            }
        }
        if (ListUtil.isNotEmpty(paySporadicEntities)) {
            for (PaySporadicEntity entity : paySporadicEntities) {
                if (entity.getPayMny() != null) {
                    totalOut = totalOut.add(entity.getPayMny());
                }
            }
        }
        if (ListUtil.isNotEmpty(reimburseEntities)) {
            for (PayReimburseEntity entity : reimburseEntities) {
                if (entity.getPayMny() != null) {
                    totalOut = totalOut.add(entity.getPayMny());
                }
            }
        }
        if (ListUtil.isNotEmpty(loadReimburseEntities)) {
            for (LoadReimburseEntity entity : loadReimburseEntities) {
                if (entity.getReimburseMny() != null) {
                    totalOut = totalOut.add(entity.getReimburseMny());
                }
            }
        }
        JSONObject back = new JSONObject();
        back.put("totalReceive", totalReceive);
        back.put("totalOut", totalOut);
        return CommonResponse.success(back);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/9/24 移动端 ---月度度经营指标---累计收款 累计支出 查询
     * @Description getEachMonthCountData
     * @Param [projectIds]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @GetMapping(value = "getEachMonthCountData")
    public CommonResponse<List<List<String>>> getEachMonthCountData(@RequestParam Integer type) {
        List<Long> projectIds = new ArrayList<>();
        if (type != 1) {
            CommonResponse<List<Long>> response = projectApi.getProjectIdsByProperties(type);
            if (response.isSuccess()) {
                if (ListUtil.isNotEmpty(response.getData())) {
                    projectIds = response.getData();
                } else {
                    Map<String, JSONObject> last12Month = getLast12Month();
                    List<List<String>> data = new ArrayList<>();
                    for (Map.Entry<String, JSONObject> entry : last12Month.entrySet()) {
                        JSONObject v = entry.getValue();
                        List<String> item = new ArrayList<>();
                        item.add(v.getString("name"));
                        item.add("0.00");
                        item.add("0.00");
                        data.add(item);
                    }
                    return CommonResponse.success(data);
                }
            }
        }
        Map<String, JSONObject> last12Month = getLast12Month();
        List<Long> finalProjectIds = projectIds;
        List<List<String>> data = new ArrayList<>();
        for (Map.Entry<String, JSONObject> entry : last12Month.entrySet()) {
            String key = entry.getKey();
            JSONObject v = entry.getValue();
            List<BigDecimal> value = eachMonthData(key, finalProjectIds);
            v.put("value", value);
            List<String> item = new ArrayList<>();
            item.add(v.getString("name"));
            item.add(value.get(0).toString());
            item.add(value.get(1).toString());
            data.add(item);
        }
        return CommonResponse.success(data);
    }

    private List<BigDecimal> eachMonthData(String mon, List<Long> projectIds) {
        List<BigDecimal> data = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        Calendar calendar = Calendar.getInstance();
        /**
         * 添加移动
         */
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));//租户隔离
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));//单据状态已提交和审批通过
        if (ListUtil.isNotEmpty(projectIds)) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        }
        /** 收款 */
        queryParam.getParams().put("confirmTime", new Parameter(QueryParam.BETWEEN, mon + "-01-01," + mon + "-31"));//
        List<ReceiveEntity> receiveEntities = receiveService.queryList(queryParam, false);
        /** 付款申请 */
        queryParam.getParams().put("dependOnProject", new Parameter(QueryParam.EQ, "1"));//属于项目
        queryParam.getParams().put("payStatus", new Parameter(QueryParam.EQ, "2"));//支付状态：2-已支付
        List<PayContractEntity> contractEntities = contractService.queryList(queryParam, false);
        /** 零星材料付款申请 */
        List<PaySporadicEntity> paySporadicEntities = paySporadicService.queryList(queryParam, false);
        /** 报销 */
        List<PayReimburseEntity> reimburseEntities = payReimburseService.queryList(queryParam, false);
        /** 借款报销 */
        queryParam.getParams().remove("confirmTime");
        queryParam.getParams().remove("payStatus");
        queryParam.getParams().put("applyTime", new Parameter(QueryParam.BETWEEN, mon + "-01-01," + mon + "-31"));//
        List<LoadReimburseEntity> loadReimburseEntities = loadReimburseService.queryList(queryParam, false);

        BigDecimal totalReceive = new BigDecimal("0.00");
        BigDecimal totalOut = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty(receiveEntities)) {
            for (ReceiveEntity entity : receiveEntities) {
                if (entity.getReceiveMny() != null) {
                    totalReceive = totalReceive.add(entity.getReceiveMny());
                }
            }
        }
        if (ListUtil.isNotEmpty(contractEntities)) {
            for (PayContractEntity entity : contractEntities) {
                if (entity.getPayMny() != null) {
                    totalOut = totalOut.add(entity.getPayMny());
                }
            }
        }
        if (ListUtil.isNotEmpty(paySporadicEntities)) {
            for (PaySporadicEntity entity : paySporadicEntities) {
                if (entity.getPayMny() != null) {
                    totalOut = totalOut.add(entity.getPayMny());
                }
            }
        }
        if (ListUtil.isNotEmpty(reimburseEntities)) {
            for (PayReimburseEntity entity : reimburseEntities) {
                if (entity.getPayMny() != null) {
                    totalOut = totalOut.add(entity.getPayMny());
                }
            }
        }
        if (ListUtil.isNotEmpty(loadReimburseEntities)) {
            for (LoadReimburseEntity entity : loadReimburseEntities) {
                if (entity.getReimburseMny() != null) {
                    totalOut = totalOut.add(entity.getReimburseMny());
                }
            }
        }
        totalReceive = totalReceive.divide(new BigDecimal("10000")).setScale(2, BigDecimal.ROUND_HALF_UP);
        totalOut = totalOut.divide(new BigDecimal("10000")).setScale(2, BigDecimal.ROUND_HALF_UP);
        data.add(totalReceive);
        data.add(totalOut);
        return data;
    }

    private static Map<String, JSONObject> getLast12Month() {
        Map<String, JSONObject> mon = new LinkedHashMap<>();
        Calendar cal = Calendar.getInstance();
        //如果当前日期大于二月份的天数28天或者29天会导致计算月份错误，会多出一个三月份，故设置一个靠前日期解决此问题
        cal.set(Calendar.DAY_OF_MONTH, 1);
        for (int i = 0; i < 12; i++) {
            JSONObject jsonObject = new JSONObject();
            String key = cal.get(Calendar.YEAR) + "-";
            String name = cal.get(Calendar.YEAR) + "年";
            if ((cal.get(Calendar.MONTH) + 1) < 10) {
                key = key + "0" + (cal.get(Calendar.MONTH) + 1);
            } else {
                key = key + (cal.get(Calendar.MONTH) + 1);
            }
            if (cal.get(Calendar.MONTH) == 0) {
                name = name + (cal.get(Calendar.MONTH) + 1) + "月";
            } else {
                name = (cal.get(Calendar.MONTH) + 1) + "月";
            }
            jsonObject.put("name", name);
            jsonObject.put("sec", 12 - i);
            System.out.println(key);
            System.out.println(jsonObject);
            mon.put(key, jsonObject);
            cal.set(Calendar.MONTH, cal.get(Calendar.MONTH) - 1); //逐次往前推1个月
        }
        mon = mon.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue,
                (oleValue, newValue) -> oleValue, LinkedHashMap::new));
        return mon;
    }

    public static void main(String[] args) {
        Map<String, JSONObject> last12Month = getLast12Month();
        List<String> item = new ArrayList<>();
        last12Month.forEach((key, v) -> {
            v.put("value", v);
            item.add(v.getString("name"));
            System.out.println(v);
        });
        item.forEach(System.out::println);
    }

    @GetMapping("queryProjectReceiveMny")
    public CommonResponse<List<ReceiveVO>> queryProjectReceiveMny(@RequestParam(value = "projectIds") List<Long> projectIds) {
        List<ReceiveVO> receiveVOS = iReceiveService.queryProjectReceiveMny(projectIds);
        return CommonResponse.success("查询列表数据成功！", receiveVOS);
    }

    /**
     * 根据甲方报量id，查询收款登记信息
     * @param quoteId
     * @return
     */
    @GetMapping({"/queryInfoQuoteId"})
    CommonResponse<List<ReceiveVO>> queryInfoQuoteId(@RequestParam("quoteId") Long quoteId,@RequestParam("contractId") Long contractId) {
        List<ReceiveVO> receiveVOS = receiveService.queryInfoQuoteId(quoteId,contractId);
        receiveVOS.forEach(vo->{
            vo.setReceiveTypeName(ReceiveTypeEnum.getNameByCode(vo.getReceiveType()));
        });
        return CommonResponse.success("查询收款登记信息！", receiveVOS);
    }
}
