package com.ejianc.business.finance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.bean.ReceiveInvoiceEntity;
import com.ejianc.business.finance.bean.ReceiveQuteDetailEntity;
import com.ejianc.business.finance.service.IReceiveInvoiceService;
import com.ejianc.business.finance.service.IReceiveQuteDetailService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.ReceiveInvoiceVO;
import com.ejianc.business.finance.vo.ReceiveQuteDetailVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.QuoteVo;
import com.ejianc.business.prjfinance.api.IPrjRiskMarginApi;
import com.ejianc.business.prjfinance.vo.RiskMarginTransVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

@Service("receive")
public class ReceiveBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IIncomeContractApi incomApi;

    @Autowired
    private IReceiveService receiveService;


    @Autowired
    private IPrjRiskMarginApi prjRiskMarginApi;

    @Autowired
    private IReceiveInvoiceService invoiceService;
    @Autowired
    private IIncomeContractApi iIncomeContractApi;
    @Autowired
    private IReceiveQuteDetailService receiveQuteDetailService;
    @Autowired
    private IInvoiceApi invoiceApi;
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = receiveService.selectById(billId);
        logger.info("审批通过后回写--- entity:" + entity);
        if (entity.getContractId() != null) {
            incomApi.updateCollectMny(entity.getContractId(), entity.getReceiveMny(), true);
//            QueryParam param = new QueryParam();
//            param.getParams().put("receiveId", new Parameter(QueryParam.EQ, billId));
//            List<ReceiveInvoiceEntity> invoiceEntityList = invoiceService.queryList(param, false);
//            /**累计无税金额（元） invoiceMny**/
//            BigDecimal sumInvoiceMny = invoiceEntityList.stream().filter(s -> s.getInvoiceMny() != null).map(ReceiveInvoiceEntity::getInvoiceMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//            /**累计有税金额（元） invoiceMny**/
//            BigDecimal sumInvoiceTaxMny = invoiceEntityList.stream().filter(s -> s.getInvoiceTaxMny() != null).map(ReceiveInvoiceEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//            incomApi.updateInvoicingMny(entity.getContractId(),sumInvoiceTaxMny,sumInvoiceMny,true);
        }
        if (entity.getReceiveType() != null && String.valueOf(entity.getReceiveType()).equals("1275321308270993409")) {
            //收入为工程合同收入的需要推送
            //当收款登记生效且收款项目下存在生效的项目目标责任书且风险保证金收取方式为：
            //按已收款比例时，自动在风险保证金里面生成一条扣风险保证金记录；
            RiskMarginTransVO vo = this.getRiskMarginTransVO(entity);
            CommonResponse<Object> res = prjRiskMarginApi.generateByRecRecord(vo);
            Object data = res.getData();
            JSONObject json = (JSONObject) JSONObject.toJSON(data);
            if (res.isSuccess()) {
                logger.info("收款登记自动生成风险保证金(扣)返回信息：" + json.getString("msg"));
            } else {
                logger.error("收款登记自动生成风险保证金(扣)失败：" + json.getString("msg"));
            }
        }
        //提交子表的状态设置为1 提交
        List<ReceiveQuteDetailEntity> receiveQuteDetailList = entity.getReceiveQuteDetailList();
        List<QuoteVo> list = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(receiveQuteDetailList)){
            List<ReceiveQuteDetailVO> vos = BeanMapper.mapList(receiveQuteDetailList, ReceiveQuteDetailVO.class);
            List<ReceiveQuteDetailVO> receiveQuteDetailVOS = receiveService.getLastReceiveTaxMny(vos);

            receiveQuteDetailVOS.forEach(item->{
                QuoteVo quoteVo = new QuoteVo();
                quoteVo.setId(item.getQuoteId());
                quoteVo.setContractId(item.getContractId());
                quoteVo.setTotalReceiveTaxMny(item.getTotalReceiveTaxMny());
                quoteVo.setTotalContractReceiveTaxMny(item.getTotalContractReceiveTaxMny());
                list.add(quoteVo);
            });
        }
        if (CollectionUtil.isNotEmpty(list)){
            CommonResponse<String> commonResponse = iIncomeContractApi.updateReceiveTaxMny(list);
            logger.error("回写写甲方报量：" + commonResponse.isSuccess());
        }
        return CommonResponse.success("回调处理成功！");
    }

    private RiskMarginTransVO getRiskMarginTransVO(ReceiveEntity entity) {
        RiskMarginTransVO riskMarginTransVO = new RiskMarginTransVO();
        riskMarginTransVO.setOperatorId(entity.getEmployeeId());
        riskMarginTransVO.setOperatorName(entity.getEmployeeName());
        riskMarginTransVO.setOrgId(entity.getOrgId());
        riskMarginTransVO.setOrgName(entity.getOrgName());
        riskMarginTransVO.setProjectId(entity.getProjectId());
        riskMarginTransVO.setProjectName(entity.getProjectName());
        riskMarginTransVO.setApplyAmt(entity.getReceiveMny());
        riskMarginTransVO.setApplyDate(entity.getConfirmTime());
        riskMarginTransVO.setSourceId(entity.getId());
        return riskMarginTransVO;
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = receiveService.selectById(billId);
        // 校验创建时间
        if (!validateCreateTime(entity)) return CommonResponse.error("该合同已存在后续单据,不能弃审!");
        // 校验存在未生效单据
        if (!validateEffective(entity)) return CommonResponse.error("该支出单据数据已被引用，不可进行撤回操作!");
        return CommonResponse.success("校验通过");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiveEntity entity = receiveService.selectById(billId);
        logger.info("弃审后回写--- entity:" + entity);
        if (entity.getContractId() != null) {
            incomApi.updateCollectMny(entity.getContractId(), entity.getReceiveMny(), false);
//            QueryParam param = new QueryParam();
//            param.getParams().put("receiveId", new Parameter(QueryParam.EQ, billId));
//            List<ReceiveInvoiceEntity> invoiceEntityList = invoiceService.queryList(param, false);
//            /**累计无税金额（元） invoiceMny**/
//            BigDecimal sumInvoiceMny = invoiceEntityList.stream().filter(s -> s.getInvoiceMny() != null).map(ReceiveInvoiceEntity::getInvoiceMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//            /**累计有税金额（元） invoiceMny**/
//            BigDecimal sumInvoiceTaxMny = invoiceEntityList.stream().filter(s -> s.getInvoiceTaxMny() != null).map(ReceiveInvoiceEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//            incomApi.updateInvoicingMny(entity.getContractId(),sumInvoiceTaxMny,sumInvoiceMny,false);
        }
        if (entity.getReceiveType() != null && String.valueOf(entity.getReceiveType()).equals("1275321308270993409")) {
            //收入为工程合同收入的需要推送
            //收款登记撤回时：需删除自动生成的风险保证金
            CommonResponse<JSONObject> res = prjRiskMarginApi.delBySourceIds(Collections.singletonList(billId));
            if (res.isSuccess()) {
                logger.info("收款登记弃审自动删除生成的风险保证金(扣)成功！");
            } else {
                logger.error("收款登记弃审自动删除生成的风险保证金(扣)失败！");
            }
        }
        List<ReceiveQuteDetailEntity> receiveQuteDetailList = entity.getReceiveQuteDetailList();
        List<QuoteVo> list = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(receiveQuteDetailList)){
            List<ReceiveQuteDetailVO> vos = BeanMapper.mapList(receiveQuteDetailList, ReceiveQuteDetailVO.class);
            List<ReceiveQuteDetailVO> receiveQuteDetailVOS = receiveService.getLastReceiveTaxMny(vos);

            receiveQuteDetailVOS.forEach(item->{
                QuoteVo quoteVo = new QuoteVo();
                quoteVo.setId(item.getQuoteId());
                quoteVo.setContractId(item.getContractId());
                quoteVo.setTotalReceiveTaxMny(item.getTotalReceiveTaxMny());
                quoteVo.setTotalContractReceiveTaxMny(item.getTotalContractReceiveTaxMny());
                list.add(quoteVo);
            });
        }
        if (CollectionUtil.isNotEmpty(list)){
            CommonResponse<String> commonResponse = iIncomeContractApi.updateReceiveTaxMny(list);
            logger.error("回写写甲方报量：" + commonResponse.isSuccess());
        }
        return CommonResponse.success("回调处理成功！");
    }

    /**
     * 校验存在未生效单据
     *
     * @param entity
     * @return
     */
    private boolean validateEffective(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper<ReceiveEntity>();
        wrapper.eq("contract_id", contractId);
        wrapper.eq("org_id", entity.getOrgId());
        wrapper.ne("bill_state", 1);
        wrapper.ne("bill_state", 3);
        List<ReceiveEntity> list = receiveService.list(wrapper);
        if (!list.isEmpty()) {
            return false;
        }
        return true;
    }

    /**
     * 校验创建时间
     *
     * @param entity
     * @return
     */
    private boolean validateCreateTime(ReceiveEntity entity) {
        Long contractId = entity.getContractId();
        Date createTime = entity.getCreateTime();
        QueryWrapper wrapper = new QueryWrapper<ReceiveEntity>();
        wrapper.eq("contract_id", contractId);
        wrapper.eq("org_id", entity.getOrgId());
        wrapper.gt("create_time", createTime);
        List<ReceiveEntity> list = receiveService.list(wrapper);
        if (!list.isEmpty()) {
            return false;
        }
        return true;
    }
}
