package com.ejianc.business.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.finance.bean.PayFocusDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 集中付款申请实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_pay_focus")
public class PayFocusEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_type")
    private Long contractType; // 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-周转材租赁,6-其他支出合同
    @TableField(value="contract_type_name")
    private String contractTypeName; // 合同类型名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="pay_reason")
    private String payReason; // 付款事由
    @TableField(value="pay_unit_id")
    private Long payUnitId; // 付款单位
    @TableField(value="pay_unit_name")
    private String payUnitName; // 付款单位名称
    @TableField(value="receive_unit_id")
    private Long receiveUnitId; // 收款单位
    @TableField(value="receive_unit_name")
    private String receiveUnitName; // 收款单位名称
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="apply_user_id")
    private Long applyUserId; // 申请人
    @TableField(value="apply_user_name")
    private String applyUserName; // 申请人名称
    @TableField(value="apply_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime; // 申请时间
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 申请金额
    @TableField(value="apply_mny_cn")
    private String applyMnyCn; // 申请金额大写
    @TableField(value="sum_surplus_apply_mny")
    private BigDecimal sumSurplusApplyMny; // 剩余申请金额
    @TableField(value="account_name")
    private String accountName; // 账户名称
    @TableField(value="account_num")
    private String accountNum; // 银行账号
    @TableField(value="account_bank")
    private String accountBank; // 开户行
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="payFocusDetailService",pidName ="focusId")//此处有pid="xxx"，默认值pid="pid"
    private List<PayFocusDetailEntity> payFocusDetailList = new ArrayList<>(); // 集中付款申请明细实体
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }
    public Long getPayUnitId() {
        return payUnitId;
    }

    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }
    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }
    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }
    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }
    public BigDecimal getSumSurplusApplyMny() {
        return sumSurplusApplyMny;
    }

    public void setSumSurplusApplyMny(BigDecimal sumSurplusApplyMny) {
        this.sumSurplusApplyMny = sumSurplusApplyMny;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }
    
    public List<PayFocusDetailEntity> getPayFocusDetailList() {
        return payFocusDetailList;
    }

    public void setPayFocusDetailList(List<PayFocusDetailEntity> payFocusDetailList) {
        this.payFocusDetailList = payFocusDetailList;
    }
}
