/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.bean.ReceiveInvoiceEntity;
import com.ejianc.business.finance.enums.ReceiveTypeEnum;
import com.ejianc.business.finance.mapper.ReceiveMapper;
import com.ejianc.business.finance.service.IReceiveInvoiceService;
import com.ejianc.business.finance.service.IReceiveQuteDetailService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.BigDecimalUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.vo.ReceiveInvoiceVO;
import com.ejianc.business.finance.vo.ReceiveQuteDetailVO;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.finance.vo.SumReceiveVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReceiveServiceImpl
extends BaseServiceImpl<ReceiveMapper, ReceiveEntity>
implements IReceiveService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RECEIVE_BILL_CODE = "FINANCE_RECEIVE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IReceiveInvoiceService invoiceService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IReceiveQuteDetailService receiveQuteDetailService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private FeignUtil feignUtil;
    @Autowired
    private IInvoiceApi invoiceApi;

    @Override
    public ReceiveVO insertOrUpdate(ReceiveVO vo) {
        ReceiveEntity entity = (ReceiveEntity)((Object)BeanMapper.map((Object)vo, ReceiveEntity.class));
        this.validateBeforeSave(entity);
        if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(vo.getContractId()), (String)BillTypeCodeEnum.\u65bd\u5de5\u5408\u540c.getBillTypeCode(), (Integer)vo.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        this.autoSetBillCode(entity);
        super.saveOrUpdate((Object)entity, false);
        List<ReceiveInvoiceVO> invoiceVOList = this.updateInvoiceVOS(vo, entity.getId());
        ReceiveVO backVO = (ReceiveVO)BeanMapper.map((Object)super.getById((Serializable)entity.getId()), ReceiveVO.class);
        backVO.setInvoiceVOList(invoiceVOList);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("receiveId", new Parameter("eq", (Object)entity.getId()));
        List list = this.receiveQuteDetailService.queryList(queryParam, false);
        List vos = BeanMapper.mapList((Iterable)list, ReceiveQuteDetailVO.class);
        backVO.setReceiveQuteDetailList(vos);
        return backVO;
    }

    private List<ReceiveInvoiceVO> updateInvoiceVOS(ReceiveVO receiveVO, Long id) {
        List voList = receiveVO.getInvoiceVOList();
        QueryParam param = new QueryParam();
        param.getParams().put("receiveId", new Parameter("eq", (Object)id));
        ArrayList oldInvoiceList = id != null ? this.invoiceService.queryList(param, false) : new ArrayList();
        HashMap invoiceEntityMap = CollectionUtils.isNotEmpty(oldInvoiceList) ? oldInvoiceList.stream().collect(Collectors.toMap(ReceiveInvoiceEntity::getInvoiceId, Function.identity())) : new HashMap();
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            for (ReceiveInvoiceVO invoiceVO : voList) {
                if (Boolean.FALSE.equals(ValidateUtil.validateUpstreamVersion((String)String.valueOf(invoiceVO.getInvoiceId()), (String)BillTypeCodeEnum.\u7a0e\u52a1\u5f00\u7968.getBillTypeCode(), (Integer)invoiceVO.getInvoiceVersion()))) {
                    throw new BusinessException("\u53d1\u7968\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                }
                invoiceVO.setReceiveId(id);
            }
            if (CollectionUtils.isNotEmpty((Collection)voList)) {
                voList.forEach(t -> {
                    BigDecimal old = t.getInvoiceId() != null && !invoiceEntityMap.isEmpty() && invoiceEntityMap.containsKey(t.getInvoiceId()) ? ((ReceiveInvoiceEntity)((Object)((Object)invoiceEntityMap.get(t.getInvoiceId())))).getCurrentInvoiceTaxMny() : BigDecimal.ZERO;
                    map.put(t.getInvoiceId(), BigDecimalUtil.safeSub(t.getCurrentInvoiceTaxMny(), old));
                    invoiceEntityMap.remove(t.getInvoiceId());
                });
            }
            List entityList = BeanMapper.mapList((Iterable)voList, ReceiveInvoiceEntity.class);
            this.invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, ReceiveInvoiceVO.class);
        }
        if (!invoiceEntityMap.isEmpty()) {
            invoiceEntityMap.keySet().stream().map(invoiceEntityMap::get).forEach(receiveInvoiceEntity -> map.put(receiveInvoiceEntity.getInvoiceId(), BigDecimalUtil.convertToMinusNumber(receiveInvoiceEntity.getCurrentInvoiceTaxMny())));
        }
        if (!map.isEmpty()) {
            this.invoiceApi.updateUseInvoiceTaxMny(map);
        }
        List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"receive_id", (Object)id);
        wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        this.invoiceService.remove((Wrapper)wrapper, false);
        return voList;
    }

    @Override
    public ReceiveVO queryDetail(Long id) {
        ReceiveEntity entity = (ReceiveEntity)((Object)((ReceiveMapper)this.baseMapper).selectById(id));
        ReceiveVO vo = (ReceiveVO)BeanMapper.map((Object)((Object)entity), ReceiveVO.class);
        vo.setReceiveTypeName(ReceiveTypeEnum.getNameByCode(vo.getReceiveType()));
        QueryParam param = new QueryParam();
        param.getParams().put("receiveId", new Parameter("eq", (Object)vo.getId()));
        param.getOrderMap().put("createTime", "desc");
        List invoiceEntityList = this.invoiceService.queryList(param, false);
        vo.setInvoiceVOList(BeanMapper.mapList((Iterable)invoiceEntityList, ReceiveInvoiceVO.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("receiveId", new Parameter("eq", (Object)id));
        List list = this.receiveQuteDetailService.queryList(queryParam, false);
        List vos = BeanMapper.mapList((Iterable)list, ReceiveQuteDetailVO.class);
        vo.setReceiveQuteDetailList(vos);
        return vo;
    }

    @Override
    public List<ReceiveVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.queryPageJson(param, false).get((Object)"records");
        CommonResponse defResp = this.defdocApi.getDefDocByDefId(Long.valueOf(330086941239541801L));
        if (!defResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6863\u6848\u5217\u8868\u5931\u8d25\uff1a{}", (Object)defResp.getMsg());
        }
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                ReceiveVO vo = (ReceiveVO)resVos.get(i);
                vo.setReceiveTypeName(ReceiveTypeEnum.getNameByCode(vo.getReceiveType()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                DefdocDetailVO defdocDetailVO = ((List)defResp.getData()).stream().filter(defVo -> defVo.getId().equals(vo.getReceiveWay())).findFirst().get();
                vo.setReceiveWayName(defdocDetailVO.getName());
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"receive_id", ids);
            List list = this.invoiceService.list((Wrapper)queryWrapper);
            HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (ReceiveInvoiceEntity receiveInvoiceEntity : list) {
                    map.put(receiveInvoiceEntity.getInvoiceId(), BigDecimalUtil.convertToMinusNumber(receiveInvoiceEntity.getCurrentInvoiceTaxMny()));
                }
                this.invoiceApi.updateUseInvoiceTaxMny(map);
            }
            super.removeByIds(ids, false);
            this.invoiceService.remove((Wrapper)new QueryWrapper().in((Object)"receive_id", ids), false);
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("receiveUnitName");
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        IPage pageData = super.queryPage(param, false);
        JSONObject page = new JSONObject();
        List receiveVOS = BeanMapper.mapList((Iterable)pageData.getRecords(), ReceiveVO.class);
        CommonResponse defResp = this.defdocApi.getDefDocByDefId(Long.valueOf(330086941239541801L));
        if (!defResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6863\u6848\u5217\u8868\u5931\u8d25\uff1a{}", (Object)defResp.getMsg());
        }
        receiveVOS.forEach(item -> {
            DefdocDetailVO defdocDetailVO = ((List)defResp.getData()).stream().filter(defVo -> defVo.getId().equals(item.getReceiveWay())).findFirst().get();
            item.setReceiveWayName(defdocDetailVO.getName());
        });
        page.put("records", (Object)receiveVOS);
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return page;
    }

    @Override
    public SumReceiveVO getSumReceiveVOList(Long contractId, Long receiveType) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        if (receiveType != null) {
            param.getParams().put("receiveType", new Parameter("eq", (Object)receiveType));
        }
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("createTime", "desc");
        List entityList = super.queryList(param, false);
        BigDecimal sumReceiveMny = BigDecimal.ZERO;
        for (ReceiveEntity entity : entityList) {
            sumReceiveMny = MathUtil.safeAdd((BigDecimal)sumReceiveMny, (BigDecimal)entity.getReceiveMny());
        }
        SumReceiveVO vo = new SumReceiveVO();
        vo.setContractId(contractId);
        vo.setSumReceiveMny(sumReceiveMny);
        vo.setReceiveVOList(BeanMapper.mapList((Iterable)entityList, ReceiveVO.class));
        return vo;
    }

    @Override
    public Map<String, Object> countRecAmt(Long tenantId, List<Long> projectIds, List<Long> orgIds, boolean isWithContract) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        if (CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in((Object)"project_id", projectIds);
        } else {
            queryWrapper.isNotNull((Object)"project_id");
        }
        if (isWithContract) {
            queryWrapper.isNotNull((Object)"contract_id");
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        queryWrapper.select(new String[]{" round(ifnull(sum(receive_mny),0) / 10000, 2) as amt "});
        return super.getMap((Wrapper)queryWrapper);
    }

    @Override
    public List<ReceiveVO> queryProjectReceiveMny(List<Long> projectIds) {
        return ((ReceiveMapper)this.baseMapper).queryProjectReceiveMny(projectIds);
    }

    @Override
    public List<ReceiveVO> queryInfoQuoteId(Long quoteId, Long contractId) {
        return ((ReceiveMapper)this.baseMapper).queryInfoQuoteId(quoteId, contractId);
    }

    @Override
    public ReceiveVO queryInfoContractId(Long contractId) {
        return ((ReceiveMapper)this.baseMapper).queryInfoContractId(contractId);
    }

    @Override
    public List<ReceiveVO> queryTotalReceiveMny(List<Long> quoteIds) {
        return ((ReceiveMapper)this.baseMapper).queryTotalReceiveMny(quoteIds);
    }

    @Override
    public List<ReceiveQuteDetailVO> getLastReceiveTaxMny(List<ReceiveQuteDetailVO> vos) {
        List<Long> quoteIds = vos.stream().map(ReceiveQuteDetailVO::getQuoteId).collect(Collectors.toList());
        List<ReceiveVO> receiveVOS = this.receiveService.queryTotalReceiveMny(quoteIds);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(receiveVOS)) {
            map = receiveVOS.stream().collect(Collectors.groupingBy(ReceiveVO::getQuoteId));
        }
        for (ReceiveQuteDetailVO vo : vos) {
            ReceiveVO receive;
            BigDecimal totalReceiveTaxMny = BigDecimal.ZERO;
            BigDecimal totalContractReceiveMny = BigDecimal.ZERO;
            Long contractId = vo.getContractId();
            ReceiveVO receiveVO = this.receiveService.queryInfoContractId(contractId);
            if (receiveVO != null) {
                totalContractReceiveMny = receiveVO.getTotalContractReceiveMny();
            }
            if (map.containsKey(vo.getQuoteId()) && (receive = (ReceiveVO)((List)map.get(vo.getQuoteId())).get(0)) != null) {
                totalReceiveTaxMny = receive.getTotalReceiveTaxMny();
            }
            vo.setLastReceiveTaxMny(totalReceiveTaxMny);
            vo.setTotalReceiveTaxMny(totalReceiveTaxMny);
            vo.setLastContractReceiveTaxMny(totalContractReceiveMny);
            vo.setTotalContractReceiveTaxMny(totalContractReceiveMny);
        }
        return vos;
    }

    @Override
    public ReceiveVO queryInfoProjectId(Long projectId) {
        return ((ReceiveMapper)this.baseMapper).queryInfoProjectId(projectId);
    }

    private void validateBeforeSave(ReceiveEntity entity) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ReceiveEntity::getContractId, (Object)entity.getContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        lambda.notIn(ReceiveEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u4e0b\u5b58\u5728\u672a\u751f\u6548\u5355\u636e,\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
    }

    private void autoSetBillCode(ReceiveEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((String)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RECEIVE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ReceiveEntity::getBillCode, (Object)entity.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
    }
}

