/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.controller.api.PayContractApi;
import com.ejianc.business.finance.mapper.PayReimburseMapper;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.finance.vo.ParamsCheckDsSpreadVO;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.finance.vo.PayReimburseStatisticsVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.ProjectFinanceVO;
import com.ejianc.business.finance.vo.ProjectReimburseVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.business.income.consts.EJCDateUtil;
import com.ejianc.business.plan.api.IBudgetPlanApi;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayReimburseServiceImpl
extends BaseServiceImpl<PayReimburseMapper, PayReimburseEntity>
implements IPayReimburseService {
    private static final String REIM_PAYAPPLY_BILL_CODE = "REIM_PAYAPPLY";
    private static final String SYS_IS_PROBUDGET_CODE = "P-D76yn127";
    private static final String CHECK_PARAM_PROBUDGET_CODE = "P-V4416932";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private FeignUtil feignUtil;
    @Autowired
    private PayContractApi payContractApi;
    @Autowired
    private ISettlementApi iSettlementApi;
    @Autowired
    private IBudgetPlanApi iBudgetPlanApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPayContractService payContractService;

    @Override
    public PayReimburseVO insertOrUpdate(PayReimburseVO vo) {
        CommonResponse<String> usedMnyRes;
        PayReimburseEntity entity = (PayReimburseEntity)((Object)BeanMapper.map((Object)vo, PayReimburseEntity.class));
        this.autoSetBillCode(entity);
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        List voList = vo.getInvoiceVOList();
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            for (PayInvoiceVO invoiceVO : voList) {
                if (ValidateUtil.validateUpstreamVersion((String)String.valueOf(invoiceVO.getInvoiceId()), (String)BillTypeCodeEnum.\u7a0e\u52a1\u6536\u7968.getBillTypeCode(), (Integer)invoiceVO.getInvoiceVersion()).booleanValue()) continue;
                throw new BusinessException("\u53d1\u7968\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
            }
        }
        if (!(usedMnyRes = this.invoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId())).isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }
        super.saveOrUpdateNoES((Object)entity);
        Long id = entity.getId();
        List invoiceVOList = this.updateInvoiceVOS(vo, id);
        PayReimburseEntity byId = (PayReimburseEntity)((Object)super.getById((Serializable)id));
        PayReimburseVO backVO = (PayReimburseVO)BeanMapper.map((Object)((Object)byId), PayReimburseVO.class);
        if (entity.getId() != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"payapply_id", (Object)entity.getId());
            invoiceVOList = this.invoiceService.list((Wrapper)wrapper);
        }
        backVO.setInvoiceVOList(invoiceVOList);
        ProjectFinanceVO v = (ProjectFinanceVO)BeanMapper.map((Object)((Object)byId), ProjectFinanceVO.class);
        backVO.setProjectFinanceVO(v);
        return backVO;
    }

    private List<PayInvoiceVO> updateInvoiceVOS(PayReimburseVO vo, Long id) {
        List voList = vo.getInvoiceVOList();
        ArrayList<InvoiceReceiveFlagVO> flagVOS = new ArrayList<InvoiceReceiveFlagVO>();
        ArrayList<Long> receiveIds = new ArrayList<Long>();
        if (voList != null && !voList.isEmpty()) {
            for (PayInvoiceVO invoiceVO : voList) {
                InvoiceReceiveFlagVO flagVO = new InvoiceReceiveFlagVO();
                flagVO.setId(invoiceVO.getInvoiceId());
                flagVO.setFlag(Integer.valueOf(1));
                flagVOS.add(flagVO);
                receiveIds.add(invoiceVO.getInvoiceId());
                invoiceVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayInvoiceEntity.class);
            this.invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PayInvoiceVO.class);
        }
        List voIds = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List dataList = this.invoiceService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)id));
        List dataIds = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        dataIds.removeAll(voIds);
        List delIds = dataIds;
        if (!delIds.isEmpty()) {
            this.invoiceService.remove((Wrapper)new QueryWrapper().in((Object)"id", delIds), false);
        }
        return voList;
    }

    @Override
    public PayReimburseVO queryDetail(Long id) {
        PayReimburseEntity entity = (PayReimburseEntity)((Object)this.selectById(id));
        PayReimburseVO vo = (PayReimburseVO)BeanMapper.map((Object)((Object)entity), PayReimburseVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List invoiceEntityList = this.invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList((Iterable)invoiceEntityList, PayInvoiceVO.class));
        List recordList = this.payRecordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList((Iterable)recordList, PayRecordVO.class));
        vo.setProjectFinanceVO((ProjectFinanceVO)BeanMapper.map((Object)vo, ProjectFinanceVO.class));
        if (null != vo.getPayMny()) {
            vo.setPayMnyCn(NumberToCN.number2CN(vo.getPayMny()));
        }
        return vo;
    }

    @Override
    public List<PayReimburseVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.queryPageJson(param, false).get((Object)"records");
        Map<Long, String> defdocMap = this.feignUtil.getDefdocMap(324875125018329093L);
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                PayReimburseVO vo = (PayReimburseVO)resVos.get(i);
                vo.setFeeTypeName(defdocMap.get(vo.getFeeType()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setIsShareFlagName(vo.getIsShareFlag() != null && vo.getIsShareFlag() == 1 ? "\u662f" : "\u5426");
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        CommonResponse<String> res;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList) && (res = this.invoiceService.updateInvoiceUsedMnyByDel(ids)).isSuccess()) {
            super.removeByIds(ids, false);
            QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().in((Object)"payapply_id", ids);
            List invoiceList = this.invoiceService.list((Wrapper)wrapper);
            this.invoiceService.remove((Wrapper)wrapper, false);
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payReason");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContext = this.sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            this.logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", (Object)authOrgIds);
            if (StringUtils.isNotEmpty((String)authOrgIds)) {
                CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
                this.logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", (Object)authOrgIds, authResponse.getData() == null ? null : Integer.valueOf(((List)authResponse.getData()).size()));
                param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = PayReimburseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayReimburseVO> list = ((PayReimburseMapper)this.baseMapper).queryPageList(pages, wrapper, flag);
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"ifnull(sum(pay_mny),0) as amt"});
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"pay_type", (Object)2);
        queryWrapper.eq((Object)"pay_status", (Object)2);
        if (CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in((Object)"project_id", projectIds);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (ListUtil.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        return super.getMap((Wrapper)queryWrapper);
    }

    @Override
    public CommonResponse<PayReimburseVO> pushCost(PayReimburseVO payReimburseVO) {
        PayReimburseEntity payReimburseEntity = (PayReimburseEntity)((Object)((PayReimburseMapper)this.baseMapper).selectById(payReimburseVO.getId()));
        payReimburseEntity.setSubjectId(payReimburseVO.getSubjectId());
        payReimburseEntity.setSubjectName(payReimburseVO.getSubjectName());
        super.saveOrUpdate((Object)payReimburseEntity, false);
        this.costPush(payReimburseEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)payReimburseEntity), PayReimburseVO.class));
    }

    @Override
    public void costPush(PayReimburseEntity payReimburseEntity) {
        if (!"1".equals(payReimburseEntity.getDependOnProject())) {
            return;
        }
        Long subjectId = payReimburseEntity.getSubjectId();
        boolean newRelationFlag = true;
        if (null == subjectId) {
            newRelationFlag = false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{payReimburseEntity.getId()});
        updateWrapper.set(PayReimburseEntity::getRelationFlag, (Object)(newRelationFlag ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = payReimburseEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                this.saveCost(payReimburseEntity);
            }
            if (!newRelationFlag) {
                this.costDetailApi.deleteSubject(payReimburseEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0") && newRelationFlag) {
            this.saveCost(payReimburseEntity);
        }
    }

    private void saveCost(PayReimburseEntity payReimburseEntity) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(payReimburseEntity.getSubjectId());
        costDetailVO.setSourceId(payReimburseEntity.getId());
        costDetailVO.setSourceDetailId(payReimburseEntity.getId());
        costDetailVO.setHappenTaxMny(payReimburseEntity.getPayMny());
        costDetailVO.setHappenMny(payReimburseEntity.getPayMny());
        costDetailVO.setHappenDate(payReimburseEntity.getApplyTime());
        costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(REIM_PAYAPPLY_BILL_CODE);
        costDetailVO.setSourceTabType(REIM_PAYAPPLY_BILL_CODE);
        costDetailVO.setProjectId(payReimburseEntity.getProjectId());
        costDetailVOList.add(costDetailVO);
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            ((Object)costDetailVOList).toString();
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    private void autoSetBillCode(PayReimburseEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((String)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(REIM_PAYAPPLY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayReimburseEntity::getBillCode, (Object)entity.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(PayReimburseEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().remove("createUserCode");
        }
        if (param.getParams().containsKey("projectId")) {
            param.getParams().remove("createUserCode");
        }
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayReimburseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayReimburseVO> list = ((PayReimburseMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayReimburseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayReimburseVO> list = ((PayReimburseMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ParamsCheckSpreadVO checkParams(Long projectId, BigDecimal appMoney) {
        CommonResponse budget;
        CommonResponse settleMny;
        BigDecimal purchaseSettleMny;
        BigDecimal rentSettleMny;
        BigDecimal loadReimburseMny;
        BigDecimal payReimburseMny;
        BigDecimal temp;
        BigDecimal costbudgetMny;
        BigDecimal endSum;
        BigDecimal excessMoney;
        BigDecimal sumMoney;
        BigDecimal oldSumMoney;
        ArrayList<ParamsCheckDsSpreadVO> checkDsVOS;
        BigDecimal manageRate;
        ParamsCheckSpreadVO paramsCheckVO;
        block6: {
            List<ProjectReimburseVO> projectReimburse;
            block7: {
                block4: {
                    block5: {
                        ArrayList<Long> projectIds = new ArrayList<Long>();
                        projectIds.add(projectId);
                        String[] paramsArray = new String[]{"none", "warn", "alert"};
                        paramsCheckVO = new ParamsCheckSpreadVO();
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        manageRate = BigDecimal.ZERO;
                        CommonResponse byCode = this.paramConfigApi.getByCode(SYS_IS_PROBUDGET_CODE);
                        if (!byCode.isSuccess() || null == byCode.getData()) break block4;
                        ParamRegisterSetVO data = (ParamRegisterSetVO)byCode.getData();
                        String valueData = data.getValueData();
                        if (!"1".equals(valueData)) {
                            this.logger.info("\u672a\u8bfb\u53d6\u5230\u8d39\u7387\u914d\u7f6e\u53c2\u6570\uff01" + projectId);
                            return paramsCheckVO;
                        }
                        CommonResponse probudgetCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_PROBUDGET_CODE);
                        if (!probudgetCode.isSuccess() || null == probudgetCode.getData()) break block5;
                        paramsCheckVO.setWarnType(paramsArray[((BillParamVO)probudgetCode.getData()).getControlType()]);
                        manageRate = ((BillParamVO)probudgetCode.getData()).getRoleValue();
                        checkDsVOS = new ArrayList<ParamsCheckDsSpreadVO>();
                        oldSumMoney = BigDecimal.ZERO;
                        sumMoney = BigDecimal.ZERO;
                        excessMoney = BigDecimal.ZERO;
                        endSum = BigDecimal.ZERO;
                        costbudgetMny = BigDecimal.ZERO;
                        temp = new BigDecimal(100);
                        payReimburseMny = BigDecimal.ZERO;
                        loadReimburseMny = BigDecimal.ZERO;
                        rentSettleMny = BigDecimal.ZERO;
                        purchaseSettleMny = BigDecimal.ZERO;
                        projectReimburse = this.payContractService.getProjectReimburse(projectIds, null);
                        settleMny = this.iSettlementApi.getSettleMny(projectIds);
                        budget = this.iBudgetPlanApi.getBudget(projectId);
                        if (!CollectionUtils.isNotEmpty(projectReimburse)) break block6;
                        break block7;
                    }
                    return paramsCheckVO;
                }
                this.logger.info("\u975e\u4e16\u7eaa\u9633\u5149\uff01" + projectId);
                return paramsCheckVO;
            }
            payReimburseMny = projectReimburse.get(0).getPayReimburseMny();
            loadReimburseMny = projectReimburse.get(0).getLoadReimburseMny();
        }
        if (settleMny.isSuccess() && null != settleMny.getData() && ((List)settleMny.getData()).size() > 0) {
            rentSettleMny = ((SettlementVO)((List)settleMny.getData()).get(0)).getRentSettleMny();
            purchaseSettleMny = ((SettlementVO)((List)settleMny.getData()).get(0)).getPurchaseSettleMny();
        }
        if (budget.isSuccess() && null != budget.getData()) {
            costbudgetMny = ((BudgetTemVO)budget.getData()).getManageMny();
            endSum = costbudgetMny.multiply(manageRate).divide(temp);
        }
        oldSumMoney = payReimburseMny.add(loadReimburseMny).add(rentSettleMny).add(purchaseSettleMny);
        sumMoney = oldSumMoney.add(appMoney);
        excessMoney = sumMoney.subtract(endSum);
        BigDecimal reimburseMmy = payReimburseMny.add(loadReimburseMny).add(appMoney);
        BigDecimal manageMmy = costbudgetMny;
        paramsCheckVO.setManageMmy(manageMmy);
        paramsCheckVO.setReimburseMmy(reimburseMmy);
        if (sumMoney.compareTo(endSum) > 0) {
            ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
            paramsCheckDsVO.setWarnItem("\u7ba1\u7406\u8d39\u8d85\u4ed8");
            paramsCheckDsVO.setWarnName("\u7ba1\u7406\u8d39\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u4e2d\u7ba1\u7406\u8d39\u91d1\u989d");
            paramsCheckDsVO.setContent("\u672c\u6b21\u7ba1\u7406\u8d39\u91d1\u989d\uff1a" + appMoney.setScale(2, 4) + "\u5143\uff0c\u9884\u7b97\u7ba1\u7406\u8d39\u91d1\u989d*" + manageRate.setScale(2, 4) + "%\uff1a" + endSum.setScale(2, 4) + "\u5143\u3002\u8d85\u51fa\u91d1\u989d:" + excessMoney.setScale(2, 4) + "\u5143\u3002");
            checkDsVOS.add(paramsCheckDsVO);
            paramsCheckVO.setDataSource(checkDsVOS);
        }
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<PayReimburseVO> updateShareMoney(Long id, BigDecimal mny) {
        PayReimburseEntity payReimburseEntity = (PayReimburseEntity)((Object)this.selectById(id));
        if (payReimburseEntity != null) {
            BigDecimal countShareMny_old = payReimburseEntity.getCountShareMny();
            BigDecimal countShareMny_new = ComputeUtil.safeAdd((BigDecimal)countShareMny_old, (BigDecimal)mny);
            if (countShareMny_new.compareTo(BigDecimal.ZERO) < 0) {
                return CommonResponse.error((String)"\u7d2f\u8ba1\u5206\u644a\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\uff01");
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)id);
            wrapper.set(PayReimburseEntity::getCountShareMny, (Object)countShareMny_new);
            this.update((Wrapper)wrapper);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u62a5\u9500\u5355\u4e0d\u5b58\u5728\uff01");
    }

    @Override
    public List<PayReimburseVO> queryReferData(Page<PayReimburseVO> page, QueryWrapper wrapper) {
        return ((PayReimburseMapper)this.baseMapper).queryReferData(page, wrapper);
    }

    @Override
    public CommonResponse<PayReimburseStatisticsVO> getPayReimburseInfo(Integer dependOnProject) {
        String lastMonthLastDayOfPreviousYear = EJCDateUtil.format((Date)new Date(), (String)"yyyy") + "-12-31";
        String firstDayOfCurrentYear = EJCDateUtil.getFirstDayOfCurrentYear((String)"yyyy-MM-dd");
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"IFNULL(SUM(IF((is_share_flag = 0),apply_mny,0)),0)AS applyMny,IFNULL(SUM(IF((is_share_flag = 0),pay_mny,0)),0) AS payMny,IFNULL(SUM(IF((is_share_flag = 0),invoice_mny,0)),0) AS invoiceMny"});
        queryWrapper.eq((Object)"depend_on_project", (Object)dependOnProject);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in(CollectionUtils.isNotEmpty(orgIds), (Object)"org_id", orgIds);
        queryWrapper.between((Object)"apply_time", (Object)firstDayOfCurrentYear, (Object)lastMonthLastDayOfPreviousYear);
        PayReimburseEntity one = (PayReimburseEntity)((Object)((PayReimburseMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        PayReimburseStatisticsVO payReimburseStatisticsVO = new PayReimburseStatisticsVO();
        payReimburseStatisticsVO.setThisYearApplyMny(one.getApplyMny());
        payReimburseStatisticsVO.setThisYearPayMny(one.getPayMny());
        payReimburseStatisticsVO.setThisYearInvoiceMny(one.getInvoiceMny());
        String month = EJCDateUtil.getCurrentDay((String)"yyyy-MM");
        String startMonth = month + "-01";
        String endMonth = month + "-31";
        QueryWrapper thisMonthQueryWrapper = new QueryWrapper();
        thisMonthQueryWrapper.select(new String[]{"IFNULL(SUM(IF((is_share_flag = 0),apply_mny,0)),0)AS applyMny,IFNULL(SUM(IF((is_share_flag = 0),pay_mny,0)),0) AS payMny,IFNULL(SUM(IF((is_share_flag = 0),invoice_mny,0)),0) AS invoiceMny"});
        thisMonthQueryWrapper.eq((Object)"depend_on_project", (Object)dependOnProject);
        thisMonthQueryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        thisMonthQueryWrapper.in(CollectionUtils.isNotEmpty(orgIds), (Object)"org_id", orgIds);
        thisMonthQueryWrapper.between((Object)"apply_time", (Object)startMonth, (Object)endMonth);
        PayReimburseEntity thisMonthInfo = (PayReimburseEntity)((Object)((PayReimburseMapper)this.baseMapper).selectOne((Wrapper)thisMonthQueryWrapper));
        payReimburseStatisticsVO.setThisMonthApplyMny(thisMonthInfo.getApplyMny());
        payReimburseStatisticsVO.setThisMonthPayMny(thisMonthInfo.getPayMny());
        payReimburseStatisticsVO.setThisMonthInvoiceMny(thisMonthInfo.getInvoiceMny());
        return CommonResponse.success((String)"\u83b7\u53d6\u62a5\u9500\u4fe1\u606f\u6210\u529f\uff01", (Object)payReimburseStatisticsVO);
    }

    @Override
    public IPage<PayReimburseStatisticsVO> payReimburseStatisticsList(Page<PayReimburseStatisticsVO> page, QueryWrapper wrapper, String dependOnProject, List<Long> feeType) {
        return ((PayReimburseMapper)this.baseMapper).payReimburseStatisticsList(page, wrapper, dependOnProject, feeType);
    }

    @Override
    public List<PayReimburseStatisticsVO> payReimburseStatisticsDetailList(Long projectId, Long orgId, List<Long> feeType) {
        return ((PayReimburseMapper)this.baseMapper).payReimburseStatisticsDetailList(projectId, orgId, feeType);
    }

    @Override
    public void closePayment(Long payapplyId) {
        if (payapplyId != null) {
            PayReimburseEntity entity = (PayReimburseEntity)((Object)super.selectById((Serializable)payapplyId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)payapplyId);
            updateWrapper.set(PayReimburseEntity::getApplyMnyBeforeClose, (Object)entity.getApplyMny());
            updateWrapper.set(PayReimburseEntity::getApplyMny, (Object)entity.getPayMny());
            updateWrapper.set(PayReimburseEntity::getApplyMnyCn, (Object)NumberToCN.number2CN(entity.getPayMny()));
            updateWrapper.set(PayReimburseEntity::getCloseState, (Object)"\u5df2\u5173\u95ed");
            updateWrapper.set(PayReimburseEntity::getCloseFlag, (Object)Boolean.TRUE);
            updateWrapper.set(PayReimburseEntity::getCloseTime, (Object)DateUtil.getCurrentDay("yyyy-MM-dd HH:mm:ss"));
            updateWrapper.set(PayReimburseEntity::getCloseUser, (Object)this.sessionManager.getUserContext().getUserName());
            super.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public PayRecordVO returnPayment(PayRecordVO vo) {
        Long payapplyId = vo.getPayapplyId();
        if (payapplyId != null) {
            PayRecordEntity entity = (PayRecordEntity)((Object)BeanMapper.map((Object)vo, PayRecordEntity.class));
            entity.setThisPayMny(ComputeUtil.convertToMinusNumber((BigDecimal)entity.getThisPayMny()));
            PayReimburseEntity reimburse = (PayReimburseEntity)((Object)this.selectById(payapplyId));
            entity.setBillCode(reimburse.getBillCode());
            entity.setProjectId(reimburse.getProjectId());
            entity.setProjectName(reimburse.getProjectName());
            entity.setOrgId(reimburse.getOrgId());
            entity.setOrgName(reimburse.getOrgName());
            entity.setApplyUserId(reimburse.getApplyUserId());
            entity.setApplyUserName(reimburse.getApplyUserName());
            entity.setApplyTime(reimburse.getApplyTime());
            entity.setApplyMny(reimburse.getApplyMny());
            entity.setFeeType(reimburse.getFeeType());
            this.payRecordService.saveOrUpdate((Object)entity);
            BigDecimal payMny = MathUtil.safeAdd((BigDecimal)reimburse.getPayMny(), (BigDecimal)entity.getThisPayMny());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)payapplyId);
            updateWrapper.set(PayReimburseEntity::getPayMny, (Object)payMny);
            boolean update = super.update((Wrapper)updateWrapper);
            if (vo.getClosed().booleanValue() && update) {
                this.closePayment(payapplyId);
            }
        }
        return vo;
    }
}

