package com.ejianc.business.finance.controller;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.bean.ReceiveQuteDetailEntity;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.vo.ReceiveQuteDetailVO;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.income.vo.ProductionVo;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Controller
@RequestMapping("/receive")
public class ReceiveController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IReceiveService receiveService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private IPayContractService payContractService;

    @Autowired
    private IPaySporadicService paySporadicService;

    @Autowired
    private IPayReimburseService payReimburseService;

    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private IReceiveQuteDetailService receiveQuteDetailService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param receiveVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReceiveVO> saveOrUpdate(@RequestBody ReceiveVO receiveVO) {
        ReceiveVO backVO = receiveService.insertOrUpdate(receiveVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReceiveVO> queryDetail(Long id) {
        ReceiveVO backVO = receiveService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description queryPrint 查询打印详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("Receive", receiveService.queryDetail(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject page = receiveService.queryPageJson(param,false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReceiveVO> vos) {
        List<Long> ids = vos.stream().map(ReceiveVO::getId).collect(Collectors.toList());
        String msg = receiveService.delete(ids);
        return CommonResponse.success(msg);
    }


    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<ReceiveVO> supplierVos = receiveService.queryExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("receive-export.xlsx", beans, response);
    }

    /**
     * 统计累计已生效的收支
     *
     * @param projectRange
     * @return
     */
    @GetMapping(value = "/countRecAndPay")
    @ResponseBody
    public CommonResponse<JSONObject> countRecAndPay(HttpServletRequest req, @RequestParam(value = "projectRange") Integer projectRange) {
        JSONObject resp = new JSONObject();
        List<Long> projectIds = new ArrayList<>();
        if(projectRange != 1) {
            CommonResponse<List<Long>> res = projectApi.getProjectIdsByProperties(projectRange);
            if(!res.isSuccess()) {
                if(!res.isSuccess()) {
                    logger.error("根据条件 projectRange-{} 查询项目Id列表失败，原因：{}", projectRange, res.getMsg());
                    return CommonResponse.error("查询失败，查询匹配的项目信息失败。");
                }
            }
            projectIds = res.getData();
            if(CollectionUtils.isEmpty(projectIds)) {
                resp.put("rec", 0);
                resp.put("out", 0);
                return CommonResponse.success(resp);
            }
        }
        /**
         * 这个地方的orgIds 使用不到给一个你null
         * countByProperties 这个接口需要添加移动端组织过滤
         */
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        //收入
        Map<String, Object> result = receiveService.countRecAmt(InvocationInfoProxy.getTenantid() ,projectIds,orgIds, false);
        resp.put("rec", result.get("amt"));

        //支出
        //1、合同付款
        Map<String, Object> payContractResult = payContractService.countAmt(InvocationInfoProxy.getTenantid(), projectIds);
        Map<String, Object> paySporadicResult = paySporadicService.countAmt(InvocationInfoProxy.getTenantid(), projectIds);
        Map<String, Object> payReimburse = payReimburseService.countAmt(InvocationInfoProxy.getTenantid(), projectIds);
        Map<String, Object> loadReimburseResult = loadReimburseService.countAmt(InvocationInfoProxy.getTenantid(), projectIds);
        BigDecimal totalOut = new BigDecimal(0);
        totalOut = totalOut.add(new BigDecimal(payContractResult.get("amt").toString()));
        totalOut = totalOut.add(new BigDecimal(paySporadicResult.get("amt").toString()));
        totalOut = totalOut.add(new BigDecimal(payReimburse.get("amt").toString()));
        totalOut = totalOut.add(new BigDecimal(loadReimburseResult.get("amt").toString()));

        resp.put("out", totalOut.divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP));
        return CommonResponse.success(resp);
    }
    /**
     * @Author jiangyikia
     * @Date 2022/4/20
     * @Description saveOrUpdate 查询详情
     * @param vos
     * @Return
     */
    @RequestMapping(value = "/getLastReceiveTaxMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ReceiveQuteDetailVO>> getLastReceiveTaxMny(@RequestBody  List<ReceiveQuteDetailVO> vos) {
        List<ReceiveQuteDetailVO> list=receiveService.getLastReceiveTaxMny(vos);
        return CommonResponse.success("查询详情数据成功！", list);
    }

    /**
     *甲方子表excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/quteDetaiExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void quteDetaiExcelExport(@RequestBody ReceiveQuteDetailVO vo, HttpServletResponse response) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("receiveId",new Parameter(QueryParam.EQ,vo.getReceiveId()));
        List<ReceiveQuteDetailEntity> list = receiveQuteDetailService.queryList(queryParam, false);
        List<ReceiveQuteDetailVO> vos = BeanMapper.mapList(list, ReceiveQuteDetailVO.class);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("qute-detail-export.xlsx", beans, response);
    }


    /***
     * 根据合同id 查询 合同累计收款
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/queryInfoContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReceiveVO> queryInfoContractId(Long contractId) {
        ReceiveVO receiveVO= receiveService.queryInfoContractId(contractId);
        return CommonResponse.success("查询打印数据成功！",receiveVO);
    }

    @RequestMapping(value = "/queryTotalReceiveMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReceiveVO>> queryTotalReceiveMny(@RequestParam(value ="quoteIds") List<Long> quoteIds) {
        List<ReceiveVO> vos= receiveService.queryTotalReceiveMny(quoteIds);
        return CommonResponse.success("查询打印数据成功！",vos);
    }

    /***
     * 根据项目id 查询 合同累计收款
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryInfoProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReceiveVO> queryInfoProjectId(Long projectId) {
        ReceiveVO receiveVO= receiveService.queryInfoProjectId(projectId);
        return CommonResponse.success("查询打印数据成功！",receiveVO);
    }

}
