package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpMapper;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondReportVO;
import com.ejianc.business.finance.vo.BondUpVO;
import com.ejianc.business.finance.vo.BondVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 保证金对上申请表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondUpServiceImpl extends BaseServiceImpl<BondUpMapper, BondUpEntity> implements IBondUpService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String BONDUP_BILL_CODE = "FINANCE_BONDUP";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;

    @Override
    public CommonResponse<BondUpVO> insertOrUpdate(BondUpVO bondUpVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(null!=bondUpVO&&StringUtils.isEmpty(bondUpVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                bondUpVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //保存时校验合同version是否一致
        if(bondUpVO.getContractVersion()!=null&&bondUpVO.getContractVersion()!=0){
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try{
                locked = RedisTool.tryLock(jedis, String.valueOf(bondUpVO.getContractId()), "saveOrUpdate", 1000);
                logger.info("判断单据单据锁结果------"+locked);
                if(locked){
                    JSONObject contractEntity = commenQueryFieldsService.queryBillDetail(String.valueOf(bondUpVO.getContractId()),"BT200528000000002");
                    String objVersion = contractEntity.getJSONObject("data").get("version").toString();
                    Integer version =contractEntity.getJSONObject("data").get("version")==null?0:Integer.parseInt(objVersion.substring(0,objVersion.indexOf(".")));
                    Integer conVersion = bondUpVO.getContractVersion();
                    if(version!=conVersion){
                        return CommonResponse.error("该合同已被更新，请刷新后重做！");
                    }
                }else{
                    return CommonResponse.error("出现并发操作,请稍后重试！");
                }
            }catch (Exception e) {
                e.printStackTrace();
            } finally {
                if(locked) {
                    RedisTool.releaseLock(jedis, String.valueOf(bondUpVO.getContractId()), "saveOrUpdate");
                }
                jedis.close();
            }
        }
        bondUpVO.setBondStatus("0");
        BondUpEntity entity = BeanMapper.map(bondUpVO, BondUpEntity.class);
        super.saveOrUpdate(entity,false);
        return CommonResponse.success(BeanMapper.map(entity, BondUpVO.class));
    }

    @Override
    public BondUpVO queryDetail(Long id) {
        BondUpEntity entity = super.selectById(id);
        BondUpVO bondUpVO = BeanMapper.map(entity, BondUpVO.class);
        return bondUpVO;
    }

    @Override
    public List<BondVO> queryUnDealList(Page pages, QueryWrapper queryWrapper) {
        List<BondVO> listres = baseMapper.pageList(pages,queryWrapper);
        return listres;
    }

    @Override
    public BondReportVO queryBondReport(QueryWrapper queryWrapper) {
        BondReportVO reportVO = new BondReportVO();
        //对上保证金统计
        List<BondReportVO> list = baseMapper.queryBondUpReport(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(vo -> {
                BigDecimal upPayMny = vo.getUpPayMny()==null?BigDecimal.ZERO:vo.getUpPayMny();
                BigDecimal upBackMny = vo.getUpBackMny()==null?BigDecimal.ZERO:vo.getUpBackMny();
                reportVO.setUpApplyMny(reportVO.getUpApplyMny().add(vo.getUpApplyMny()));
                reportVO.setUpBackMny(reportVO.getUpBackMny().add(upBackMny));
                reportVO.setUpPayMny(reportVO.getUpPayMny().add(upPayMny));
                if(new Date().after(vo.getEndDate())){
                    reportVO.setUpUnPayMny(reportVO.getUpUnPayMny().add(upPayMny.subtract(upBackMny)));
                }
             });
        }
        //对下保证金统计
        List<BondReportVO> downList = baseMapper.queryBondDownReport(queryWrapper);
        if(CollectionUtils.isNotEmpty(downList)){
            downList.forEach(vo -> {
                BigDecimal downPayMny = vo.getDownPayMny()==null?BigDecimal.ZERO:vo.getDownPayMny();
                BigDecimal downBackMny = vo.getDownBackMny()==null?BigDecimal.ZERO:vo.getDownBackMny();
                reportVO.setDownApplyMny(reportVO.getDownApplyMny().add(vo.getDownApplyMny()));
                reportVO.setDownBackMny(reportVO.getDownBackMny().add(downBackMny));
                reportVO.setDownPayMny(reportVO.getDownPayMny().add(downPayMny));
                if(new Date().after(vo.getEndDate())){
                    reportVO.setDownUnPayMny(reportVO.getDownUnPayMny().add(downPayMny.subtract(downBackMny)));
                }
            });
        }
        return reportVO;
    }

    @Override
    public IPage<BondUpEntity> selectPage(Page pages, QueryWrapper queryWrapper) {
        return baseMapper.selectPage(pages,queryWrapper);
    }
}
