/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.PayFocusDetailEntity;
import com.ejianc.business.finance.bean.PayFocusEntity;
import com.ejianc.business.finance.service.IPayFocusService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="payFocus")
public class PayFocusBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPayFocusService payFocusService;
    @Autowired
    private HttpServletRequest request;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (billId != null) {
            this.logger.info("\u96c6\u4e2d\u4ed8\u6b3e\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406----------------\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
            PayFocusEntity payFocusEntity = (PayFocusEntity)((Object)this.payFocusService.selectById(billId));
            List<PayFocusDetailEntity> detailList = payFocusEntity.getPayFocusDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                Map<Long, List<PayFocusDetailEntity>> collect = detailList.stream().collect(Collectors.groupingBy(o -> o.getProjectId()));
                Long tenantId = InvocationInfoProxy.getTenantid();
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PAY_CONTRACT_BILL_CODE, tenantId, collect.size());
                ArrayList<String> billCodeList = new ArrayList();
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                billCodeList = (List)billCode.getData();
                this.logger.info("billcode----------------\uff1a" + JSONObject.toJSONString((Object)billCode));
                String authority = this.request.getHeader("authority");
                if (authority == null) {
                    authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
                }
                ExecutorService threadPool = Executors.newFixedThreadPool(2);
                try {
                    UserContext userContext = this.sessionManager.getUserContext();
                    PayFocusCallable payFocusCallable = new PayFocusCallable(this.payFocusService, payFocusEntity, billCodeList, userContext.getUserCode(), authority);
                    threadPool.submit(payFocusCallable);
                }
                catch (Exception e) {
                    this.logger.error("\u96c6\u4e2d\u4ed8\u6b3e\u63a8\u9001\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e\u5f02\u5e38", (Throwable)e);
                    throw new BusinessException("\u96c6\u4e2d\u4ed8\u6b3e\u63a8\u9001\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e\u5f02\u5e38\uff01");
                }
                finally {
                    threadPool.shutdown();
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u8be5\u5355\u636e\u65e0\u6cd5\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    class PayFocusCallable
    implements Callable<PayFocusEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IPayFocusService payFocusService;
        private PayFocusEntity payFocusEntity;
        private List<String> billCodeList;
        private String userCode;
        private String authority;

        public PayFocusCallable(IPayFocusService payFocusService, PayFocusEntity payFocusEntity, List<String> billCodeList, String userCode, String authority) {
            this.payFocusService = payFocusService;
            this.payFocusEntity = payFocusEntity;
            this.billCodeList = billCodeList;
            this.userCode = userCode;
            this.authority = authority;
        }

        @Override
        public PayFocusEntity call() {
            PayFocusBpmServiceImpl.this.logger.info("\u7ebf\u7a0b\u5f00\u59cb----------------");
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)this.authority);
            this.payFocusService.pushPayContract(this.payFocusEntity, this.billCodeList, this.userCode);
            PayFocusBpmServiceImpl.this.logger.info("\u7ebf\u7a0b\u7ed3\u675f----------------");
            return this.payFocusEntity;
        }
    }
}

