/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.vo.PayForegiftVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/payForegift"})
public class PayForegiftController {
    @Autowired
    private IPayForegiftService payForegiftService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayForegiftVO> saveOrUpdate(@RequestBody PayForegiftVO payForegiftVO) {
        PayForegiftVO backVO = this.payForegiftService.insertOrUpdate(payForegiftVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayForegiftVO> queryDetail(Long id) {
        PayForegiftVO backVO = this.payForegiftService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PayForegift", (Object)this.payForegiftService.queryDetail(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        JSONObject page = this.payForegiftService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryApproveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryApproveList(@RequestBody QueryParam param) {
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        JSONObject page = this.payForegiftService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayForegiftVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        String msg = this.payForegiftService.delete(ids);
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<PayForegiftVO> supplierVos = this.payForegiftService.queryExportList(queryParam);
        supplierVos.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        HashMap<String, List<PayForegiftVO>> beans = new HashMap<String, List<PayForegiftVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("foregift-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryReceiveInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayForegiftVO> queryReceiveInfo(Long receiveUnitId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("receiveUnitId", new Parameter("eq", (Object)receiveUnitId));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("createTime", "desc");
        List entityList = this.payForegiftService.queryList(queryParam, false);
        PayForegiftVO backVO = !entityList.isEmpty() ? (PayForegiftVO)BeanMapper.map(entityList.get(0), PayForegiftVO.class) : new PayForegiftVO();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"getTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfo(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.payForegiftService.getTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"getApproveTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getApproveTotalColumnInfo(@RequestBody QueryParam param) {
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.payForegiftService.getApproveTotalColumnInfo(param, false));
    }
}

