/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.LoadBackEntity;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.mapper.LoadApplyMapper;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadBackService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.vo.LoadApplyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoadApplyServiceImpl
extends BaseServiceImpl<LoadApplyMapper, LoadApplyEntity>
implements ILoadApplyService {
    private static final String BONDUP_BILL_CODE = "LOAD_APPLY";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private ILoadBackService loadBackService;
    @Autowired
    private IDeductionService deductionService;

    @Override
    public LoadApplyVO insertOrUpdate(LoadApplyVO loadApplyVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (null != loadApplyVO && StringUtils.isEmpty((CharSequence)loadApplyVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                loadApplyVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(LoadApplyEntity::getApplyEmployeeId, (Object)loadApplyVO.getApplyEmployeeId());
        lambdachange.eq(LoadApplyEntity::getOrgId, (Object)loadApplyVO.getOrgId());
        if (null != loadApplyVO.getId() && loadApplyVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)loadApplyVO.getId());
        }
        lambdachange.ne(LoadApplyEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(LoadApplyEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        List list = super.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u5728\u8be5\u7ec4\u7ec7\u5b58\u5728\u672a\u751f\u6548\u7684\u501f\u6b3e\u7533\u8bf7\u5355,\u5355\u636e\u7f16\u53f7\u3010" + ((LoadApplyEntity)((Object)list.get(0))).getBillCode() + "\u3011");
        }
        LoadApplyEntity entity = (LoadApplyEntity)((Object)BeanMapper.map((Object)loadApplyVO, LoadApplyEntity.class));
        BigDecimal surplusMny = this.querySurplusMny(null, null, entity.getOrgId(), 1, String.valueOf(loadApplyVO.getApplyEmployeeId()));
        entity.setSurplusMny(surplusMny);
        super.saveOrUpdate((Object)entity, false);
        return (LoadApplyVO)BeanMapper.map((Object)((Object)entity), LoadApplyVO.class);
    }

    @Override
    public BigDecimal querySurplusMny(Long rebid, Long backid, Long orgId, int type, String applyEmployeeId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)applyEmployeeId)) {
            applyEmployeeId = InvocationInfoProxy.getEmployeeId();
        }
        List listApplys = new ArrayList();
        List listReimburse = new ArrayList();
        List listBack = new ArrayList();
        List listDeduction = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(LoadApplyEntity::getOrgId, (Object)orgId);
        lambda.eq(LoadApplyEntity::getApplyEmployeeId, (Object)applyEmployeeId);
        lambda.in(LoadApplyEntity::getBillState, billstate);
        listApplys = super.list((Wrapper)lambda);
        BigDecimal sumApplyMny = listApplys.stream().map(LoadApplyEntity::getApplyMny).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        List loadApplyIds = listApplys.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("org_id", new Parameter("eq", (Object)orgId));
        queryParam.getParams().put("apply_employee_id", new Parameter("eq", (Object)applyEmployeeId));
        if (null != rebid) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)rebid));
        }
        if (1 == type) {
            queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        }
        listReimburse = this.loadReimburseService.queryList(queryParam, false);
        BigDecimal sumReimburseMny = listReimburse.stream().map(LoadReimburseEntity::getReimburseMny).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        queryParam2.getParams().put("org_id", new Parameter("eq", (Object)orgId));
        queryParam2.getParams().put("apply_employee_id", new Parameter("eq", (Object)applyEmployeeId));
        if (null != backid) {
            queryParam2.getParams().put("id", new Parameter("ne", (Object)backid));
        }
        if (1 == type) {
            queryParam2.getParams().put("bill_state", new Parameter("in", billstate));
        }
        listBack = this.loadBackService.queryList(queryParam2, false);
        BigDecimal sumBackMny = listBack.stream().map(LoadBackEntity::getBackMny).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        if (CollectionUtils.isNotEmpty(loadApplyIds)) {
            QueryParam queryParam3 = new QueryParam();
            queryParam3.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam3.getParams().put("org_id", new Parameter("eq", (Object)orgId));
            queryParam3.getParams().put("bill_state", new Parameter("in", billstate));
            queryParam3.getParams().put("cash_id", new Parameter("in", loadApplyIds));
            listDeduction = this.deductionService.queryList(queryParam3);
        }
        BigDecimal sumDeductionMny = listDeduction.stream().map(DeductionEntity::getPenaltyMoney).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        BigDecimal ApplyMny = sumApplyMny == null ? BigDecimal.ZERO : sumApplyMny;
        BigDecimal ReimburseMny = sumReimburseMny == null ? BigDecimal.ZERO : sumReimburseMny;
        BigDecimal BackMny = sumBackMny == null ? BigDecimal.ZERO : sumBackMny;
        BigDecimal DeductionMny = sumDeductionMny == null ? BigDecimal.ZERO : sumDeductionMny;
        return ApplyMny.subtract(ReimburseMny).subtract(BackMny).subtract(DeductionMny);
    }

    @Override
    public List<LoadApplyVO> queryUserReport() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        String userId = InvocationInfoProxy.getEmployeeId();
        List<LoadApplyVO> list = ((LoadApplyMapper)this.baseMapper).getUserReport(tenantId, userId);
        return list;
    }

    @Override
    public List<LoadApplyVO> queryAllReport(Page pages, QueryWrapper queryWrapper) {
        List<LoadApplyVO> listres = ((LoadApplyMapper)this.baseMapper).getReports(pages, queryWrapper);
        return listres;
    }
}

