/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.mapper.BondDownMapper;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.vo.BondDownVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public class BondDownServiceImpl
extends BaseServiceImpl<BondDownMapper, BondDownEntity>
implements IBondDownService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BONDDOWN_BILL_CODE = "FINANCE_BONDDOWN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<BondDownVO> insertOrUpdate(BondDownVO bondDownVO) {
        block13: {
            Long tenantId = InvocationInfoProxy.getTenantid();
            if (null != bondDownVO && StringUtils.isEmpty((CharSequence)bondDownVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONDDOWN_BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    bondDownVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            if (bondDownVO.getContractVersion() != null && bondDownVO.getContractVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(bondDownVO.getContractId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        JSONObject contractEntity = this.commenQueryFieldsService.queryBillDetail(String.valueOf(bondDownVO.getContractId()), this.getBillTypeCode(bondDownVO.getContractType()));
                        String objVersion = contractEntity.getJSONObject("data").get((Object)"version").toString();
                        Integer version = contractEntity.getJSONObject("data").get((Object)"version") == null ? 0 : Integer.parseInt(objVersion.substring(0, objVersion.indexOf(".")));
                        if (version != (conVersion = bondDownVO.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                        break block13;
                    }
                    CommonResponse contractEntity = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                    return contractEntity;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(bondDownVO.getContractId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        bondDownVO.setBondStatus("0");
        BondDownEntity entity = (BondDownEntity)((Object)BeanMapper.map((Object)bondDownVO, BondDownEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), BondDownVO.class));
    }

    @Override
    public BondDownVO queryDetail(Long id) {
        BondDownEntity entity = (BondDownEntity)((Object)super.selectById((Serializable)id));
        BondDownVO bondDownVO = (BondDownVO)BeanMapper.map((Object)((Object)entity), BondDownVO.class);
        return bondDownVO;
    }

    @Override
    public IPage<BondDownEntity> selectPage(Page pages, QueryWrapper queryWrapper) {
        return ((BondDownMapper)this.baseMapper).selectPage((IPage)pages, (Wrapper)queryWrapper);
    }

    public String getBillTypeCode(String contractType) {
        if ("1".equals(contractType)) {
            return "BT200529000000001";
        }
        if ("2".equals(contractType)) {
            return "BT200528000000001";
        }
        if ("3".equals(contractType)) {
            return "BT200528000000003";
        }
        if ("4".equals(contractType)) {
            return "BT200608000000001";
        }
        if ("5".equals(contractType)) {
            return "BT200608000000001";
        }
        return "";
    }
}

