/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="deduction")
public class DeductionBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String VOUCHER_PARAM = "P-h5UC6769";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IDeductionService deductionService;
    @Autowired
    private IVoucherApi voucherApi;
    @Autowired
    private HttpServletRequest request;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Long projectId;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        DeductionEntity entity = (DeductionEntity)((Object)this.deductionService.selectById(billId));
        CommonResponse byCode = this.paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData() && ((valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData()).equals(String.valueOf(projectId = entity.getProjectId())) || "\u662f".equals(valueData))) {
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                this.logger.info("request-authority\u4e3a\u7a7a");
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            try {
                VoucherParams voucherParams = VoucherParams.newInstanceByOrgId((String)"BT210924000000001", (Object)((Object)entity), (SystemCodeEnum)SystemCodeEnum.FINANCE);
                AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.deductionService, voucherParams, "save", RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            }
            catch (Exception e) {
                this.logger.error("\u6263\u6b3e\u5355\u63a8\u9001\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e);
            }
            finally {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse stringCommonResponse = this.billTypeApi.checkQuote(billTypeCode, billId);
        boolean success = stringCommonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u5df2\u7ecf\u88ab\u4ed8\u6b3e\u7533\u8bf7\u4f7f\u7528\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
        }
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        DeductionEntity entity = (DeductionEntity)((Object)this.deductionService.selectById(billId));
        if (!VoucherFlag.NO_NEED.equals(entity.getVoucherFlag())) {
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                this.logger.info("request-authority\u4e3a\u7a7a");
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            try {
                VoucherParams voucherParams = VoucherParams.newInstanceByOrgId((String)"BT210924000000001", (Object)((Object)entity), (SystemCodeEnum)SystemCodeEnum.FINANCE);
                AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.deductionService, voucherParams, "del", RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            }
            catch (Exception e) {
                this.logger.error("\u6263\u6b3e\u5355\u64a4\u56de\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e);
            }
            finally {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success();
    }
}

