package com.ejianc.business.finance.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.BondUpDealEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.finance.vo.BondUpDealVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 保证金办理表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@RestController
@RequestMapping("/bondUpDeal")
public class BondUpDealController {
    @Autowired
    private IBondUpDealService bondUpDealService;
    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IVoucherApi voucherApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param bondUpDealVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BondUpDealVO> saveOrUpdate(@RequestBody BondUpDealVO bondUpDealVO) {
        BondUpDealVO backVO = bondUpDealService.insertOrUpdate(bondUpDealVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }

    /**
     * @description: 推送凭证
     *
     * @param voucherInfo
     * @return {@link CommonResponse}
     * @author songlx
     * @date: 2024/1/12
     */
    @RequestMapping(value = "/pushVoucher", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull(billId, "单据billId不能为空！");
        BondUpDealEntity entity = bondUpDealService.selectById(billId);
        BondUpEntity bondUpEntity = bondUpService.selectById(entity.getBondId());
        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(entity));
        jsonObject.put("orgId",bondUpEntity.getOrgId());
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT200622000000001", jsonObject, SystemCodeEnum.FINANCE);
        CommonResponse<VoucherInfo> response = voucherApi.handleVoucher(voucherParams, VoucherOptFlag.SAVE);
        if (response.isSuccess()) {
            logger.info("response: {}", DataConvertUtil.toPrettyFormat(response));
            voucherInfo = response.getData();
            LambdaUpdateWrapper<BondUpDealEntity> lambda = new LambdaUpdateWrapper<>();
            lambda.eq(BondUpDealEntity::getId, entity.getId());
            lambda.set(BondUpDealEntity::getVoucherInfo, DataConvertUtil.objToString(voucherInfo));
            lambda.set(BondUpDealEntity::getVoucherFlag, voucherInfo.getVoucherFlag());
            boolean update = bondUpDealService.update(lambda);
            logger.info("update: {}", update);
        }
        return response;
    }
    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondUpDealRentVO> queryDetail(Long id) {
        BondUpDealRentVO backVO = bondUpDealService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }

}
