package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.BondDownDealEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.bean.BondUpDealEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondDownDealMapper;
import com.ejianc.business.finance.service.IBondDownDealService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondDownDealRentVO;
import com.ejianc.business.finance.vo.BondDownDealVO;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.finance.vo.BondUpDealVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 保证金办理表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondDownDealServiceImpl extends BaseServiceImpl<BondDownDealMapper, BondDownDealEntity> implements IBondDownDealService {
    private static final String BONGDOWN_DEAL = "BONGDOWN_DEAL";

    @Autowired
    private IBondDownService bondDownService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public BondDownDealVO insertOrUpdate(BondDownDealVO bondDownDealVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BondDownDealEntity> entities = null;
        if(StringUtils.isEmpty(bondDownDealVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONGDOWN_DEAL,tenantId);
            if(billCode.isSuccess()) {
                bondDownDealVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BondDownDealEntity entity = BeanMapper.map(bondDownDealVO, BondDownDealEntity.class);
        if(null!=bondDownDealVO.getId()&&bondDownDealVO.getId()>0){
            //编辑
            LambdaQueryWrapper<BondDownDealEntity> lambda = Wrappers.<BondDownDealEntity>lambdaQuery();
            lambda.eq(BondDownDealEntity::getBillCode, bondDownDealVO.getBillCode());
            lambda.eq(BondDownDealEntity::getTenantId, tenantId);
            lambda.ne(BondDownDealEntity::getId, bondDownDealVO.getId());
            entities = super.list(lambda);
            //需要将本次数据新增，将之前数据改为作废
            LambdaUpdateWrapper<BondDownDealEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(BondDownDealEntity::getId,entity.getId());
            updateWrapper.set(BondDownDealEntity::getDealStatus,"2");
            super.update(updateWrapper);
            entity.setId(null);
        }else{
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<BondDownDealEntity> lambda = Wrappers.<BondDownDealEntity>lambdaQuery();
            lambda.eq(BondDownDealEntity::getTenantId, tenantId);
            lambda.eq(BondDownDealEntity::getBillCode, bondDownDealVO.getBillCode());
            entities = super.list(lambda);
        }
        if(entities != null && entities.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setDealStatus("1");
        entity.setDealTime(new Date());
        super.saveOrUpdate(entity,false);
        //回写申请单
        LambdaUpdateWrapper<BondDownEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BondDownEntity::getId,entity.getBondId());
        updateWrapper.set(BondDownEntity::getBondStatus,"1");
        updateWrapper.set(BondDownEntity::getBeginDate,entity.getBeginDate());
        updateWrapper.set(BondDownEntity::getEndDate,entity.getEndDate());
        updateWrapper.set(BondDownEntity::getEmployeeId,entity.getEmployeeId());
        updateWrapper.set(BondDownEntity::getEmployeeName,entity.getEmployeeName());
        updateWrapper.set(BondDownEntity::getPayMny,entity.getBondMny());
        updateWrapper.set(BondDownEntity::getBondType,entity.getBondType());
        updateWrapper.set(BondDownEntity::getDealTime,entity.getDealTime());
        bondDownService.update(updateWrapper);
        return BeanMapper.map(entity, BondDownDealVO.class);
    }

    @Override
    public BondDownDealRentVO queryDetail(Long id) {
        BondDownDealRentVO vo = new BondDownDealRentVO();
        BondDownEntity upEntity = bondDownService.selectById(id);
        LambdaQueryWrapper<BondDownDealEntity> lambda = Wrappers.<BondDownDealEntity>lambdaQuery();
        lambda.eq(BondDownDealEntity::getBondId, id);
        lambda.orderBy(true,true,BondDownDealEntity::getDealStatus);
        List<BondDownDealEntity> list = super.list(lambda);
        vo = BeanMapper.map(upEntity,BondDownDealRentVO.class);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setDealRecord(BeanMapper.mapList(list,BondDownDealVO.class));
        }
        return vo;
    }
}
