package com.ejianc.business.finance.service.impl;

import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.callable.VoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service("deduction") 
public class DeductionBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	// 是否推送凭证
	private static final String VOUCHER_PARAM = "P-h5UC6769";

	@Autowired
	private IParamConfigApi paramConfigApi;
	@Autowired
	private IDeductionService deductionService;
	@Autowired
	private IVoucherApi voucherApi;
	@Autowired
	private HttpServletRequest request;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		DeductionEntity entity = deductionService.selectById(billId);
		CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
		if (byCode.isSuccess() && null != byCode.getData()) {
			ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
			String valueData = paramRegisterSetVO.getValueData();
			Long projectId = entity.getProjectId();
			if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
				ExecutorService threadPool = Executors.newFixedThreadPool(1);
				String authority = request.getHeader("authority");
				if (authority == null) {
					logger.info("request-authority为空");
					authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
				}
				try {
					VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT210924000000001", entity, SystemCodeEnum.FINANCE);
					Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, deductionService, voucherParams, VoucherOptFlag.SAVE, RequestContextHolder.getRequestAttributes(), authority);
					threadPool.submit(voucherCallable);
				} catch (Exception e) {
					logger.error("扣款单推送凭证异常, ", e);
				} finally {
					threadPool.shutdown();
				}

			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return11
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
        CommonResponse<String> stringCommonResponse = billTypeApi.checkQuote(billTypeCode, billId);
        boolean success = stringCommonResponse.isSuccess();
        if (!success)
        {
            return CommonResponse.error("已经被付款申请使用不能弃审和撤回");
        }
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		DeductionEntity entity = deductionService.selectById(billId);
		//更新凭证恢复到初始态
		if (VoucherFlag.SUCCESS.equals(entity.getVoucherFlag())) {
			//有凭证则删除
			ExecutorService threadPool = Executors.newFixedThreadPool(1);
			String authority = request.getHeader("authority");
			if (authority == null) {
				logger.info("request-authority为空");
				authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
			}
			try {
				VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT210924000000001", entity, SystemCodeEnum.FINANCE);
				Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, deductionService, voucherParams, VoucherOptFlag.DEL, RequestContextHolder.getRequestAttributes(), authority);

				threadPool.submit(voucherCallable);
			} catch (Exception e) {
				logger.error("扣款单撤回凭证异常, ", e);
			} finally {
				threadPool.shutdown();
			}
		}
		return CommonResponse.success();
	}

}
