/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.PayContractDeductionEntity;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayForegiftEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PayRecordSettleEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.mapper.PayRecordMapper;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.IPayContractDeductionService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPayRecordSettleService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.PayRecordMessageService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.NoticeEnum;
import com.ejianc.business.finance.vo.LoadApplyVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="payRecordService")
public class PayRecordServiceImpl
extends BaseServiceImpl<PayRecordMapper, PayRecordEntity>
implements IPayRecordService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayReimburseService reimburseService;
    @Autowired
    private IPayForegiftService foregiftService;
    @Autowired
    private ILoadApplyService loadApplyService;
    @Autowired
    private IPayContractSettleService contracctSettleService;
    @Autowired
    private IPayRecordSettleService settleService;
    @Autowired
    private ISubContractForPayApi subApi;
    @Autowired
    private IEquipmentContractApi equipmentApi;
    @Autowired
    private IMaterialSettlementApi materialApi;
    @Autowired
    private PayRecordMessageService payRecordMessageService;
    @Autowired
    private HttpServletRequest request;
    private static final String VOUCHER_PARAM = "P-h5UC6769";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IVoucherApi voucherApi;
    @Autowired
    private IPayContractDeductionService contractDeductionService;
    @Autowired
    private IDeductionService deductionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PayRecordVO insertOrUpdate(PayRecordVO vo) {
        Long projectId;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        CommonResponse byCode;
        Map recordMap;
        boolean b;
        PayRecordEntity entity = (PayRecordEntity)((Object)BeanMapper.map((Object)vo, PayRecordEntity.class));
        BigDecimal msgPayMny = BigDecimal.ZERO;
        VoucherParams voucherParams = null;
        ArrayList<VoucherParams> voucherParams4DedList = new ArrayList<VoucherParams>();
        if ("\u5408\u540c\u4ed8\u6b3e".equals(vo.getApplyType())) {
            PayContractEntity contract = (PayContractEntity)((Object)this.contractService.selectById(entity.getPayapplyId()));
            entity.setBillCode(contract.getBillCode());
            entity.setContractId(contract.getContractId());
            entity.setContractName(contract.getContractName());
            entity.setContractType(contract.getContractType());
            entity.setProjectId(contract.getProjectId());
            entity.setProjectName(contract.getProjectName());
            entity.setOrgId(contract.getOrgId());
            entity.setOrgName(contract.getOrgName());
            entity.setApplyUserId(contract.getApplyUserId());
            entity.setApplyUserName(contract.getApplyUserName());
            entity.setApplyTime(contract.getApplyTime());
            entity.setApplyMny(contract.getApplyMny());
            entity.setReceiveUnitId(contract.getReceiveUnitId());
            entity.setReceiveUnitName(contract.getReceiveUnitName());
            entity.setFeeType(contract.getFeeType());
            b = super.saveOrUpdate((Object)entity);
            if (b) {
                recordMap = DataConvertUtil.objToMap((Object)((Object)entity));
                PayContractVO payContractVO = (PayContractVO)BeanMapper.map((Object)((Object)contract), PayContractVO.class);
                payContractVO.set_payRecordId(recordMap);
                voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200611000000017", (Object)payContractVO, (SystemCodeEnum)SystemCodeEnum.FINANCE);
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"payapply_id", (Object)entity.getPayapplyId());
                List payContractDeductionEntityList = this.contractDeductionService.list((Wrapper)wrapper);
                if (CollectionUtils.isNotEmpty((Collection)payContractDeductionEntityList)) {
                    List dedIdList = payContractDeductionEntityList.stream().map(PayContractDeductionEntity::getDeductionId).collect(Collectors.toList());
                    List deductionEntities = (List)this.deductionService.listByIds(dedIdList);
                    for (int a = 0; a < deductionEntities.size(); ++a) {
                        DeductionEntity deductionEntity = (DeductionEntity)((Object)deductionEntities.get(a));
                        VoucherParams voucherParamsDed = VoucherParams.newInstanceByOrgId((String)"BT210924000000001", (Object)((Object)deductionEntity), (SystemCodeEnum)SystemCodeEnum.FINANCE);
                        voucherParams4DedList.add(voucherParamsDed);
                    }
                }
            }
            contract.setPayStatus(2);
            contract.setConfirmTime(entity.getConfirmTime());
            contract.setEmployeeId(entity.getEmployeeId());
            contract.setEmployeeName(entity.getEmployeeName());
            contract.setPayMny(MathUtil.safeAdd((BigDecimal)contract.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = contract.getPayMny();
            this.contractService.saveOrUpdate((Object)contract);
            List<PayRecordSettleEntity> settleList = this.calculateSettlePayMny(entity);
            this.writeBackSumPayMny(entity.getPayapplyId(), entity, settleList, true);
        } else if ("\u96f6\u661f\u91c7\u8d2d".equals(vo.getApplyType())) {
            PaySporadicEntity sporadic = (PaySporadicEntity)((Object)this.sporadicService.selectById(entity.getPayapplyId()));
            entity.setBillCode(sporadic.getBillCode());
            entity.setProjectId(sporadic.getProjectId());
            entity.setProjectName(sporadic.getProjectName());
            entity.setOrgId(sporadic.getOrgId());
            entity.setOrgName(sporadic.getOrgName());
            entity.setApplyUserId(sporadic.getApplyUserId());
            entity.setApplyUserName(sporadic.getApplyUserName());
            entity.setApplyTime(sporadic.getApplyTime());
            entity.setApplyMny(sporadic.getApplyMny());
            super.saveOrUpdate((Object)entity);
            sporadic.setPayStatus(2);
            sporadic.setConfirmTime(entity.getConfirmTime());
            sporadic.setEmployeeId(entity.getEmployeeId());
            sporadic.setEmployeeName(entity.getEmployeeName());
            sporadic.setPayMny(MathUtil.safeAdd((BigDecimal)sporadic.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = sporadic.getPayMny();
            this.sporadicService.saveOrUpdate((Object)sporadic);
            if (MathUtil.safeCompareTo((BigDecimal)sporadic.getPayMny(), (BigDecimal)sporadic.getApplyMny()) >= 0) {
                sporadic.setProportionFlag("0");
                sporadic.setRelationFlag("0");
                this.sporadicService.costPush(sporadic);
            }
        } else if ("\u62a5\u9500".equals(vo.getApplyType())) {
            PayReimburseEntity reimburse = (PayReimburseEntity)((Object)this.reimburseService.selectById(entity.getPayapplyId()));
            entity.setBillCode(reimburse.getBillCode());
            entity.setProjectId(reimburse.getProjectId());
            entity.setProjectName(reimburse.getProjectName());
            entity.setOrgId(reimburse.getOrgId());
            entity.setOrgName(reimburse.getOrgName());
            entity.setApplyUserId(reimburse.getApplyUserId());
            entity.setApplyUserName(reimburse.getApplyUserName());
            entity.setApplyTime(reimburse.getApplyTime());
            entity.setApplyMny(reimburse.getApplyMny());
            entity.setFeeType(reimburse.getFeeType());
            b = super.saveOrUpdate((Object)entity);
            if (b) {
                recordMap = DataConvertUtil.objToMap((Object)((Object)entity));
                PayReimburseVO payReimburseVO = (PayReimburseVO)BeanMapper.map((Object)((Object)reimburse), PayReimburseVO.class);
                payReimburseVO.set_payRecordId(recordMap);
                voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200529000000002", (Object)payReimburseVO, (SystemCodeEnum)SystemCodeEnum.FINANCE);
            }
            reimburse.setPayStatus(2);
            reimburse.setConfirmTime(entity.getConfirmTime());
            reimburse.setEmployeeId(entity.getEmployeeId());
            reimburse.setEmployeeName(entity.getEmployeeName());
            reimburse.setPayMny(MathUtil.safeAdd((BigDecimal)reimburse.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = reimburse.getPayMny();
            this.reimburseService.saveOrUpdate((Object)reimburse);
            if (MathUtil.safeCompareTo((BigDecimal)reimburse.getPayMny(), (BigDecimal)reimburse.getApplyMny()) >= 0) {
                reimburse.setProportionFlag("0");
                reimburse.setRelationFlag("0");
                this.reimburseService.costPush(reimburse);
            }
        } else if ("\u62bc\u91d1".equals(vo.getApplyType())) {
            PayForegiftEntity foregift = (PayForegiftEntity)((Object)this.foregiftService.selectById(entity.getPayapplyId()));
            entity.setBillCode(foregift.getBillCode());
            entity.setContractId(foregift.getContractId());
            entity.setContractName(foregift.getContractName());
            entity.setContractType(foregift.getContractType());
            entity.setProjectId(foregift.getProjectId());
            entity.setProjectName(foregift.getProjectName());
            entity.setOrgId(foregift.getOrgId());
            entity.setOrgName(foregift.getOrgName());
            entity.setApplyUserId(foregift.getApplyUserId());
            entity.setApplyUserName(foregift.getApplyUserName());
            entity.setApplyTime(foregift.getApplyTime());
            entity.setApplyMny(foregift.getApplyMny());
            entity.setReceiveUnitId(foregift.getReceiveUnitId());
            entity.setReceiveUnitName(foregift.getReceiveUnitName());
            super.saveOrUpdate((Object)entity);
            foregift.setPayStatus(2);
            foregift.setConfirmTime(entity.getConfirmTime());
            foregift.setEmployeeId(entity.getEmployeeId());
            foregift.setEmployeeName(entity.getEmployeeName());
            foregift.setPayMny(MathUtil.safeAdd((BigDecimal)foregift.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = foregift.getPayMny();
            this.foregiftService.saveOrUpdate((Object)foregift);
        } else if ("\u5907\u7528\u91d1".equals(vo.getApplyType())) {
            LoadApplyEntity loadApplyEntity = (LoadApplyEntity)((Object)this.loadApplyService.selectById(entity.getPayapplyId()));
            entity.setBillCode(loadApplyEntity.getBillCode());
            entity.setProjectId(loadApplyEntity.getProjectId());
            entity.setProjectName(loadApplyEntity.getProjectName());
            entity.setOrgId(loadApplyEntity.getOrgId());
            entity.setOrgName(loadApplyEntity.getOrgName());
            entity.setApplyUserId(loadApplyEntity.getApplyEmployeeId());
            entity.setApplyUserName(loadApplyEntity.getApplyEmployeeName());
            entity.setApplyTime(loadApplyEntity.getApplyTime());
            entity.setApplyMny(loadApplyEntity.getApplyMny());
            b = super.saveOrUpdate((Object)entity);
            if (b) {
                recordMap = DataConvertUtil.objToMap((Object)((Object)entity));
                LoadApplyVO loadApplyVO = (LoadApplyVO)BeanMapper.map((Object)((Object)loadApplyEntity), LoadApplyVO.class);
                loadApplyVO.set_payRecordId(recordMap);
                voucherParams = VoucherParams.newInstanceByOrgId((String)"BT200629000000001", (Object)loadApplyVO, (SystemCodeEnum)SystemCodeEnum.FINANCE);
            }
            loadApplyEntity.setPayStatus(2);
            loadApplyEntity.setConfirmTime(entity.getConfirmTime());
            loadApplyEntity.setEmployeeId(entity.getEmployeeId());
            loadApplyEntity.setEmployeeName(entity.getEmployeeName());
            loadApplyEntity.setPayMny(MathUtil.safeAdd((BigDecimal)loadApplyEntity.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = loadApplyEntity.getPayMny();
            this.loadApplyService.saveOrUpdate((Object)loadApplyEntity);
        }
        PayRecordVO payRecordVO = (PayRecordVO)BeanMapper.map((Object)((Object)entity), PayRecordVO.class);
        payRecordVO.setMsgPayMny(msgPayMny);
        payRecordVO.setMsgBillCode(entity.getBillCode());
        payRecordVO.setMsgId(entity.getId());
        String[] receivers = String.valueOf(payRecordVO.getApplyUserId()).split(",");
        this.payRecordMessageService.sendMsg(payRecordVO, receivers, NoticeEnum.PAY_SUCCESS);
        if (voucherParams != null && (byCode = this.paramConfigApi.getByCode(VOUCHER_PARAM)).isSuccess() && null != byCode.getData() && ((valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData()).equals(String.valueOf(projectId = entity.getProjectId())) || "\u662f".equals(valueData))) {
            ExecutorService threadPool = Executors.newFixedThreadPool(1 + voucherParams4DedList.size());
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                this.logger.info("request-authority\u4e3a\u7a7a");
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            try {
                AccplatVoucherCallable voucherCallable = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this, voucherParams, "save", RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
                for (VoucherParams params : voucherParams4DedList) {
                    AccplatVoucherCallable voucherCallable1 = new AccplatVoucherCallable(this.voucherApi, (IBaseService)this.deductionService, params, "save", RequestContextHolder.getRequestAttributes(), authority);
                    threadPool.submit(voucherCallable1);
                }
            }
            catch (Exception e) {
                this.logger.error(this.getClass() + "\u63a8\u9001\u51ed\u8bc1\u5f02\u5e38, ", (Throwable)e);
            }
            finally {
                threadPool.shutdown();
            }
        }
        return payRecordVO;
    }

    private List<PayRecordSettleEntity> calculateSettlePayMny(PayRecordEntity entity) {
        BigDecimal pendPayMny = entity.getThisPayMny();
        List contractSettleList = this.contracctSettleService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)entity.getPayapplyId()));
        ArrayList<PayRecordSettleEntity> settleLsit = new ArrayList<PayRecordSettleEntity>();
        for (PayContractSettleEntity contractSettle : contractSettleList) {
            BigDecimal surplusPayMny = MathUtil.safeSub((BigDecimal)contractSettle.getBodyApplyMny(), (BigDecimal)contractSettle.getSumPayMny());
            if (MathUtil.safeCompareTo((BigDecimal)pendPayMny, (BigDecimal)BigDecimal.ZERO) <= 0 || MathUtil.safeCompareTo((BigDecimal)surplusPayMny, (BigDecimal)BigDecimal.ZERO) <= 0) continue;
            PayRecordSettleEntity settle = new PayRecordSettleEntity();
            settle.setRecordId(entity.getId());
            settle.setPayapplyId(entity.getPayapplyId());
            settle.setSettleId(contractSettle.getSettleId());
            settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
            if (MathUtil.safeCompareTo((BigDecimal)pendPayMny, (BigDecimal)surplusPayMny) > 0) {
                settle.setSettlePayMny(surplusPayMny);
            } else {
                settle.setSettlePayMny(pendPayMny);
            }
            pendPayMny = MathUtil.safeSub((BigDecimal)pendPayMny, (BigDecimal)settle.getSettlePayMny());
            contractSettle.setSumPayMny(MathUtil.safeAdd((BigDecimal)contractSettle.getSumPayMny(), (BigDecimal)settle.getSettlePayMny()));
            settleLsit.add(settle);
        }
        if (CollectionUtils.isNotEmpty(settleLsit)) {
            this.settleService.saveOrUpdateBatch(settleLsit);
            this.contracctSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }

    public boolean writeBackSumPayMny(Long billId, PayRecordEntity entity, List<PayRecordSettleEntity> settleList, boolean flag) {
        BigDecimal payMny = flag ? entity.getThisPayMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)entity.getThisPayMny());
        BigDecimal prepayMny = null != entity.getFeeType() && entity.getFeeType() == 1L ? payMny : BigDecimal.ZERO;
        HashMap<Long, BigDecimal> settleMnyMap = new HashMap<Long, BigDecimal>();
        BigDecimal pendPayMny = payMny;
        for (PayRecordSettleEntity settle : settleList) {
            BigDecimal applyMny = flag ? settle.getSettlePayMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)settle.getSettlePayMny());
            settleMnyMap.put(settle.getSettleId(), applyMny);
        }
        if (entity.getContractType() == 1L) {
            this.subApi.updateSubContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.subApi.updateSubSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 2L) {
            this.equipmentApi.updatePurchaseContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.equipmentApi.updatePurchaseSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 3L) {
            this.equipmentApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.equipmentApi.updateRentSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 4L) {
            for (PayRecordSettleEntity settle : settleList) {
                this.materialApi.updateSettlementBillAlreadyPaidAmount(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 5L) {
            // empty if block
        }
        return true;
    }

    @Override
    public PayRecordVO returnPayment(PayRecordVO vo) {
        BigDecimal msgPayMny = BigDecimal.ZERO;
        PayRecordEntity entity = (PayRecordEntity)((Object)BeanMapper.map((Object)vo, PayRecordEntity.class));
        if ("\u5408\u540c\u4ed8\u6b3e".equals(vo.getApplyType())) {
            entity.setThisPayMny(entity.getThisPayMny().negate());
            PayContractEntity contract = (PayContractEntity)((Object)this.contractService.selectById(entity.getPayapplyId()));
            entity.setBillCode(contract.getBillCode());
            entity.setContractId(contract.getContractId());
            entity.setContractName(contract.getContractName());
            entity.setContractType(contract.getContractType());
            entity.setProjectId(contract.getProjectId());
            entity.setProjectName(contract.getProjectName());
            entity.setOrgId(contract.getOrgId());
            entity.setOrgName(contract.getOrgName());
            entity.setApplyUserId(contract.getApplyUserId());
            entity.setApplyUserName(contract.getApplyUserName());
            entity.setApplyTime(contract.getApplyTime());
            entity.setApplyMny(contract.getApplyMny());
            entity.setReceiveUnitId(contract.getReceiveUnitId());
            entity.setReceiveUnitName(contract.getReceiveUnitName());
            entity.setFeeType(contract.getFeeType());
            super.saveOrUpdate((Object)entity);
            contract.setPayStatus(2);
            contract.setConfirmTime(entity.getConfirmTime());
            contract.setEmployeeId(entity.getEmployeeId());
            contract.setEmployeeName(entity.getEmployeeName());
            contract.setPayMny(MathUtil.safeAdd((BigDecimal)contract.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = contract.getPayMny();
            this.contractService.saveOrUpdate((Object)contract);
            List<PayRecordSettleEntity> settleList = this.calcSettlePayMnyAfterReturnPayment(entity);
            this.writeBackSumPayMnyAfterReturnPayment(entity, settleList);
            if (vo.getClosed().booleanValue()) {
                this.contractService.closePayment(vo.getPayapplyId());
            }
        }
        PayRecordVO payRecordVO = (PayRecordVO)BeanMapper.map((Object)((Object)entity), PayRecordVO.class);
        return payRecordVO;
    }

    private List<PayRecordSettleEntity> calcSettlePayMnyAfterReturnPayment(PayRecordEntity entity) {
        ArrayList<PayRecordSettleEntity> settleLsit = new ArrayList<PayRecordSettleEntity>();
        BigDecimal pendPayMny = entity.getThisPayMny().negate();
        List contractSettleList = this.contracctSettleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PayContractSettleEntity::getPayapplyId, (Object)entity.getPayapplyId())).orderByDesc(BaseEntity::getCreateTime));
        for (PayContractSettleEntity contractSettle : contractSettleList) {
            if (MathUtil.safeCompareTo((BigDecimal)pendPayMny, (BigDecimal)BigDecimal.ZERO) <= 0) continue;
            PayRecordSettleEntity settle = new PayRecordSettleEntity();
            settle.setRecordId(entity.getId());
            settle.setPayapplyId(entity.getPayapplyId());
            settle.setSettleId(contractSettle.getSettleId());
            settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
            if (MathUtil.safeCompareTo((BigDecimal)contractSettle.getSumPayMny(), (BigDecimal)pendPayMny) >= 0) {
                settle.setReturnPayMny(pendPayMny);
                contractSettle.setSumPayMny(MathUtil.safeSub((BigDecimal)contractSettle.getSumPayMny(), (BigDecimal)pendPayMny));
                pendPayMny = BigDecimal.ZERO;
            } else {
                settle.setReturnPayMny(contractSettle.getSumPayMny());
                pendPayMny = MathUtil.safeSub((BigDecimal)pendPayMny, (BigDecimal)contractSettle.getSumPayMny());
                contractSettle.setSumPayMny(BigDecimal.ZERO);
            }
            settle.setSettlePayMny(contractSettle.getSumPayMny());
            settleLsit.add(settle);
        }
        if (CollectionUtils.isNotEmpty(settleLsit)) {
            this.settleService.saveOrUpdateBatch(settleLsit);
            this.contracctSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }

    public boolean writeBackSumPayMnyAfterReturnPayment(PayRecordEntity entity, List<PayRecordSettleEntity> settleList) {
        BigDecimal payMny = entity.getThisPayMny();
        BigDecimal prepayMny = null != entity.getFeeType() && entity.getFeeType() == 1L ? payMny : BigDecimal.ZERO;
        HashMap<Long, BigDecimal> settleMnyMap = new HashMap<Long, BigDecimal>();
        BigDecimal pendPayMny = payMny;
        for (PayRecordSettleEntity settle : settleList) {
            settleMnyMap.put(settle.getSettleId(), settle.getReturnPayMny().negate());
        }
        if (entity.getContractType() == 1L) {
            this.subApi.updateSubContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.subApi.updateSubSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 2L) {
            this.equipmentApi.updatePurchaseContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.equipmentApi.updatePurchaseSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 3L) {
            this.equipmentApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.equipmentApi.updateRentSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 4L) {
            for (PayRecordSettleEntity settle : settleList) {
                this.materialApi.updateSettlementBillAlreadyPaidAmount(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        return true;
    }
}

